/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.fantasyfurniture.common.block.furniture;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import xyz.apex.forge.apexcore.lib.block.BaseMultiBlock;
import xyz.apex.forge.apexcore.lib.block.MultiBlockPattern;
import xyz.apex.forge.fantasyfurniture.AllBlocks;
import xyz.apex.forge.fantasyfurniture.AllParticleTypes;
import xyz.apex.forge.fantasyfurniture.AllPatterns;
import xyz.apex.forge.fantasyfurniture.common.block.furniture.IDyeable;
import xyz.apex.forge.fantasyfurniture.core.HitBoxes;

public class FloorLightBlock
extends BaseMultiBlock {
    public static final EnumProperty<Part> PART = EnumProperty.m_61587_((String)"part", Part.class);

    public FloorLightBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(PART, (Comparable)((Object)Part.BOTTOM)));
    }

    protected void registerProperties(Consumer<Property<?>> consumer) {
        super.registerProperties(consumer);
        consumer.accept((Property<?>)WATERLOGGED);
        consumer.accept((Property<?>)PART);
    }

    public void m_214162_(BlockState blockState, Level level, BlockPos pos, RandomSource rng) {
        if (!FloorLightBlock.isWaterLogged((BlockState)blockState) && blockState.m_61145_(PART).orElse(Part.BOTTOM).isTop()) {
            this.spawnLightParticles(blockState, level, pos, rng);
        }
    }

    protected void spawnLightParticles(BlockState blockState, Level level, BlockPos pos, RandomSource rng) {
        if (AllBlocks.NORDIC_FLOOR_LIGHT.isIn(blockState)) {
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 0.5 + 0.34;
            double z = (double)pos.m_123343_() + 0.5;
            this.onLightParticle(level, pos, blockState, x + 0.27, y, z, rng);
            this.onLightParticle(level, pos, blockState, x - 0.27, y, z, rng);
            this.onLightParticle(level, pos, blockState, x, y, z + 0.27, rng);
            this.onLightParticle(level, pos, blockState, x, y, z - 0.27, rng);
        } else if (AllBlocks.DUNMER_FLOOR_LIGHT.isIn(blockState)) {
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 0.5 + 0.5;
            double z = (double)pos.m_123343_() + 0.5;
            this.onLightParticle(level, pos, blockState, x, y, z, rng);
        } else if (AllBlocks.VENTHYR_FLOOR_LIGHT.isIn(blockState)) {
            if (blockState.m_61145_(PART).orElse(Part.BOTTOM) == Part.TOP) {
                double x = (double)pos.m_123341_() + 0.3;
                double y = (double)pos.m_123342_() + 0.9;
                double z = (double)pos.m_123343_() + 0.3;
                this.onLightParticle(level, pos, blockState, x, y, z, rng);
                this.onLightParticle(level, pos, blockState, x + 0.4, y, z, rng);
                this.onLightParticle(level, pos, blockState, x, y, z + 0.4, rng);
                this.onLightParticle(level, pos, blockState, x + 0.4, y, z + 0.4, rng);
            }
        } else if (AllBlocks.BONE_SKELETON_FLOOR_LIGHT.isIn(blockState) || AllBlocks.BONE_WITHER_FLOOR_LIGHT.isIn(blockState) || AllBlocks.ROYAL_FLOOR_LIGHT.isIn(blockState) || AllBlocks.NECROLORD_FLOOR_LIGHT.isIn(blockState)) {
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 0.5 + 0.45;
            double z = (double)pos.m_123343_() + 0.5;
            double offsetH = 0.25;
            double offsetV = 0.05;
            if (AllBlocks.ROYAL_FLOOR_LIGHT.isIn(blockState)) {
                y += 0.075;
            } else if (AllBlocks.NECROLORD_FLOOR_LIGHT.isIn(blockState)) {
                offsetH = 0.3;
                y += 0.05;
            }
            this.onLightParticle(level, pos, blockState, x, y, z, rng);
            this.onLightParticle(level, pos, blockState, x + offsetH, y - offsetV, z, rng);
            this.onLightParticle(level, pos, blockState, x - offsetH, y - offsetV, z, rng);
        }
    }

    protected void onLightParticle(Level level, BlockPos pos, BlockState blockState, double pX, double pY, double pZ, RandomSource rng) {
        SimpleParticleType flame = ParticleTypes.f_123744_;
        if (AllBlocks.BONE_WITHER_FLOOR_LIGHT.isIn(blockState)) {
            flame = ParticleTypes.f_123745_;
        } else if (AllBlocks.NECROLORD_FLOOR_LIGHT.isIn(blockState)) {
            flame = (SimpleParticleType)AllParticleTypes.NECROLORD_FLAME.get();
        }
        level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, pX, pY, pZ, 0.0, 0.0, 0.0);
        level.m_7106_((ParticleOptions)flame, pX, pY, pZ, 0.0, 0.0, 0.0);
    }

    public MultiBlockPattern getMultiBlockPattern() {
        return AllPatterns.PATTERN_1x1x2_PAINTING;
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        if (AllBlocks.NORDIC_FLOOR_LIGHT.isIn(blockState)) {
            return HitBoxes.NORDIC.floorLight(this, blockState);
        }
        if (AllBlocks.DUNMER_FLOOR_LIGHT.isIn(blockState)) {
            return HitBoxes.DUNMER.floorLight(this, blockState);
        }
        if (AllBlocks.VENTHYR_FLOOR_LIGHT.isIn(blockState)) {
            return HitBoxes.VENTHYR.floorLight(this, blockState);
        }
        if (AllBlocks.BONE_SKELETON_FLOOR_LIGHT.isIn(blockState) || AllBlocks.BONE_WITHER_FLOOR_LIGHT.isIn(blockState)) {
            return HitBoxes.BONE.floorLight(this, blockState);
        }
        if (AllBlocks.ROYAL_FLOOR_LIGHT.isIn(blockState)) {
            return HitBoxes.ROYAL.floorLight(this, blockState);
        }
        if (AllBlocks.NECROLORD_FLOOR_LIGHT.isIn(blockState)) {
            return HitBoxes.NECROLORD.floorLight(this, blockState);
        }
        return super.m_5940_(blockState, level, pos, ctx);
    }

    public static enum Part implements StringRepresentable
    {
        TOP("top"),
        BOTTOM("bottom");

        public final String serializedName;

        private Part(String serializedName) {
            this.serializedName = serializedName;
        }

        public boolean isTop() {
            return this == TOP;
        }

        public boolean isBottom() {
            return this == BOTTOM;
        }

        public String m_7912_() {
            return this.serializedName;
        }
    }

    public static class Dyeable
    extends FloorLightBlock
    implements IDyeable {
        public Dyeable(BlockBehaviour.Properties properties) {
            super(properties);
            this.m_49959_(IDyeable.registerDefaultBlockState(this.m_49966_()));
        }

        public MaterialColor getMapColor(BlockState blockState, BlockGetter level, BlockPos pos, MaterialColor defaultColor) {
            MaterialColor color = super.getMapColor(blockState, level, pos, defaultColor);
            return IDyeable.getDyedMapColor(blockState, level, pos, color);
        }

        @Override
        protected void registerProperties(Consumer<Property<?>> consumer) {
            super.registerProperties(consumer);
            IDyeable.registerProperties(consumer);
        }

        @Nullable
        protected BlockState modifyPlacementState(BlockState placementBlockState, BlockPlaceContext ctx) {
            placementBlockState = super.modifyPlacementState(placementBlockState, ctx);
            return IDyeable.getStateForPlacement(ctx, placementBlockState);
        }

        public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
            InteractionResult interactionResult = IDyeable.use(blockState, level, pos, player, hand);
            if (interactionResult.m_19077_()) {
                return interactionResult;
            }
            return super.m_6227_(blockState, level, pos, player, hand, result);
        }

        public ItemStack getCloneItemStack(BlockState blockState, HitResult target, BlockGetter level, BlockPos pos, Player player) {
            ItemStack stack = super.getCloneItemStack(blockState, target, level, pos, player);
            return IDyeable.getCloneItemStack(blockState, level, pos, stack);
        }

        public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
            super.m_5871_(stack, level, tooltip, flag);
            IDyeable.appendHoverText(this, tooltip);
        }
    }

    public static class WithFacing
    extends FloorLightBlock {
        public WithFacing(BlockBehaviour.Properties properties) {
            super(properties);
        }

        @Override
        protected void registerProperties(Consumer<Property<?>> consumer) {
            super.registerProperties(consumer);
            consumer.accept((Property<?>)FACING_4_WAY);
        }

        @Override
        protected void spawnLightParticles(BlockState blockState, Level level, BlockPos pos, RandomSource rng) {
            if (AllBlocks.BONE_SKELETON_FLOOR_LIGHT.isIn(blockState) || AllBlocks.BONE_WITHER_FLOOR_LIGHT.isIn(blockState) || AllBlocks.ROYAL_FLOOR_LIGHT.isIn(blockState) || AllBlocks.NECROLORD_FLOOR_LIGHT.isIn(blockState)) {
                double x = (double)pos.m_123341_() + 0.5;
                double y = (double)pos.m_123342_() + 0.5 + 0.45;
                double z = (double)pos.m_123343_() + 0.5;
                double offsetH = 0.25;
                double offsetV = 0.05;
                if (AllBlocks.ROYAL_FLOOR_LIGHT.isIn(blockState)) {
                    y += 0.075;
                } else if (AllBlocks.NECROLORD_FLOOR_LIGHT.isIn(blockState)) {
                    offsetH = 0.3;
                    y += 0.05;
                }
                Direction facing = WithFacing.getFacing((BlockState)blockState).m_122427_();
                int stepX = facing.m_122429_();
                int stepZ = facing.m_122431_();
                this.onLightParticle(level, pos, blockState, x, y, z, rng);
                this.onLightParticle(level, pos, blockState, x + (double)stepX * offsetH, y - offsetV, z + (double)stepZ * offsetH, rng);
                this.onLightParticle(level, pos, blockState, x - (double)stepX * offsetH, y - offsetV, z - (double)stepZ * offsetH, rng);
            }
        }
    }
}

