/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.net.serverbound;

import java.util.function.BiConsumer;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.connection.Lettered;
import me.paulf.fairylights.server.net.ConnectionMessage;
import me.paulf.fairylights.server.net.ServerMessageContext;
import me.paulf.fairylights.util.styledstring.StyledString;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class EditLetteredConnectionMessage<C extends Connection>
extends ConnectionMessage {
    private StyledString text;

    public EditLetteredConnectionMessage() {
    }

    public EditLetteredConnectionMessage(C connection, StyledString text) {
        super((Connection)connection);
        this.text = text;
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        super.encode(buf);
        buf.m_130079_(StyledString.serialize(this.text));
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        super.decode(buf);
        this.text = StyledString.deserialize(buf.m_130260_());
    }

    public static final class Handler
    implements BiConsumer<EditLetteredConnectionMessage<?>, ServerMessageContext> {
        @Override
        public void accept(EditLetteredConnectionMessage<?> message, ServerMessageContext context) {
            ServerPlayer player = context.getPlayer();
            this.accept(message, player);
        }

        @Override
        private <C extends Connection> void accept(EditLetteredConnectionMessage<C> message, ServerPlayer player) {
            if (player != null) {
                ConnectionMessage.getConnection(message, c -> c instanceof Lettered, player.f_19853_).ifPresent(connection -> {
                    if (connection.isModifiable((Player)player) && ((Lettered)((Object)connection)).isSupportedText(message.text)) {
                        ((Lettered)((Object)connection)).setText(message.text);
                    }
                });
            }
        }
    }
}

