/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.item;

import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import me.paulf.fairylights.FairyLights;
import me.paulf.fairylights.server.block.FLBlocks;
import me.paulf.fairylights.server.block.LightBlock;
import me.paulf.fairylights.server.item.ColorLightItem;
import me.paulf.fairylights.server.item.ConnectionItem;
import me.paulf.fairylights.server.item.GarlandConnectionItem;
import me.paulf.fairylights.server.item.HangingLightsConnectionItem;
import me.paulf.fairylights.server.item.LetterBuntingConnectionItem;
import me.paulf.fairylights.server.item.LightItem;
import me.paulf.fairylights.server.item.PennantBuntingConnectionItem;
import me.paulf.fairylights.server.item.PennantItem;
import me.paulf.fairylights.server.item.TinselConnectionItem;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class FLItems {
    public static final DeferredRegister<Item> REG = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"fairylights");
    public static final RegistryObject<ConnectionItem> HANGING_LIGHTS = REG.register("hanging_lights", () -> new HangingLightsConnectionItem(FLItems.defaultProperties()));
    public static final RegistryObject<ConnectionItem> PENNANT_BUNTING = REG.register("pennant_bunting", () -> new PennantBuntingConnectionItem(FLItems.defaultProperties()));
    public static final RegistryObject<ConnectionItem> TINSEL = REG.register("tinsel", () -> new TinselConnectionItem(FLItems.defaultProperties()));
    public static final RegistryObject<ConnectionItem> LETTER_BUNTING = REG.register("letter_bunting", () -> new LetterBuntingConnectionItem(FLItems.defaultProperties()));
    public static final RegistryObject<ConnectionItem> GARLAND = REG.register("garland", () -> new GarlandConnectionItem(FLItems.defaultProperties()));
    public static final RegistryObject<LightItem> FAIRY_LIGHT = REG.register("fairy_light", FLItems.createColorLight(FLBlocks.FAIRY_LIGHT));
    public static final RegistryObject<LightItem> PAPER_LANTERN = REG.register("paper_lantern", FLItems.createColorLight(FLBlocks.PAPER_LANTERN));
    public static final RegistryObject<LightItem> ORB_LANTERN = REG.register("orb_lantern", FLItems.createColorLight(FLBlocks.ORB_LANTERN));
    public static final RegistryObject<LightItem> FLOWER_LIGHT = REG.register("flower_light", FLItems.createColorLight(FLBlocks.FLOWER_LIGHT));
    public static final RegistryObject<LightItem> CANDLE_LANTERN_LIGHT = REG.register("candle_lantern_light", FLItems.createColorLight(FLBlocks.CANDLE_LANTERN_LIGHT));
    public static final RegistryObject<LightItem> OIL_LANTERN_LIGHT = REG.register("oil_lantern_light", FLItems.createColorLight(FLBlocks.OIL_LANTERN_LIGHT));
    public static final RegistryObject<LightItem> JACK_O_LANTERN = REG.register("jack_o_lantern", FLItems.createColorLight(FLBlocks.JACK_O_LANTERN));
    public static final RegistryObject<LightItem> SKULL_LIGHT = REG.register("skull_light", FLItems.createColorLight(FLBlocks.SKULL_LIGHT));
    public static final RegistryObject<LightItem> GHOST_LIGHT = REG.register("ghost_light", FLItems.createColorLight(FLBlocks.GHOST_LIGHT));
    public static final RegistryObject<LightItem> SPIDER_LIGHT = REG.register("spider_light", FLItems.createColorLight(FLBlocks.SPIDER_LIGHT));
    public static final RegistryObject<LightItem> WITCH_LIGHT = REG.register("witch_light", FLItems.createColorLight(FLBlocks.WITCH_LIGHT));
    public static final RegistryObject<LightItem> SNOWFLAKE_LIGHT = REG.register("snowflake_light", FLItems.createColorLight(FLBlocks.SNOWFLAKE_LIGHT));
    public static final RegistryObject<LightItem> HEART_LIGHT = REG.register("heart_light", FLItems.createColorLight(FLBlocks.HEART_LIGHT));
    public static final RegistryObject<LightItem> MOON_LIGHT = REG.register("moon_light", FLItems.createColorLight(FLBlocks.MOON_LIGHT));
    public static final RegistryObject<LightItem> STAR_LIGHT = REG.register("star_light", FLItems.createColorLight(FLBlocks.STAR_LIGHT));
    public static final RegistryObject<LightItem> ICICLE_LIGHTS = REG.register("icicle_lights", FLItems.createColorLight(FLBlocks.ICICLE_LIGHTS));
    public static final RegistryObject<LightItem> METEOR_LIGHT = REG.register("meteor_light", FLItems.createColorLight(FLBlocks.METEOR_LIGHT));
    public static final RegistryObject<LightItem> OIL_LANTERN = REG.register("oil_lantern", FLItems.createLight(FLBlocks.OIL_LANTERN, LightItem::new));
    public static final RegistryObject<LightItem> CANDLE_LANTERN = REG.register("candle_lantern", FLItems.createLight(FLBlocks.CANDLE_LANTERN, LightItem::new));
    public static final RegistryObject<LightItem> INCANDESCENT_LIGHT = REG.register("incandescent_light", FLItems.createLight(FLBlocks.INCANDESCENT_LIGHT, LightItem::new));
    public static final RegistryObject<Item> TRIANGLE_PENNANT = REG.register("triangle_pennant", () -> new PennantItem(FLItems.defaultProperties()));
    public static final RegistryObject<Item> SPEARHEAD_PENNANT = REG.register("spearhead_pennant", () -> new PennantItem(FLItems.defaultProperties()));
    public static final RegistryObject<Item> SWALLOWTAIL_PENNANT = REG.register("swallowtail_pennant", () -> new PennantItem(FLItems.defaultProperties()));
    public static final RegistryObject<Item> SQUARE_PENNANT = REG.register("square_pennant", () -> new PennantItem(FLItems.defaultProperties()));

    private FLItems() {
    }

    private static Item.Properties defaultProperties() {
        return new Item.Properties().m_41491_(FairyLights.ITEM_GROUP);
    }

    private static Supplier<LightItem> createLight(RegistryObject<LightBlock> block, BiFunction<LightBlock, Item.Properties, LightItem> factory) {
        return () -> (LightItem)((Object)((Object)factory.apply((LightBlock)((Object)((Object)block.get())), FLItems.defaultProperties().m_41487_(16))));
    }

    private static Supplier<LightItem> createColorLight(RegistryObject<LightBlock> block) {
        return FLItems.createLight(block, ColorLightItem::new);
    }

    public static Stream<LightItem> lights() {
        return REG.getEntries().stream().flatMap(RegistryObject::stream).filter(LightItem.class::isInstance).map(LightItem.class::cast);
    }
}

