/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.connection;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import me.paulf.fairylights.server.block.FLBlocks;
import me.paulf.fairylights.server.connection.ConnectionType;
import me.paulf.fairylights.server.connection.HangingFeatureConnection;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.feature.FeatureType;
import me.paulf.fairylights.server.feature.light.Light;
import me.paulf.fairylights.server.feature.light.LightBehavior;
import me.paulf.fairylights.server.item.HangingLightsConnectionItem;
import me.paulf.fairylights.server.item.LightVariant;
import me.paulf.fairylights.server.item.SimpleLightVariant;
import me.paulf.fairylights.server.item.crafting.FLCraftingRecipes;
import me.paulf.fairylights.server.jingle.Jingle;
import me.paulf.fairylights.server.jingle.JinglePlayer;
import me.paulf.fairylights.server.sound.FLSounds;
import me.paulf.fairylights.server.string.StringType;
import me.paulf.fairylights.server.string.StringTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.ItemHandlerHelper;

public final class HangingLightsConnection
extends HangingFeatureConnection<Light<?>> {
    private static final int MAX_LIGHT = 15;
    private static final int LIGHT_UPDATE_WAIT = 400;
    private static final int LIGHT_UPDATE_RATE = 10;
    private StringType string;
    private List<ItemStack> pattern;
    private JinglePlayer jinglePlayer = new JinglePlayer();
    private boolean wasPlaying = false;
    private boolean isOn = true;
    private final Set<BlockPos> litBlocks = new HashSet<BlockPos>();
    private final Set<BlockPos> oldLitBlocks = new HashSet<BlockPos>();
    private int lightUpdateTime = (int)(Math.random() * 400.0 / 2.0);
    private int lightUpdateIndex;

    public HangingLightsConnection(ConnectionType<? extends HangingLightsConnection> type, Level world, Fastener<?> fastenerOrigin, UUID uuid) {
        super(type, world, fastenerOrigin, uuid);
        this.string = (StringType)StringTypes.BLACK_STRING.get();
        this.pattern = new ArrayList<ItemStack>();
    }

    public StringType getString() {
        return this.string;
    }

    @Nullable
    public Jingle getPlayingJingle() {
        return this.jinglePlayer.getJingle();
    }

    public void play(Jingle jingle, int lightOffset) {
        this.jinglePlayer.play(jingle, lightOffset);
    }

    @Override
    public boolean interact(Player player, Vec3 hit, FeatureType featureType, int feature, ItemStack heldStack, InteractionHand hand) {
        float pitch;
        SoundEvent lightSnd;
        int index;
        ItemStack light;
        if (featureType == FEATURE && heldStack.m_204117_(FLCraftingRecipes.LIGHTS) && !ItemStack.m_41728_((ItemStack)(light = this.pattern.get(index = feature % this.pattern.size())), (ItemStack)heldStack)) {
            ItemStack placed = heldStack.m_41620_(1);
            this.pattern.set(index, placed);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)light);
            this.computeCatenary();
            this.world.m_6263_(null, hit.f_82479_, hit.f_82480_, hit.f_82481_, (SoundEvent)FLSounds.FEATURE_COLOR_CHANGE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        if (super.interact(player, hit, featureType, feature, heldStack, hand)) {
            return true;
        }
        boolean bl = this.isOn = !this.isOn;
        if (this.isOn) {
            lightSnd = (SoundEvent)FLSounds.FEATURE_LIGHT_TURNON.get();
            pitch = 0.6f;
        } else {
            lightSnd = (SoundEvent)FLSounds.FEATURE_LIGHT_TURNOFF.get();
            pitch = 0.5f;
        }
        this.world.m_6263_(null, hit.f_82479_, hit.f_82480_, hit.f_82481_, lightSnd, SoundSource.BLOCKS, 1.0f, pitch);
        this.computeCatenary();
        return true;
    }

    @Override
    public void onUpdate() {
        this.jinglePlayer.tick(this.world, this.fastener.getConnectionPoint(), (Light[])this.features, this.world.m_5776_());
        boolean playing = this.jinglePlayer.isPlaying();
        if (playing || this.wasPlaying) {
            this.updateNeighbors(this.fastener);
            this.getDestination().get(this.world, false).ifPresent(this::updateNeighbors);
        }
        this.wasPlaying = playing;
        boolean on = !this.isDynamic() && this.isOn;
        for (Light light : (Light[])this.features) {
            light.tick(this.world, this.fastener.getConnectionPoint());
        }
        if (on && ((Light[])this.features).length > 0) {
            ++this.lightUpdateTime;
            if (this.lightUpdateTime > 400 && this.lightUpdateTime % 10 == 0) {
                if (this.lightUpdateIndex >= ((Light[])this.features).length) {
                    this.lightUpdateIndex = 0;
                    this.lightUpdateTime = this.world.f_46441_.m_188503_(200);
                } else {
                    this.setLight(new BlockPos(((Light[])this.features)[this.lightUpdateIndex++].getAbsolutePoint(this.fastener)));
                }
            }
        }
    }

    private void updateNeighbors(Fastener<?> fastener) {
        this.world.m_46717_(fastener.getPos(), (Block)FLBlocks.FASTENER.get());
    }

    protected Light<?>[] createFeatures(int length) {
        return new Light[length];
    }

    @Override
    protected boolean canReuse(Light<?> feature, int index) {
        return ItemStack.m_41728_((ItemStack)feature.getItem(), (ItemStack)this.getPatternStack(index));
    }

    @Override
    protected Light<?> createFeature(int index, Vec3 point, float yaw, float pitch) {
        ItemStack lightData = this.getPatternStack(index);
        return this.createLight(index, point, yaw, pitch, lightData, (LightVariant)LightVariant.get((ICapabilityProvider)lightData).orElse(SimpleLightVariant.FAIRY_LIGHT));
    }

    private ItemStack getPatternStack(int index) {
        return this.pattern.isEmpty() ? ItemStack.f_41583_ : this.pattern.get(index % this.pattern.size());
    }

    @Override
    protected void updateFeature(Light<?> light) {
        super.updateFeature(light);
        if (!this.isDynamic() && this.isOn) {
            BlockPos pos = new BlockPos(light.getAbsolutePoint(this.fastener));
            this.litBlocks.add(pos);
            this.setLight(pos);
        }
    }

    private <T extends LightBehavior> Light<T> createLight(int index, Vec3 point, float yaw, float pitch, ItemStack stack, LightVariant<T> variant) {
        return new Light<T>(index, point, yaw, pitch, stack, variant, 0.125f);
    }

    @Override
    protected float getFeatureSpacing() {
        if (this.pattern.isEmpty()) {
            return SimpleLightVariant.FAIRY_LIGHT.getSpacing();
        }
        float spacing = 0.0f;
        for (ItemStack patternLightData : this.pattern) {
            float lightSpacing = ((LightVariant)LightVariant.get((ICapabilityProvider)patternLightData).orElse(SimpleLightVariant.FAIRY_LIGHT)).getSpacing();
            if (!(lightSpacing > spacing)) continue;
            spacing = lightSpacing;
        }
        return spacing;
    }

    @Override
    protected void onBeforeUpdateFeatures() {
        this.oldLitBlocks.clear();
        this.oldLitBlocks.addAll(this.litBlocks);
        this.litBlocks.clear();
    }

    @Override
    protected void onAfterUpdateFeatures() {
        boolean on = !this.isDynamic() && this.isOn;
        for (Light light : (Light[])this.features) {
            light.power(on, this.isDynamic() || this.prevCatenary == null);
        }
        this.oldLitBlocks.removeAll(this.litBlocks);
        Iterator<BlockPos> oldIter = this.oldLitBlocks.iterator();
        while (oldIter.hasNext()) {
            this.removeLight(oldIter.next());
            oldIter.remove();
        }
    }

    @Override
    public void onRemove() {
        for (BlockPos pos : this.litBlocks) {
            this.removeLight(pos);
        }
    }

    private void removeLight(BlockPos pos) {
        if (this.world.m_8055_(pos).m_60713_(Blocks.f_152480_)) {
            this.world.m_7471_(pos, false);
        }
    }

    private void setLight(BlockPos pos) {
        if (this.world.m_46749_(pos) && this.world.m_46859_(pos) && this.world.m_45517_(LightLayer.BLOCK, pos) < 15) {
            this.world.m_7731_(pos, (BlockState)Blocks.f_152480_.m_49966_().m_61124_((Property)LightBlock.f_153657_, (Comparable)Integer.valueOf(15)), 2);
        }
    }

    public boolean canCurrentlyPlayAJingle() {
        return !this.jinglePlayer.isPlaying();
    }

    public float getJingleProgress() {
        return this.jinglePlayer.getProgress();
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag compound = super.serialize();
        compound.m_128365_("jinglePlayer", (Tag)this.jinglePlayer.serialize());
        compound.m_128379_("isOn", this.isOn);
        ListTag litBlocks = new ListTag();
        for (BlockPos litBlock : this.litBlocks) {
            litBlocks.add((Object)NbtUtils.m_129224_((BlockPos)litBlock));
        }
        compound.m_128365_("litBlocks", (Tag)litBlocks);
        return compound;
    }

    @Override
    public void deserialize(CompoundTag compound) {
        super.deserialize(compound);
        if (this.jinglePlayer == null) {
            this.jinglePlayer = new JinglePlayer();
        }
        if (!this.jinglePlayer.isPlaying()) {
            this.jinglePlayer.deserialize(compound.m_128469_("jinglePlayer"));
        }
        this.isOn = compound.m_128471_("isOn");
        this.litBlocks.clear();
        ListTag litBlocks = compound.m_128437_("litBlocks", 10);
        for (int i = 0; i < litBlocks.size(); ++i) {
            this.litBlocks.add(NbtUtils.m_129239_((CompoundTag)litBlocks.m_128728_(i)));
        }
    }

    @Override
    public CompoundTag serializeLogic() {
        CompoundTag compound = super.serializeLogic();
        HangingLightsConnectionItem.setString(compound, this.string);
        ListTag tagList = new ListTag();
        for (ItemStack light : this.pattern) {
            tagList.add((Object)light.m_41739_(new CompoundTag()));
        }
        compound.m_128365_("pattern", (Tag)tagList);
        return compound;
    }

    @Override
    public void deserializeLogic(CompoundTag compound) {
        super.deserializeLogic(compound);
        this.string = HangingLightsConnectionItem.getString(compound);
        ListTag patternList = compound.m_128437_("pattern", 10);
        this.pattern = new ArrayList<ItemStack>();
        for (int i = 0; i < patternList.size(); ++i) {
            CompoundTag lightCompound = patternList.m_128728_(i);
            this.pattern.add(ItemStack.m_41712_((CompoundTag)lightCompound));
        }
    }
}

