/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.block;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.paulf.fairylights.server.ServerEventHandler;
import me.paulf.fairylights.server.block.entity.FLBlockEntities;
import me.paulf.fairylights.server.block.entity.FastenerBlockEntity;
import me.paulf.fairylights.server.capability.CapabilityHandler;
import me.paulf.fairylights.server.connection.HangingLightsConnection;
import me.paulf.fairylights.server.fastener.accessor.BlockFastenerAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class FastenerBlock
extends DirectionalBlock
implements EntityBlock {
    public static final BooleanProperty TRIGGERED = BlockStateProperties.f_61360_;
    private static final VoxelShape NORTH_AABB = Block.m_49796_((double)6.0, (double)6.0, (double)12.0, (double)10.0, (double)10.0, (double)16.0);
    private static final VoxelShape SOUTH_AABB = Block.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)4.0);
    private static final VoxelShape WEST_AABB = Block.m_49796_((double)12.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    private static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)4.0, (double)10.0, (double)10.0);
    private static final VoxelShape DOWN_AABB = Block.m_49796_((double)6.0, (double)12.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape UP_AABB = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0);

    public FastenerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_52588_, (Comparable)Direction.NORTH)).m_61124_((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_52588_, TRIGGERED});
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)f_52588_, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)f_52588_)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return (BlockState)state.m_61124_((Property)f_52588_, (Comparable)mirrorIn.m_54848_((Direction)state.m_61143_((Property)f_52588_)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)f_52588_)) {
            case NORTH: {
                return NORTH_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case EAST: {
                return EAST_AABB;
            }
            case DOWN: {
                return DOWN_AABB;
            }
        }
        return UP_AABB;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FastenerBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.m_5776_()) {
            return FastenerBlock.createTickerHelper(type, (BlockEntityType)FLBlockEntities.FASTENER.get(), FastenerBlockEntity::tickClient);
        }
        return FastenerBlock.createTickerHelper(type, (BlockEntityType)FLBlockEntities.FASTENER.get(), FastenerBlockEntity::tick);
    }

    @Nullable
    private static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> actual, BlockEntityType<E> expect, BlockEntityTicker<? super E> ticker) {
        return expect == actual ? ticker : null;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity entity = world.m_7702_(pos);
            if (entity instanceof FastenerBlockEntity) {
                entity.getCapability(CapabilityHandler.FASTENER_CAP).ifPresent(f -> f.dropItems(world, pos));
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)f_52588_);
        BlockPos attachedPos = pos.m_121945_(facing.m_122424_());
        BlockState attachedState = world.m_8055_(attachedPos);
        return attachedState.m_204336_(BlockTags.f_13035_) || attachedState.m_60783_((BlockGetter)world, attachedPos, facing) || facing == Direction.UP && attachedState.m_204336_(BlockTags.f_13032_);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState result = this.m_49966_();
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        for (Direction dir : context.m_6232_()) {
            if (!(result = (BlockState)result.m_61124_((Property)f_52588_, (Comparable)dir.m_122424_())).m_60710_((LevelReader)world, pos)) continue;
            return (BlockState)result.m_61124_((Property)TRIGGERED, (Comparable)Boolean.valueOf(world.m_46753_(pos.m_121945_(dir))));
        }
        return null;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (state.m_60710_((LevelReader)world, pos)) {
            boolean receivingPower = world.m_46753_(pos);
            boolean isPowered = (Boolean)state.m_61143_((Property)TRIGGERED);
            if (receivingPower && !isPowered) {
                world.m_186460_(pos, (Block)this, 2);
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)TRIGGERED, (Comparable)Boolean.valueOf(true)), 4);
            } else if (!receivingPower && isPowered) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)), 4);
            }
        } else {
            BlockEntity entity = world.m_7702_(pos);
            FastenerBlock.m_49892_((BlockState)state, (LevelAccessor)world, (BlockPos)pos, (BlockEntity)entity);
            world.m_7471_(pos, false);
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        BlockEntity entity = world.m_7702_(pos);
        if (entity == null) {
            return super.m_6782_(state, world, pos);
        }
        return entity.getCapability(CapabilityHandler.FASTENER_CAP).map(f -> f.getAllConnections().stream()).orElse(Stream.empty()).filter(HangingLightsConnection.class::isInstance).map(HangingLightsConnection.class::cast).mapToInt(c -> (int)Math.ceil(c.getJingleProgress() * 15.0f)).max().orElse(0);
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        this.jingle((Level)world, pos);
    }

    private void jingle(Level world, BlockPos pos) {
        BlockEntity entity = world.m_7702_(pos);
        if (!(entity instanceof FastenerBlockEntity)) {
            return;
        }
        entity.getCapability(CapabilityHandler.FASTENER_CAP).ifPresent(fastener -> fastener.getAllConnections().stream().filter(HangingLightsConnection.class::isInstance).map(HangingLightsConnection.class::cast).filter(conn -> conn.canCurrentlyPlayAJingle() && conn.isDestination(new BlockFastenerAccessor(fastener.getPos())) && (Boolean)world.m_8055_(fastener.getPos()).m_61143_((Property)TRIGGERED) != false).findFirst().ifPresent(conn -> ServerEventHandler.tryJingle(world, conn)));
    }

    public Vec3 getOffset(Direction facing, float offset) {
        return FastenerBlock.getFastenerOffset(facing, offset);
    }

    public static Vec3 getFastenerOffset(Direction facing, float offset) {
        double x = offset;
        double y = offset;
        double z = offset;
        switch (facing) {
            case DOWN: {
                y += 0.75;
            }
            case UP: {
                x += 0.375;
                z += 0.375;
                break;
            }
            case WEST: {
                x += 0.75;
            }
            case EAST: {
                z += 0.375;
                y += 0.375;
                break;
            }
            case NORTH: {
                z += 0.75;
            }
            case SOUTH: {
                x += 0.375;
                y += 0.375;
            }
        }
        return new Vec3(x, y, z);
    }
}

