/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server;

import me.paulf.fairylights.FairyLights;
import me.paulf.fairylights.server.ServerProxy;
import me.paulf.fairylights.server.block.FLBlocks;
import me.paulf.fairylights.server.block.FastenerBlock;
import me.paulf.fairylights.server.block.entity.FastenerBlockEntity;
import me.paulf.fairylights.server.capability.CapabilityHandler;
import me.paulf.fairylights.server.connection.HangingLightsConnection;
import me.paulf.fairylights.server.entity.FenceFastenerEntity;
import me.paulf.fairylights.server.fastener.BlockFastener;
import me.paulf.fairylights.server.fastener.FenceFastener;
import me.paulf.fairylights.server.fastener.PlayerFastener;
import me.paulf.fairylights.server.feature.light.Light;
import me.paulf.fairylights.server.item.ConnectionItem;
import me.paulf.fairylights.server.jingle.Jingle;
import me.paulf.fairylights.server.jingle.JingleManager;
import me.paulf.fairylights.server.net.clientbound.JingleMessage;
import me.paulf.fairylights.server.net.clientbound.UpdateEntityFastenerMessage;
import me.paulf.fairylights.server.sound.FLSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEventPacket;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.NoteBlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class ServerEventHandler {
    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player || entity instanceof FenceFastenerEntity) {
            entity.getCapability(CapabilityHandler.FASTENER_CAP).ifPresent(f -> f.setWorld(event.getLevel()));
        }
    }

    @SubscribeEvent
    public void onAttachEntityCapability(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof Player) {
            event.addCapability(CapabilityHandler.FASTENER_ID, (ICapabilityProvider)new PlayerFastener((Player)entity));
        } else if (entity instanceof FenceFastenerEntity) {
            event.addCapability(CapabilityHandler.FASTENER_ID, (ICapabilityProvider)new FenceFastener((FenceFastenerEntity)entity));
        }
    }

    @SubscribeEvent
    public void onAttachBlockEntityCapability(AttachCapabilitiesEvent<BlockEntity> event) {
        BlockEntity entity = (BlockEntity)event.getObject();
        if (entity instanceof FastenerBlockEntity) {
            event.addCapability(CapabilityHandler.FASTENER_ID, (ICapabilityProvider)new BlockFastener((FastenerBlockEntity)entity, ServerProxy.buildBlockView()));
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            event.player.getCapability(CapabilityHandler.FASTENER_CAP).ifPresent(fastener -> {
                if (fastener.update() && !event.player.f_19853_.m_5776_()) {
                    ServerProxy.sendToPlayersWatchingEntity(new UpdateEntityFastenerMessage((Entity)event.player, fastener.serializeNBT()), (Entity)event.player);
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onNoteBlockPlay(NoteBlockEvent.Play event) {
        Level world = (Level)event.getLevel();
        BlockPos pos = event.getPos();
        Block noteBlock = world.m_8055_(pos).m_60734_();
        BlockState below = world.m_8055_(pos.m_7495_());
        if (below.m_60734_() == FLBlocks.FASTENER.get() && below.m_61143_((Property)FastenerBlock.f_52588_) == Direction.DOWN) {
            int note = event.getVanillaNoteId();
            float pitch = (float)Math.pow(2.0, (double)(note - 12) / 12.0);
            world.m_5594_(null, pos, (SoundEvent)FLSounds.JINGLE_BELL.get(), SoundSource.RECORDS, 3.0f, pitch);
            world.m_7106_((ParticleOptions)ParticleTypes.f_123758_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.2, (double)pos.m_123343_() + 0.5, (double)note / 24.0, 0.0, 0.0);
            if (!world.m_5776_()) {
                ClientboundBlockEventPacket pkt = new ClientboundBlockEventPacket(pos, noteBlock, event.getInstrument().ordinal(), note);
                PlayerList players = world.m_7654_().m_6846_();
                players.m_11241_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 64.0, world.m_46472_(), (Packet)pkt);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        HangingEntity entity;
        ItemStack offhandStack;
        BlockPos pos;
        Level world = event.getLevel();
        if (!(world.m_8055_(pos = event.getPos()).m_60734_() instanceof FenceBlock)) {
            return;
        }
        ItemStack stack = event.getItemStack();
        boolean checkHanging = stack.m_41720_() == Items.f_42655_;
        Player player = event.getEntity();
        if (event.getHand() == InteractionHand.MAIN_HAND && (offhandStack = player.m_21206_()).m_41720_() instanceof ConnectionItem) {
            if (checkHanging) {
                event.setCanceled(true);
                return;
            }
            event.setUseBlock(Event.Result.DENY);
        }
        if (!checkHanging && !world.m_5776_()) {
            double range = 7.0;
            int x = pos.m_123341_();
            int y = pos.m_123342_();
            int z = pos.m_123343_();
            AABB area = new AABB((double)x - 7.0, (double)y - 7.0, (double)z - 7.0, (double)x + 7.0, (double)y + 7.0, (double)z + 7.0);
            for (Mob entity2 : world.m_45976_(Mob.class, area)) {
                if (!entity2.m_21523_() || entity2.m_21524_() != player) continue;
                checkHanging = true;
                break;
            }
        }
        if (checkHanging && (entity = FenceFastenerEntity.findHanging(world, pos)) != null && !(entity instanceof LeashFenceKnotEntity)) {
            event.setCanceled(true);
        }
    }

    public static boolean tryJingle(Level world, HangingLightsConnection hangingLights) {
        String lib = FairyLights.CHRISTMAS.isOccurringNow() ? "christmas" : (FairyLights.HALLOWEEN.isOccurringNow() ? "halloween" : "");
        return ServerEventHandler.tryJingle(world, hangingLights, lib);
    }

    public static boolean tryJingle(Level world, HangingLightsConnection hangingLights, String lib) {
        if (world.m_5776_()) {
            return false;
        }
        Light[] lights = (Light[])hangingLights.getFeatures();
        Jingle jingle = JingleManager.INSTANCE.get(lib).getRandom(world.f_46441_, lights.length);
        if (jingle != null) {
            int lightOffset = lights.length / 2 - jingle.getRange() / 2;
            hangingLights.play(jingle, lightOffset);
            ServerProxy.sendToPlayersWatchingChunk(new JingleMessage(hangingLights, lightOffset, jingle), world, hangingLights.getFastener().getPos());
            return true;
        }
        return false;
    }
}

