/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.tutorial;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.paulf.fairylights.client.FLClientConfig;
import me.paulf.fairylights.server.item.FLItems;
import me.paulf.fairylights.server.item.crafting.FLCraftingRecipes;
import me.paulf.fairylights.util.LazyItemStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public class ClippyController {
    private final ImmutableMap<String, Supplier<State>> states = (ImmutableMap)Stream.of(NoProgressState::new, CraftHangingLightsState::new, CompleteState::new).collect(ImmutableMap.toImmutableMap(s -> ((State)s.get()).name(), Function.identity()));
    private State state = new NoProgressState();

    public void init(IEventBus modBus) {
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (event.getLevel() instanceof ClientLevel) {
                this.reload();
            }
        });
        MinecraftForge.EVENT_BUS.addListener(event -> {
            Minecraft mc = Minecraft.m_91087_();
            if (event.phase == TickEvent.Phase.END && !mc.m_91104_() && mc.f_91074_ != null) {
                this.state.tick(mc.f_91074_, this);
            }
        });
        modBus.addListener(e -> {
            if (e.getConfig().getSpec() == FLClientConfig.SPEC && Minecraft.m_91087_().f_91074_ != null) {
                this.reload();
            }
        });
        MinecraftForge.EVENT_BUS.addListener(e -> {
            this.reload();
            this.state.tick(e.getPlayer(), this);
        });
    }

    private void reload() {
        this.setState((State)((Supplier)this.states.getOrDefault(FLClientConfig.TUTORIAL.progress.get(), NoProgressState::new)).get());
    }

    private void setState(State state) {
        this.state.stop();
        this.state = state;
        this.state.start();
        FLClientConfig.TUTORIAL.progress.set((Object)this.state.name());
        FLClientConfig.TUTORIAL.progress.save();
    }

    static class NoProgressState
    implements State {
        NoProgressState() {
        }

        @Override
        public String name() {
            return "none";
        }

        @Override
        public void tick(LocalPlayer player, ClippyController controller) {
            if (player.m_150109_().m_204075_(FLCraftingRecipes.LIGHTS)) {
                controller.setState(new CraftHangingLightsState());
            }
        }
    }

    static interface State {
        public String name();

        default public void start() {
        }

        default public void tick(LocalPlayer player, ClippyController controller) {
        }

        default public void stop() {
        }
    }

    static class Balloon
    implements Toast {
        final LazyItemStack stack;
        final Component title;
        @Nullable
        final Component subtitle;
        Toast.Visibility visibility;

        Balloon(LazyItemStack stack, Component title, @Nullable Component subtitle) {
            this.stack = stack;
            this.title = title;
            this.subtitle = subtitle;
            this.visibility = Toast.Visibility.SHOW;
        }

        void hide() {
            this.visibility = Toast.Visibility.HIDE;
        }

        public Toast.Visibility m_7172_(PoseStack stack, ToastComponent toastGui, long delta) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)f_94893_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            toastGui.m_93228_(stack, 0, 0, 0, 96, 160, 32);
            toastGui.m_94929_().m_91291_().m_115218_(this.stack.get(), 8, 8);
            if (this.subtitle == null) {
                toastGui.m_94929_().f_91062_.m_92889_(stack, this.title, 30.0f, 12.0f, -11534256);
            } else {
                toastGui.m_94929_().f_91062_.m_92889_(stack, this.title, 30.0f, 7.0f, -11534256);
                toastGui.m_94929_().f_91062_.m_92889_(stack, this.subtitle, 30.0f, 18.0f, -16777216);
            }
            return this.visibility;
        }
    }

    static class CompleteState
    implements State {
        CompleteState() {
        }

        @Override
        public String name() {
            return "complete";
        }
    }

    static class CraftHangingLightsState
    implements State {
        final Balloon balloon = new Balloon(new LazyItemStack(FLItems.HANGING_LIGHTS, Item::m_7968_), (Component)Component.m_237115_((String)"tutorial.fairylights.craft_hanging_lights.title"), (Component)Component.m_237115_((String)"tutorial.fairylights.craft_hanging_lights.description"));

        CraftHangingLightsState() {
        }

        @Override
        public String name() {
            return "hanging_lights";
        }

        @Override
        public void start() {
            Minecraft.m_91087_().m_91300_().m_94922_((Toast)this.balloon);
        }

        @Override
        public void tick(LocalPlayer player, ClippyController controller) {
            if (!player.m_150109_().m_204075_(FLCraftingRecipes.LIGHTS) && !player.m_150109_().m_36056_().m_204117_(FLCraftingRecipes.LIGHTS)) {
                controller.setState(new NoProgressState());
            } else if (FLItems.HANGING_LIGHTS.filter(i -> player.m_150109_().m_36056_().m_41720_() == i || player.m_150109_().m_36063_(new ItemStack((ItemLike)i)) || player.m_108630_().m_13015_(Stats.f_12981_.m_12902_((Object)i)) > 0).isPresent()) {
                controller.setState(new CompleteState());
            }
        }

        @Override
        public void stop() {
            this.balloon.hide();
        }
    }
}

