/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.renderer.block.entity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import me.paulf.fairylights.client.ClientProxy;
import me.paulf.fairylights.client.FLModelLayers;
import me.paulf.fairylights.client.model.light.CandleLanternModel;
import me.paulf.fairylights.client.model.light.ColorCandleLanternModel;
import me.paulf.fairylights.client.model.light.ColorOilLanternModel;
import me.paulf.fairylights.client.model.light.FairyLightModel;
import me.paulf.fairylights.client.model.light.FlowerLightModel;
import me.paulf.fairylights.client.model.light.GhostLightModel;
import me.paulf.fairylights.client.model.light.HeartLightModel;
import me.paulf.fairylights.client.model.light.IcicleLightsModel;
import me.paulf.fairylights.client.model.light.IncandescentLightModel;
import me.paulf.fairylights.client.model.light.JackOLanternLightModel;
import me.paulf.fairylights.client.model.light.LightModel;
import me.paulf.fairylights.client.model.light.MeteorLightModel;
import me.paulf.fairylights.client.model.light.MoonLightModel;
import me.paulf.fairylights.client.model.light.OilLanternModel;
import me.paulf.fairylights.client.model.light.OrbLanternModel;
import me.paulf.fairylights.client.model.light.PaperLanternModel;
import me.paulf.fairylights.client.model.light.SkullLightModel;
import me.paulf.fairylights.client.model.light.SnowflakeLightModel;
import me.paulf.fairylights.client.model.light.SpiderLightModel;
import me.paulf.fairylights.client.model.light.StarLightModel;
import me.paulf.fairylights.client.model.light.WitchLightModel;
import me.paulf.fairylights.client.renderer.block.entity.ForwardingVertexConsumer;
import me.paulf.fairylights.server.feature.light.Light;
import me.paulf.fairylights.server.feature.light.LightBehavior;
import me.paulf.fairylights.server.item.LightVariant;
import me.paulf.fairylights.server.item.SimpleLightVariant;
import me.paulf.fairylights.util.FLMth;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraftforge.client.ForgeRenderTypes;

public class LightRenderer {
    private final LightModelProvider<LightBehavior> defaultLight = LightModelProvider.of(new DefaultModel());
    private final Map<LightVariant<?>, LightModelProvider<?>> lights;

    public LightRenderer(Function<ModelLayerLocation, ModelPart> baker) {
        this.lights = new ImmutableMap.Builder().put(SimpleLightVariant.FAIRY_LIGHT, LightModelProvider.of(new FairyLightModel(baker.apply(FLModelLayers.FAIRY_LIGHT)))).put(SimpleLightVariant.PAPER_LANTERN, LightModelProvider.of(new PaperLanternModel(baker.apply(FLModelLayers.PAPER_LANTERN)))).put(SimpleLightVariant.ORB_LANTERN, LightModelProvider.of(new OrbLanternModel(baker.apply(FLModelLayers.ORB_LANTERN)))).put(SimpleLightVariant.FLOWER_LIGHT, LightModelProvider.of(new FlowerLightModel(baker.apply(FLModelLayers.FLOWER_LIGHT)))).put(SimpleLightVariant.CANDLE_LANTERN_LIGHT, LightModelProvider.of(new ColorCandleLanternModel(baker.apply(FLModelLayers.CANDLE_LANTERN_LIGHT)))).put(SimpleLightVariant.OIL_LANTERN_LIGHT, LightModelProvider.of(new ColorOilLanternModel(baker.apply(FLModelLayers.OIL_LANTERN_LIGHT)))).put(SimpleLightVariant.JACK_O_LANTERN, LightModelProvider.of(new JackOLanternLightModel(baker.apply(FLModelLayers.JACK_O_LANTERN)))).put(SimpleLightVariant.SKULL_LIGHT, LightModelProvider.of(new SkullLightModel(baker.apply(FLModelLayers.SKULL_LIGHT)))).put(SimpleLightVariant.GHOST_LIGHT, LightModelProvider.of(new GhostLightModel(baker.apply(FLModelLayers.GHOST_LIGHT)))).put(SimpleLightVariant.SPIDER_LIGHT, LightModelProvider.of(new SpiderLightModel(baker.apply(FLModelLayers.SPIDER_LIGHT)))).put(SimpleLightVariant.WITCH_LIGHT, LightModelProvider.of(new WitchLightModel(baker.apply(FLModelLayers.WITCH_LIGHT)))).put(SimpleLightVariant.SNOWFLAKE_LIGHT, LightModelProvider.of(new SnowflakeLightModel(baker.apply(FLModelLayers.SNOWFLAKE_LIGHT)))).put(SimpleLightVariant.HEART_LIGHT, LightModelProvider.of(new HeartLightModel(baker.apply(FLModelLayers.HEART_LIGHT)))).put(SimpleLightVariant.MOON_LIGHT, LightModelProvider.of(new MoonLightModel(baker.apply(FLModelLayers.MOON_LIGHT)))).put(SimpleLightVariant.STAR_LIGHT, LightModelProvider.of(new StarLightModel(baker.apply(FLModelLayers.STAR_LIGHT)))).put(SimpleLightVariant.ICICLE_LIGHTS, LightModelProvider.of(new IcicleLightsModel[]{new IcicleLightsModel(baker.apply(FLModelLayers.ICICLE_LIGHTS_1), 1), new IcicleLightsModel(baker.apply(FLModelLayers.ICICLE_LIGHTS_2), 2), new IcicleLightsModel(baker.apply(FLModelLayers.ICICLE_LIGHTS_3), 3), new IcicleLightsModel(baker.apply(FLModelLayers.ICICLE_LIGHTS_4), 4)}, (models, i) -> models[i < 0 ? 3 : FLMth.mod(FLMth.hash(i), 4)])).put(SimpleLightVariant.METEOR_LIGHT, LightModelProvider.of(new MeteorLightModel(baker.apply(FLModelLayers.METEOR_LIGHT)))).put(SimpleLightVariant.OIL_LANTERN, LightModelProvider.of(new OilLanternModel(baker.apply(FLModelLayers.OIL_LANTERN)))).put(SimpleLightVariant.CANDLE_LANTERN, LightModelProvider.of(new CandleLanternModel(baker.apply(FLModelLayers.CANDLE_LANTERN)))).put(SimpleLightVariant.INCANDESCENT_LIGHT, LightModelProvider.of(new IncandescentLightModel(baker.apply(FLModelLayers.INCANDESCENT_LIGHT)))).build();
    }

    public Data start(MultiBufferSource source) {
        final VertexConsumer buf = ClientProxy.TRANSLUCENT_TEXTURE.m_119194_(source, ForgeRenderTypes::getUnsortedTranslucent);
        ForwardingVertexConsumer translucent = new ForwardingVertexConsumer(){

            @Override
            protected VertexConsumer delegate() {
                return buf;
            }

            @Override
            public VertexConsumer m_5601_(float x, float y, float z) {
                return super.m_5601_(0.0f, 1.0f, 0.0f);
            }
        };
        return new Data(buf, translucent);
    }

    public <T extends LightBehavior> LightModel<T> getModel(Light<?> light, int index) {
        return this.getModel(light.getVariant(), index);
    }

    public <T extends LightBehavior> LightModel<T> getModel(LightVariant<?> variant, int index) {
        return this.lights.getOrDefault(variant, this.defaultLight).get(index);
    }

    public void render(PoseStack matrix, Data data, Light<?> light, int index, float delta, int packedLight, int packedOverlay) {
        this.render(matrix, data, light, this.getModel(light, index), delta, packedLight, packedOverlay);
    }

    public <T extends LightBehavior> void render(PoseStack matrix, Data data, Light<T> light, LightModel<T> model, float delta, int packedLight, int packedOverlay) {
        model.animate(light, light.getBehavior(), delta);
        model.m_7695_(matrix, data.solid, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        model.renderTranslucent(matrix, data.translucent, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    static class DefaultModel
    extends LightModel<LightBehavior> {
        private static final ModelPart EMPTY = new ModelPart(List.of(), Map.of());

        public DefaultModel() {
            super(new ModelPart(List.of(), Map.of("lit", EMPTY, "lit_tint", EMPTY, "lit_tint_glow", EMPTY, "unlit", EMPTY)));
        }

        @Override
        public void m_7695_(PoseStack matrix, VertexConsumer builder, int light, int overlay, float r, float g, float b, float a) {
        }
    }

    static interface LightModelProvider<T extends LightBehavior> {
        public LightModel<T> get(int var1);

        public static <T extends LightBehavior> LightModelProvider<T> of(LightModel<T> model) {
            return i -> model;
        }

        public static <T extends LightBehavior> LightModelProvider<T> of(Supplier<LightModel<T>> model) {
            return i -> (LightModel)((Object)((Object)model.get()));
        }

        public static <T extends LightBehavior, D> LightModelProvider<T> of(D data, BiFunction<? super D, Integer, LightModel<T>> function) {
            return i -> (LightModel)((Object)((Object)function.apply((Object)data, i)));
        }
    }

    static class Data {
        final VertexConsumer solid;
        final VertexConsumer translucent;

        Data(VertexConsumer solid, VertexConsumer translucent) {
            this.solid = solid;
            this.translucent = translucent;
        }
    }
}

