/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import me.paulf.fairylights.FairyLights;
import me.paulf.fairylights.client.gui.component.ColorButton;
import me.paulf.fairylights.client.gui.component.PaletteButton;
import me.paulf.fairylights.client.gui.component.StyledTextFieldWidget;
import me.paulf.fairylights.client.gui.component.ToggleButton;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.connection.Lettered;
import me.paulf.fairylights.server.net.serverbound.EditLetteredConnectionMessage;
import me.paulf.fairylights.util.styledstring.StyledString;
import me.paulf.fairylights.util.styledstring.StylingPresence;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public final class EditLetteredConnectionScreen<C extends Connection>
extends Screen {
    public static final ResourceLocation WIDGETS_TEXTURE = new ResourceLocation("fairylights", "textures/gui/widgets.png");
    private final C connection;
    private StyledTextFieldWidget textField;
    private Button doneBtn;
    private Button cancelBtn;
    private ColorButton colorBtn;
    private ToggleButton boldBtn;
    private ToggleButton italicBtn;
    private ToggleButton underlineBtn;
    private ToggleButton strikethroughBtn;
    private PaletteButton paletteBtn;

    public EditLetteredConnectionScreen(C connection) {
        super((Component)Component.m_237119_());
        this.connection = connection;
    }

    public void m_7856_() {
        this.f_96541_.f_91068_.m_90926_(true);
        int pad = 4;
        int buttonWidth = 150;
        this.doneBtn = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 4 - 150, this.f_96544_ / 4 + 120 + 12, 150, 20, (Component)Component.m_237115_((String)"gui.done"), b -> {
            FairyLights.NETWORK.sendToServer(new EditLetteredConnectionMessage<C>(this.connection, this.textField.getValue()));
            this.m_7379_();
        }));
        this.cancelBtn = (Button)this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 4, this.f_96544_ / 4 + 120 + 12, 150, 20, (Component)Component.m_237115_((String)"gui.cancel"), b -> this.m_7379_()));
        int textFieldX = this.f_96543_ / 2 - 150;
        int textFieldY = this.f_96544_ / 2 - 10;
        int buttonX = textFieldX;
        int buttonY = textFieldY - 25;
        int bInc = 24;
        this.colorBtn = (ColorButton)this.m_142416_((GuiEventListener)new ColorButton(buttonX, buttonY, (Component)Component.m_237119_(), b -> {
            this.paletteBtn.f_93624_ = !this.paletteBtn.f_93624_;
        }));
        this.paletteBtn = (PaletteButton)this.m_142416_((GuiEventListener)new PaletteButton(buttonX - 4, buttonY - 30, this.colorBtn, (Component)Component.m_237115_((String)"fairylights.color"), b -> this.textField.updateStyling(this.colorBtn.getDisplayColor(), true)));
        this.boldBtn = (ToggleButton)this.m_142416_((GuiEventListener)new ToggleButton(buttonX += 24, buttonY, 40, 0, (Component)Component.m_237119_(), b -> this.updateStyleButton(ChatFormatting.BOLD, this.boldBtn)));
        this.italicBtn = (ToggleButton)this.m_142416_((GuiEventListener)new ToggleButton(buttonX += 24, buttonY, 60, 0, (Component)Component.m_237119_(), b -> this.updateStyleButton(ChatFormatting.ITALIC, this.italicBtn)));
        this.underlineBtn = (ToggleButton)this.m_142416_((GuiEventListener)new ToggleButton(buttonX += 24, buttonY, 80, 0, (Component)Component.m_237119_(), b -> this.updateStyleButton(ChatFormatting.UNDERLINE, this.underlineBtn)));
        this.strikethroughBtn = (ToggleButton)this.m_142416_((GuiEventListener)new ToggleButton(buttonX += 24, buttonY, 100, 0, (Component)Component.m_237119_(), b -> this.updateStyleButton(ChatFormatting.STRIKETHROUGH, this.strikethroughBtn)));
        this.textField = new StyledTextFieldWidget(this.f_96547_, this.colorBtn, this.boldBtn, this.italicBtn, this.underlineBtn, this.strikethroughBtn, textFieldX, textFieldY, 300, 20, (Component)Component.m_237115_((String)"fairylights.letteredText"));
        this.textField.setValue(((Lettered)this.connection).getText());
        this.textField.setCaretStart();
        this.textField.setIsBlurable(false);
        this.textField.registerChangeListener(this::validateText);
        this.textField.setCharInputTransformer(((Lettered)this.connection).getInputTransformer());
        this.textField.m_93692_(true);
        this.m_7787_((GuiEventListener)this.textField);
        this.paletteBtn.f_93624_ = false;
        StylingPresence ss = ((Lettered)this.connection).getSupportedStyling();
        this.colorBtn.f_93624_ = ss.hasColor();
        this.boldBtn.f_93624_ = ss.hasBold();
        this.italicBtn.f_93624_ = ss.hasItalic();
        this.underlineBtn.f_93624_ = ss.hasUnderline();
        this.strikethroughBtn.f_93624_ = ss.hasStrikethrough();
        this.m_94718_((GuiEventListener)this.textField);
    }

    private void validateText(StyledString text) {
        this.doneBtn.f_93623_ = ((Lettered)this.connection).isSupportedText(text) && !((Lettered)this.connection).getText().equals(text);
    }

    public void m_7861_() {
        this.f_96541_.f_91068_.m_90926_(false);
    }

    public void m_94757_(double x, double y) {
        this.textField.m_94757_(x, y);
    }

    public void m_86600_() {
        this.textField.tick();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        this.paletteBtn.f_93624_ = false;
        if (EditLetteredConnectionScreen.isControlOp(keyCode, 66)) {
            this.toggleStyleButton(ChatFormatting.BOLD, this.boldBtn);
            return true;
        }
        if (EditLetteredConnectionScreen.isControlOp(keyCode, 73)) {
            this.toggleStyleButton(ChatFormatting.ITALIC, this.italicBtn);
            return true;
        }
        if (EditLetteredConnectionScreen.isControlOp(keyCode, 85)) {
            this.toggleStyleButton(ChatFormatting.UNDERLINE, this.underlineBtn);
            return true;
        }
        if (EditLetteredConnectionScreen.isControlOp(keyCode, 83)) {
            this.toggleStyleButton(ChatFormatting.STRIKETHROUGH, this.strikethroughBtn);
            return true;
        }
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if ((keyCode == 257 || keyCode == 335) && this.doneBtn.f_93623_) {
            this.doneBtn.m_5691_();
            return true;
        }
        if (keyCode == 256) {
            this.cancelBtn.m_5691_();
            return true;
        }
        return false;
    }

    private void toggleStyleButton(ChatFormatting styling, ToggleButton btn) {
        btn.setValue(!btn.getValue());
        this.updateStyleButton(styling, btn);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (super.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        this.paletteBtn.f_93624_ = false;
        return false;
    }

    private void updateStyleButton(ChatFormatting styling, ToggleButton btn) {
        if (btn.f_93624_) {
            this.textField.updateStyling(styling, btn.getValue());
        }
    }

    public void m_6305_(PoseStack stack, int mouseX, int mouseY, float delta) {
        this.m_7333_(stack);
        EditLetteredConnectionScreen.m_93215_((PoseStack)stack, (Font)this.f_96547_, (Component)Component.m_237115_((String)"fairylights.editLetteredConnection"), (int)(this.f_96543_ / 2), (int)20, (int)0xFFFFFF);
        super.m_6305_(stack, mouseX, mouseY, delta);
        this.textField.m_6305_(stack, mouseX, mouseY, delta);
        String allowed = ((Lettered)this.connection).getAllowedDescription();
        if (!allowed.isEmpty()) {
            EditLetteredConnectionScreen.m_93243_((PoseStack)stack, (Font)this.f_96547_, (Component)Component.m_237110_((String)"fairylights.editLetteredConnection.allowed_characters", (Object[])new Object[]{allowed}).m_130940_(ChatFormatting.GRAY), (int)this.textField.f_93620_, (int)(this.textField.f_93621_ + 24), (int)-1);
        }
    }

    public static boolean isControlOp(int key, int controlKey) {
        return key == controlKey && Screen.m_96637_() && !Screen.m_96638_() && !Screen.m_96639_();
    }
}

