/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity.misc;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import immersive_aircraft.Config;
import immersive_aircraft.Main;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class Trail {
    private static final ResourceLocation identifier = Main.locate("textures/entity/trail.png");
    private final float[] buffer;
    private final int size;
    private final float gray;
    private int lastIndex;
    private int entries;
    private int nullEntries;

    public Trail(int length) {
        this(length, 1.0f);
    }

    public Trail(int length, float gray) {
        this.buffer = new float[7 * length];
        this.size = length;
        this.gray = gray;
    }

    public void add(Vector4f first, Vector4f second, float alpha) {
        Objects.requireNonNull(Config.getInstance());
        this.nullEntries = (double)alpha <= 0.0 ? ++this.nullEntries : 0;
        if (this.nullEntries < this.size) {
            int i = this.lastIndex * 7;
            this.buffer[i] = first.m_123601_();
            this.buffer[i + 1] = first.m_123615_();
            this.buffer[i + 2] = first.m_123616_();
            this.buffer[i + 3] = second.m_123601_();
            this.buffer[i + 4] = second.m_123615_();
            this.buffer[i + 5] = second.m_123616_();
            this.buffer[i + 6] = alpha;
        }
        this.lastIndex = (this.lastIndex + 1) % this.size;
        ++this.entries;
    }

    private void vertex(VertexConsumer lineVertexConsumer, Matrix3f matrix, float u, float v, int index, Vec3 pos, float a, int light) {
        Vector3f p = new Vector3f((float)((double)this.buffer[index] - pos.f_82479_), (float)((double)this.buffer[index + 1] - pos.f_82480_), (float)((double)this.buffer[index + 2] - pos.f_82481_));
        p.m_122249_(matrix);
        lineVertexConsumer.m_5954_(p.m_122239_(), p.m_122260_(), p.m_122269_(), this.gray, this.gray, this.gray, a, u, v, OverlayTexture.f_118083_, light, 1.0f, 0.0f, 0.0f);
    }

    public void render(MultiBufferSource vertexConsumerProvider, PoseStack.Pose matrices) {
        if (this.nullEntries >= this.size || this.entries == 0) {
            return;
        }
        VertexConsumer lineVertexConsumer = vertexConsumerProvider.m_6299_(RenderType.m_110460_((ResourceLocation)identifier, (boolean)true));
        int light = 0xF00000;
        Vec3 pos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        Matrix3f matrix = matrices.m_85864_();
        for (int i = 1; i < Math.min(this.entries, this.size); ++i) {
            int pre = (i + this.lastIndex - 1) % this.size * 7;
            int index = (i + this.lastIndex) % this.size * 7;
            int a1 = (int)((1.0f - (float)i / (float)this.size * 255.0f) * this.buffer[pre + 6]);
            int a2 = i == this.size - 1 ? 0 : (int)((1.0f - ((float)i + 1.0f) / (float)this.size * 255.0f) * this.buffer[index + 6]);
            this.vertex(lineVertexConsumer, matrix, 0.0f, 0.0f, pre, pos, a1, light);
            this.vertex(lineVertexConsumer, matrix, 0.0f, 1.0f, pre + 3, pos, a1, light);
            this.vertex(lineVertexConsumer, matrix, 1.0f, 1.0f, index + 3, pos, a2, light);
            this.vertex(lineVertexConsumer, matrix, 1.0f, 0.0f, index, pos, a2, light);
            this.vertex(lineVertexConsumer, matrix, 1.0f, 0.0f, index, pos, a2, light);
            this.vertex(lineVertexConsumer, matrix, 1.0f, 1.0f, index + 3, pos, a2, light);
            this.vertex(lineVertexConsumer, matrix, 0.0f, 1.0f, pre + 3, pos, a1, light);
            this.vertex(lineVertexConsumer, matrix, 0.0f, 0.0f, pre, pos, a1, light);
        }
    }
}

