/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import com.google.common.collect.Lists;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import immersive_aircraft.client.KeyBindings;
import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.network.c2s.CommandMessage;
import immersive_aircraft.util.InterpolatedFloat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.BlockUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class VehicleEntity
extends Entity {
    static final EntityDataAccessor<Integer> DAMAGE_WOBBLE_TICKS = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    static final EntityDataAccessor<Integer> DAMAGE_WOBBLE_SIDE = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    static final EntityDataAccessor<Float> DAMAGE_WOBBLE_STRENGTH = SynchedEntityData.m_135353_(VehicleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    int interpolationSteps;
    double x;
    double y;
    double z;
    double clientYaw;
    double clientPitch;
    float movementX;
    float movementY;
    float movementZ;
    public final InterpolatedFloat pressingInterpolatedX;
    public final InterpolatedFloat pressingInterpolatedY;
    public final InterpolatedFloat pressingInterpolatedZ;
    public float roll;
    public float prevRoll;
    protected static final Vector4f ZERO_VEC4 = new Vector4f();

    public float getRoll() {
        return this.roll;
    }

    public float getRoll(float tickDelta) {
        return Mth.m_14179_((float)tickDelta, (float)this.prevRoll, (float)this.getRoll());
    }

    protected abstract List<List<Vec3>> getPassengerPositions();

    protected int getPassengerSpace() {
        return this.getPassengerPositions().size();
    }

    public void m_146926_(float pitch) {
        float loops = (float)(Math.floor((pitch + 180.0f) / 360.0f) * 360.0);
        this.f_19860_ -= loops;
        super.m_146926_(pitch -= loops);
    }

    public VehicleEntity(EntityType<? extends AircraftEntity> entityType, Level world) {
        super(entityType, world);
        this.f_19850_ = true;
        this.f_19793_ = 0.55f;
        this.pressingInterpolatedX = new InterpolatedFloat(this.getInputInterpolationSteps());
        this.pressingInterpolatedY = new InterpolatedFloat(this.getInputInterpolationSteps());
        this.pressingInterpolatedZ = new InterpolatedFloat(this.getInputInterpolationSteps());
    }

    private float getInputInterpolationSteps() {
        return 10.0f;
    }

    protected float m_6380_(Pose pose, EntityDimensions dimensions) {
        return dimensions.f_20378_;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DAMAGE_WOBBLE_TICKS, (Object)0);
        this.f_19804_.m_135372_(DAMAGE_WOBBLE_SIDE, (Object)1);
        this.f_19804_.m_135372_(DAMAGE_WOBBLE_STRENGTH, (Object)Float.valueOf(0.0f));
    }

    public boolean m_7337_(Entity other) {
        return AircraftEntity.canCollide(this, other);
    }

    public static boolean canCollide(Entity entity, Entity other) {
        return (other.m_5829_() || other.m_6094_()) && !entity.m_20365_(other);
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6094_() {
        return true;
    }

    protected Vec3 m_7643_(Direction.Axis portalAxis, BlockUtil.FoundRectangle portalRect) {
        return LivingEntity.m_21289_((Vec3)super.m_7643_(portalAxis, portalRect));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (this.f_19853_.f_46443_ || this.m_213877_()) {
            return true;
        }
        if (source.m_7639_() != null && this.m_20363_(source.m_7639_())) {
            return false;
        }
        this.setDamageWobbleSide(-this.getDamageWobbleSide());
        this.setDamageWobbleTicks(10);
        this.setDamageWobbleStrength(this.getDamageWobbleStrength() + amount * 10.0f);
        this.m_146852_(GameEvent.f_223706_, source.m_7639_());
        if (this.getDamageWobbleStrength() > 60.0f) {
            if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                this.m_19998_((ItemLike)this.asItem());
            }
            this.m_146870_();
        }
        return true;
    }

    public void m_6845_(boolean drag) {
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() + (double)this.f_19796_.m_188501_(), this.m_20186_() + 0.7, this.m_20189_() + (double)this.f_19796_.m_188501_(), 0.0, 0.0, 0.0);
        if (this.f_19796_.m_188503_(20) == 0) {
            this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_5509_(), this.m_5720_(), 1.0f, 0.8f + 0.4f * this.f_19796_.m_188501_(), false);
        }
        this.m_146852_(GameEvent.f_157784_, this.m_6688_());
    }

    public void m_7334_(Entity entity) {
        if (entity instanceof AircraftEntity) {
            if (entity.m_20191_().f_82289_ < this.m_20191_().f_82292_) {
                super.m_7334_(entity);
            }
        } else if (entity.m_20191_().f_82289_ <= this.m_20191_().f_82289_) {
            super.m_7334_(entity);
        }
    }

    public Item asItem() {
        return Items.f_42746_;
    }

    public void m_6053_() {
        this.setDamageWobbleSide(-this.getDamageWobbleSide());
        this.setDamageWobbleTicks(10);
        this.setDamageWobbleStrength(this.getDamageWobbleStrength() * 11.0f);
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.clientYaw = yaw;
        this.clientPitch = pitch;
        this.interpolationSteps = 10;
    }

    public Direction m_6374_() {
        return this.m_6350_().m_122427_();
    }

    private static float getMovementMultiplier(boolean positive, boolean negative) {
        if (positive == negative) {
            return 0.0f;
        }
        return positive ? 1.0f : -1.0f;
    }

    boolean useAirplaneControls() {
        return false;
    }

    public void m_8119_() {
        Entity entity;
        if (this.f_19853_.m_5776_() && this.m_20197_().size() > 0 && (entity = (Entity)this.m_20197_().get(0)) instanceof LocalPlayer) {
            if (KeyBindings.dismount.m_90859_()) {
                NetworkHandler.sendToServer(new CommandMessage(CommandMessage.Key.DISMOUNT, this.m_20184_()));
            }
            this.setInputs(VehicleEntity.getMovementMultiplier(KeyBindings.left.m_90857_(), KeyBindings.right.m_90857_()), VehicleEntity.getMovementMultiplier(KeyBindings.up.m_90857_(), KeyBindings.down.m_90857_()), VehicleEntity.getMovementMultiplier(this.useAirplaneControls() ? KeyBindings.push.m_90857_() : KeyBindings.forward.m_90857_(), this.useAirplaneControls() ? KeyBindings.pull.m_90857_() : KeyBindings.backward.m_90857_()));
        }
        if (this.getDamageWobbleTicks() > 0) {
            this.setDamageWobbleTicks(this.getDamageWobbleTicks() - 1);
        }
        if (this.getDamageWobbleStrength() > 0.0f) {
            this.setDamageWobbleStrength(this.getDamageWobbleStrength() - 1.0f);
        }
        super.m_8119_();
        this.handleClientSync();
        if (this.m_6109_()) {
            this.updateVelocity();
            if (this.f_19853_.f_46443_) {
                this.updateController();
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
        }
        this.m_20101_();
        List list = this.f_19853_.m_6249_((Entity)this, this.m_20191_().m_82377_((double)0.2f, (double)-0.01f, (double)0.2f), EntitySelector.m_20421_((Entity)this));
        if (!list.isEmpty()) {
            boolean bl = !this.f_19853_.f_46443_ && !(this.m_6688_() instanceof Player);
            for (Entity entity2 : list) {
                if (entity2.m_20363_((Entity)this)) continue;
                if (bl && this.m_20197_().size() < this.getPassengerSpace() - 1 && !entity2.m_20159_() && entity2.m_20205_() < this.m_20205_() && entity2 instanceof LivingEntity && !(entity2 instanceof WaterAnimal) && !(entity2 instanceof Player)) {
                    entity2.m_20329_((Entity)this);
                    continue;
                }
                this.m_7334_(entity2);
            }
        }
        if (this.f_19853_.f_46443_) {
            this.pressingInterpolatedX.update(this.movementX);
            this.pressingInterpolatedY.update(this.movementY);
            this.pressingInterpolatedZ.update(this.movementZ);
        }
    }

    private void handleClientSync() {
        if (this.m_6109_()) {
            this.interpolationSteps = 0;
            this.m_217006_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.interpolationSteps <= 0) {
            return;
        }
        double interpolatedX = this.m_20185_() + (this.x - this.m_20185_()) / (double)this.interpolationSteps;
        double interpolatedY = this.m_20186_() + (this.y - this.m_20186_()) / (double)this.interpolationSteps;
        double interpolatedZ = this.m_20189_() + (this.z - this.m_20189_()) / (double)this.interpolationSteps;
        double interpolatedYaw = Mth.m_14175_((double)(this.clientYaw - (double)this.m_146908_()));
        this.m_146922_(this.m_146908_() + (float)interpolatedYaw / (float)this.interpolationSteps);
        this.m_146926_(this.m_146909_() + (float)(this.clientPitch - (double)this.m_146909_()) / (float)this.interpolationSteps);
        this.m_6034_(interpolatedX, interpolatedY, interpolatedZ);
        this.m_19915_(this.m_146908_(), this.m_146909_());
        --this.interpolationSteps;
    }

    abstract void updateVelocity();

    protected float getGravity() {
        return -0.04f;
    }

    abstract void updateController();

    public void m_7332_(Entity passenger) {
        int i;
        List<List<Vec3>> positions;
        if (!this.m_20363_(passenger)) {
            return;
        }
        Matrix4f transform = this.getVehicleTransform();
        int size = this.m_20197_().size() - 1;
        if (size < (positions = this.getPassengerPositions()).size() && (i = this.m_20197_().indexOf(passenger)) >= 0 && i < positions.get(size).size()) {
            Vec3 position = positions.get(size).get(i);
            if (passenger instanceof Animal) {
                position.m_82520_(0.0, 0.0, (double)0.2f);
            }
            position = position.m_82520_(0.0, passenger.m_6049_(), 0.0);
            Vector4f worldPosition = this.transformPosition(transform, (float)position.f_82479_, (float)position.f_82480_, (float)position.f_82481_);
            passenger.m_6034_((double)worldPosition.m_123601_(), (double)worldPosition.m_123615_(), (double)worldPosition.m_123616_());
            passenger.m_146922_(passenger.m_146908_() + (this.m_146908_() - this.f_19859_));
            passenger.m_5616_(passenger.m_6080_() + (this.m_146908_() - this.f_19859_));
            this.copyEntityData(passenger);
            if (passenger instanceof Animal && size > 1) {
                int angle = passenger.m_19879_() % 2 == 0 ? 90 : 270;
                passenger.m_5618_(((Animal)passenger).f_20883_ + (float)angle);
                passenger.m_5616_(passenger.m_6080_() + (float)angle);
            }
        }
    }

    private Vec3 getDismountOffset(double vehicleWidth, double passengerWidth) {
        double d = (vehicleWidth + passengerWidth + (double)1.0E-5f) / 2.0;
        float yaw = this.m_146908_() + 90.0f;
        float f = -Mth.m_14031_((float)(yaw * ((float)Math.PI / 180)));
        float g = Mth.m_14089_((float)(yaw * ((float)Math.PI / 180)));
        float h = Math.max(Math.abs(f), Math.abs(g));
        return new Vec3((double)f * d / (double)h, 0.0, (double)g * d / (double)h);
    }

    public Vec3 m_7688_(LivingEntity passenger) {
        if (this.m_20184_().m_82556_() < (double)0.1f) {
            double e;
            Vec3 vec3d = this.getDismountOffset(this.m_20205_() * Mth.f_13994_, passenger.m_20205_());
            double d = this.m_20185_() + vec3d.f_82479_;
            BlockPos blockPos = new BlockPos(d, this.m_20191_().f_82292_, e = this.m_20189_() + vec3d.f_82481_);
            BlockPos blockPos2 = blockPos.m_7495_();
            if (!this.f_19853_.m_46801_(blockPos2)) {
                double g;
                ArrayList list = Lists.newArrayList();
                double f = this.f_19853_.m_45573_(blockPos);
                if (DismountHelper.m_38439_((double)f)) {
                    list.add(new Vec3(d, (double)blockPos.m_123342_() + f, e));
                }
                if (DismountHelper.m_38439_((double)(g = this.f_19853_.m_45573_(blockPos2)))) {
                    list.add(new Vec3(d, (double)blockPos2.m_123342_() + g, e));
                }
                for (Pose entityPose : passenger.m_7431_()) {
                    for (Vec3 vec3d2 : list) {
                        if (!DismountHelper.m_150279_((CollisionGetter)this.f_19853_, (Vec3)vec3d2, (LivingEntity)passenger, (Pose)entityPose)) continue;
                        passenger.m_20124_(entityPose);
                        return vec3d2;
                    }
                }
            }
        }
        return super.m_7688_(passenger);
    }

    protected void copyEntityData(Entity entity) {
        entity.m_5618_(this.m_146908_());
        float f = Mth.m_14177_((float)(entity.m_146908_() - this.m_146908_()));
        float g = Mth.m_14036_((float)f, (float)-105.0f, (float)105.0f);
        entity.f_19859_ += g - f;
        entity.m_146922_(entity.m_146908_() + g - f);
        entity.m_5616_(entity.m_146908_());
    }

    public void m_7340_(Entity passenger) {
        this.copyEntityData(passenger);
    }

    protected void m_7380_(CompoundTag nbt) {
    }

    protected void m_7378_(CompoundTag nbt) {
    }

    public boolean m_20068_() {
        return true;
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player.m_36341_()) {
            return InteractionResult.PASS;
        }
        if (!this.f_19853_.f_46443_) {
            return player.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_20363_((Entity)player)) {
            return InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6478_(MoverType movementType, Vec3 movement) {
        float repeat;
        float collision;
        Vec3 prediction = this.m_20182_().m_82549_(movement);
        super.m_6478_(movementType, movement);
        if ((this.f_19863_ || this.f_19862_) && (collision = (float)(prediction.m_82546_(this.m_20182_()).m_82553_() - (double)Math.abs(this.getGravity()))) > 1.0E-4f && (repeat = 1.0f - (float)(this.getDamageWobbleTicks() + 1) / 10.0f) > 0.0f) {
            this.setDamageWobbleSide(-this.getDamageWobbleSide());
            this.setDamageWobbleTicks(10);
            this.setDamageWobbleStrength(this.getDamageWobbleStrength() + collision * 50.0f * repeat * repeat);
        }
    }

    protected void m_7840_(double heightDifference, boolean onGround, BlockState landedState, BlockPos landedPosition) {
    }

    public void setDamageWobbleStrength(float wobbleStrength) {
        this.f_19804_.m_135381_(DAMAGE_WOBBLE_STRENGTH, (Object)Float.valueOf(wobbleStrength));
    }

    public float getDamageWobbleStrength() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE_WOBBLE_STRENGTH)).floatValue();
    }

    public void setDamageWobbleTicks(int wobbleTicks) {
        this.f_19804_.m_135381_(DAMAGE_WOBBLE_TICKS, (Object)wobbleTicks);
    }

    public int getDamageWobbleTicks() {
        return (Integer)this.f_19804_.m_135370_(DAMAGE_WOBBLE_TICKS);
    }

    public void setDamageWobbleSide(int side) {
        this.f_19804_.m_135381_(DAMAGE_WOBBLE_SIDE, (Object)side);
    }

    public int getDamageWobbleSide() {
        return (Integer)this.f_19804_.m_135370_(DAMAGE_WOBBLE_SIDE);
    }

    protected boolean m_7310_(Entity passenger) {
        return this.m_20197_().size() < this.getPassengerSpace() && !this.m_204029_(FluidTags.f_13131_);
    }

    @Nullable
    public Entity m_6688_() {
        return this.m_146895_();
    }

    public void setInputs(float x, float y, float z) {
        this.movementX = x;
        this.movementY = y;
        this.movementZ = z;
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)this.asItem());
    }

    public boolean isWithinParticleRange() {
        return Minecraft.m_91087_().f_91063_.m_109153_().m_90583_().m_82557_(this.m_20182_()) < 1024.0;
    }

    protected Vector4f transformPosition(Matrix4f transform, float x, float y, float z) {
        Vector4f p0 = new Vector4f(x, y, z, 1.0f);
        p0.m_123607_(transform);
        return p0;
    }

    protected Vector3f transformVector(float x, float y, float z) {
        return this.transformVector(this.getVehicleNormalTransform(), x, y, z);
    }

    protected Vector3f transformVector(Matrix3f transform, float x, float y, float z) {
        Vector3f p0 = new Vector3f(x, y, z);
        p0.m_122249_(transform);
        return p0;
    }

    protected Matrix4f getVehicleTransform() {
        Matrix4f transform = Matrix4f.m_27653_((float)((float)this.m_20185_()), (float)((float)this.m_20186_()), (float)((float)this.m_20189_()));
        transform.m_27646_(Vector3f.f_122225_.m_122240_(-this.m_146908_()));
        transform.m_27646_(Vector3f.f_122223_.m_122240_(this.m_146909_()));
        transform.m_27646_(Vector3f.f_122227_.m_122240_(this.getRoll()));
        return transform;
    }

    protected Matrix3f getVehicleNormalTransform() {
        Matrix3f transform = Matrix3f.m_8174_((float)1.0f, (float)1.0f, (float)1.0f);
        transform.m_8171_(Vector3f.f_122225_.m_122240_(-this.m_146908_()));
        transform.m_8171_(Vector3f.f_122223_.m_122240_(this.m_146909_()));
        transform.m_8171_(Vector3f.f_122227_.m_122240_(this.getRoll()));
        return transform;
    }

    public Vec3 getDirection() {
        Vector3f f = this.transformVector(0.0f, 0.0f, 1.0f);
        return new Vec3((double)f.m_122239_(), (double)f.m_122260_(), (double)f.m_122269_());
    }

    public Vec3 getTopDirection() {
        Vector3f f = this.transformVector(0.0f, 1.0f, 0.0f);
        return new Vec3((double)f.m_122239_(), (double)f.m_122260_(), (double)f.m_122269_());
    }
}

