/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.Items;
import immersive_aircraft.Sounds;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.EngineAircraft;
import immersive_aircraft.entity.Rotorcraft;
import immersive_aircraft.entity.misc.AircraftProperties;
import java.util.List;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class GyrodyneEntity
extends Rotorcraft {
    private static final float PUSH_SPEED = 0.25f;
    private final AircraftProperties properties = new AircraftProperties().setYawSpeed(5.0f).setPitchSpeed(5.0f).setEngineSpeed(0.3f).setVerticalSpeed(0.04f).setDriftDrag(0.01f).setLift(0.1f).setRollFactor(30.0f).setWindSensitivity(0.025f).setMass(8.0f);
    final List<List<Vec3>> PASSENGER_POSITIONS = List.of(List.of(new Vec3(0.0, (double)-0.1f, (double)0.3f)), List.of(new Vec3(0.0, (double)-0.1f, (double)0.3f), new Vec3(0.0, (double)-0.1f, (double)-0.6f)));

    @Override
    public EngineAircraft.GUI_STYLE getGuiStyle() {
        return EngineAircraft.GUI_STYLE.NONE;
    }

    public GyrodyneEntity(EntityType<? extends AircraftEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    SoundEvent getEngineStartSound() {
        return Sounds.WOOSH.get();
    }

    @Override
    SoundEvent getEngineSound() {
        return Sounds.WOOSH.get();
    }

    @Override
    float getStabilizer() {
        return 0.3f;
    }

    @Override
    public AircraftProperties getProperties() {
        return this.properties;
    }

    @Override
    float getGroundVelocityDecay() {
        return 0.85f;
    }

    @Override
    float getHorizontalVelocityDelay() {
        return 0.925f;
    }

    @Override
    float getVerticalVelocityDelay() {
        return 0.9f;
    }

    @Override
    public Item asItem() {
        return Items.GYRODYNE.get();
    }

    @Override
    protected List<List<Vec3>> getPassengerPositions() {
        return this.PASSENGER_POSITIONS;
    }

    @Override
    protected float getGravity() {
        return (1.0f - this.getEnginePower()) * super.getGravity();
    }

    private void updateEnginePowerTooltip() {
        Entity entity = this.m_6688_();
        if (entity instanceof LocalPlayer) {
            LocalPlayer player = (LocalPlayer)entity;
            player.m_5661_((Component)Component.m_237110_((String)"immersive_aircraft.gyrodyne_target", (Object[])new Object[]{(int)(this.getEngineTarget() * 100.0f + 0.5f)}), true);
        }
    }

    @Override
    void updateController() {
        super.updateController();
        if (this.getEngineTarget() < 1.0f) {
            Entity entity;
            this.setEngineTarget(Math.max(0.0f, Math.min(1.0f, this.getEngineTarget() + this.pressingInterpolatedZ.getValue() * 0.05f - 0.035f)));
            this.updateEnginePowerTooltip();
            if ((double)this.getEngineTarget() == 1.0 && (entity = this.m_6688_()) instanceof LocalPlayer) {
                LocalPlayer player = (LocalPlayer)entity;
                player.m_5661_((Component)Component.m_237115_((String)"immersive_aircraft.gyrodyne_target_reached"), true);
                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.25, 0.0));
            }
        }
        float power = this.getEnginePower() * this.properties.getVerticalSpeed() * this.pressingInterpolatedY.getSmooth();
        this.m_20256_(this.m_20184_().m_82549_(this.getTopDirection().m_82490_((double)power)));
        Vec3 direction = this.getDirection();
        float sin = Mth.m_14031_((float)(this.m_146909_() * ((float)Math.PI / 180)));
        float thrust = (float)(Math.pow(this.getEnginePower(), 2.0) * (double)this.properties.getEngineSpeed()) * sin;
        if (this.f_19861_) {
            thrust = 0.25f * this.pressingInterpolatedZ.getSmooth() * ((double)this.pressingInterpolatedZ.getSmooth() > 0.0 ? 1.0f : 0.5f) * this.getEnginePower();
        }
        this.m_20256_(this.m_20184_().m_82549_(direction.m_82490_((double)thrust)));
    }
}

