/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.Sounds;
import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.network.c2s.EnginePowerMessage;
import immersive_aircraft.util.InterpolatedFloat;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public abstract class EngineAircraft
extends AircraftEntity {
    static final EntityDataAccessor<Float> ENGINE = SynchedEntityData.m_135353_(EngineAircraft.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public final InterpolatedFloat engineRotation = new InterpolatedFloat();
    public final InterpolatedFloat enginePower = new InterpolatedFloat(20.0f);
    public float engineSpinupStrength = 0.0f;
    public float engineSound = 0.0f;

    public GUI_STYLE getGuiStyle() {
        return GUI_STYLE.ENGINE;
    }

    public EngineAircraft(EntityType<? extends AircraftEntity> entityType, Level world) {
        super(entityType, world);
    }

    SoundEvent getEngineStartSound() {
        return Sounds.ENGINE_START.get();
    }

    SoundEvent getEngineSound() {
        return Sounds.PROPELLER.get();
    }

    float getStabilizer() {
        return 0.0f;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ENGINE, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.enginePower.update(this.getEngineTarget() * (this.f_19798_ ? 0.1f : 1.0f));
        this.engineSpinupStrength = Math.max(0.0f, this.engineSpinupStrength + this.enginePower.getDiff() - 0.01f);
        if (this.f_19853_.m_5776_()) {
            this.engineRotation.update((this.engineRotation.getValue() + this.getEnginePower()) % 1000.0f);
        } else if (!this.m_20160_()) {
            this.setEngineTarget(0.0f);
        }
        if (this.f_19853_.f_46443_) {
            this.engineSound += this.getEnginePower() * 0.25f;
            if (this.engineSound > 1.0f) {
                this.engineSound -= 1.0f;
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getEngineSound(), this.m_5720_(), Math.min(1.0f, 0.25f + this.engineSpinupStrength), this.f_19796_.m_188501_() * 0.1f + 0.95f, false);
            }
        }
    }

    @Override
    void updateController() {
        this.m_146922_(this.m_146908_() - this.getProperties().getYawSpeed() * this.pressingInterpolatedX.getSmooth());
        if (!this.f_19861_) {
            this.m_146926_(this.m_146909_() + this.getProperties().getPitchSpeed() * this.pressingInterpolatedZ.getSmooth());
        }
        this.m_146926_(this.m_146909_() * (1.0f - this.getStabilizer()));
    }

    @Override
    void updateVelocity() {
        super.updateVelocity();
        if (this.f_19861_) {
            this.m_146926_((this.m_146909_() + this.getProperties().getGroundPitch()) * 0.9f - this.getProperties().getGroundPitch());
        }
    }

    public float getEnginePower() {
        return this.enginePower.getSmooth();
    }

    public float getEngineTarget() {
        return ((Float)this.f_19804_.m_135370_(ENGINE)).floatValue();
    }

    public void setEngineTarget(float engineTarget) {
        if (this.f_19853_.f_46443_) {
            if (this.getEngineTarget() != engineTarget) {
                NetworkHandler.sendToServer(new EnginePowerMessage(engineTarget));
            }
            if ((double)this.getEngineTarget() == 0.0 && engineTarget > 0.0f) {
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.getEngineStartSound(), this.m_5720_(), 1.0f, 1.0f, false);
            }
        }
        this.f_19804_.m_135381_(ENGINE, (Object)Float.valueOf(engineTarget));
    }

    public static enum GUI_STYLE {
        NONE,
        ENGINE;

    }
}

