/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import immersive_aircraft.Items;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.AirplaneEntity;
import immersive_aircraft.entity.misc.Trail;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BiplaneEntity
extends AirplaneEntity {
    final List<List<Vec3>> PASSENGER_POSITIONS = List.of(List.of(new Vec3(0.0, (double)0.05f, (double)-0.6f)));
    private final List<Trail> trails = List.of(new Trail(40), new Trail(40));

    public BiplaneEntity(EntityType<? extends AircraftEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    protected List<List<Vec3>> getPassengerPositions() {
        return this.PASSENGER_POSITIONS;
    }

    @Override
    public List<Trail> getTrails() {
        return this.trails;
    }

    private void trail(Matrix4f transform, int index, float x, float y, float z) {
        Vector4f p0 = this.transformPosition(transform, x, y - 0.15f, z);
        Vector4f p1 = this.transformPosition(transform, x, y + 0.15f, z);
        float trailStrength = Math.max(0.0f, Math.min(1.0f, (float)(Math.sqrt(this.m_20184_().m_82553_()) * (double)(0.5f + this.pressingInterpolatedX.getSmooth() * x * 0.025f) - 0.25)));
        this.trails.get(index).add(p0, p1, trailStrength);
    }

    @Override
    public Item asItem() {
        return Items.BIPLANE.get();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            if (this.isWithinParticleRange()) {
                Matrix4f transform = this.getVehicleTransform();
                Matrix3f normalTransform = this.getVehicleNormalTransform();
                this.trail(transform, 0, -3.75f, 0.25f, 0.6f);
                this.trail(transform, 1, 3.75f, 0.25f, 0.6f);
                float power = this.getEnginePower();
                if ((double)power > 0.05) {
                    Vector4f p = this.transformPosition(transform, 0.325f * (this.f_19797_ % 4 == 0 ? -1.0f : 1.0f), 0.5f, 0.8f);
                    Vector3f vel = this.transformVector(normalTransform, 0.2f * (this.f_19797_ % 4 == 0 ? -1.0f : 1.0f), 0.0f, 0.0f);
                    Vec3 velocity = this.m_20184_();
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)p.m_123601_(), (double)p.m_123615_(), (double)p.m_123616_(), (double)vel.m_122239_() + velocity.f_82479_, (double)vel.m_122260_() + velocity.f_82480_, (double)vel.m_122269_() + velocity.f_82481_);
                }
            } else {
                this.trails.get(0).add(ZERO_VEC4, ZERO_VEC4, 0.0f);
                this.trails.get(1).add(ZERO_VEC4, ZERO_VEC4, 0.0f);
            }
        }
    }
}

