/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import immersive_aircraft.Config;
import immersive_aircraft.Items;
import immersive_aircraft.Sounds;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.Rotorcraft;
import immersive_aircraft.entity.misc.AircraftProperties;
import immersive_aircraft.entity.misc.Trail;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class AirshipEntity
extends Rotorcraft {
    private final AircraftProperties properties = new AircraftProperties().setYawSpeed(5.0f).setEngineSpeed(0.02f).setVerticalSpeed(0.025f).setGlideFactor(0.0f).setDriftDrag(0.01f).setLift(0.1f).setRollFactor(5.0f).setWindSensitivity(0.05f).setMass(12.0f);
    final List<List<Vec3>> PASSENGER_POSITIONS = List.of(List.of(new Vec3(0.0, (double)-0.1f, 0.0)), List.of(new Vec3(0.0, (double)-0.1f, (double)0.4f), new Vec3(0.0, (double)-0.1f, (double)-0.3f)));
    private final List<Trail> trails = List.of(new Trail(15, 0.5f));

    public AirshipEntity(EntityType<? extends AircraftEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    SoundEvent getEngineSound() {
        return Sounds.PROPELLER_SMALL.get();
    }

    @Override
    public AircraftProperties getProperties() {
        return this.properties;
    }

    @Override
    float getGroundVelocityDecay() {
        return 0.5f;
    }

    @Override
    float getHorizontalVelocityDelay() {
        return 0.97f;
    }

    @Override
    float getVerticalVelocityDelay() {
        return 0.925f;
    }

    @Override
    float getStabilizer() {
        return 0.1f;
    }

    @Override
    public Item asItem() {
        return Items.AIRSHIP.get();
    }

    @Override
    public List<Trail> getTrails() {
        return this.trails;
    }

    private void trail(Matrix4f transform, float y) {
        Vector4f p0 = this.transformPosition(transform, -0.15f, y, 0.0f);
        Vector4f p1 = this.transformPosition(transform, 0.15f, y, 0.0f);
        float trailStrength = Math.max(0.0f, Math.min(1.0f, (float)(this.m_20184_().m_82553_() - (double)0.05f)));
        this.trails.get(0).add(p0, p1, trailStrength);
    }

    @Override
    protected List<List<Vec3>> getPassengerPositions() {
        return this.PASSENGER_POSITIONS;
    }

    @Override
    protected float getGravity() {
        return this.f_19798_ ? 0.04f : (1.0f - this.getEnginePower()) * super.getGravity();
    }

    @Override
    void updateController() {
        super.updateController();
        this.setEngineTarget(1.0f);
        this.m_20256_(this.m_20184_().m_82520_(0.0, (double)(this.getEnginePower() * this.properties.getVerticalSpeed() * this.pressingInterpolatedY.getSmooth()), 0.0));
        Vec3 direction = this.getDirection();
        float thrust = (float)(Math.pow(this.getEnginePower(), 5.0) * (double)this.properties.getEngineSpeed()) * this.pressingInterpolatedZ.getSmooth();
        this.m_20256_(this.m_20184_().m_82549_(direction.m_82490_((double)thrust)));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            if (this.isWithinParticleRange()) {
                Matrix4f transform = this.getVehicleTransform();
                Matrix4f tr = transform.m_27658_();
                tr.m_162199_(0.0f, 0.4f, -1.2f);
                tr.m_27646_(Vector3f.f_122227_.m_122240_(this.engineRotation.getSmooth() * 50.0f));
                this.trail(tr, 0.0f);
                if ((double)this.enginePower.getValue() > 0.0 && this.f_19797_ % 2 == 0) {
                    Vector4f p = this.transformPosition(transform, (this.f_19796_.m_188501_() - 0.5f) * 0.4f, 0.8f, -0.8f);
                    Vec3 velocity = this.m_20184_();
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)p.m_123601_(), (double)p.m_123615_(), (double)p.m_123616_(), velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
                }
            } else {
                this.trails.get(0).add(ZERO_VEC4, ZERO_VEC4, 0.0f);
            }
        }
    }

    public boolean m_6783_(double distance) {
        Objects.requireNonNull(Config.getInstance());
        double d = 192.0 * AirshipEntity.m_20150_();
        return distance < d * d;
    }
}

