/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.EngineAircraft;
import immersive_aircraft.entity.misc.AircraftProperties;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class AirplaneEntity
extends EngineAircraft {
    private final AircraftProperties properties = new AircraftProperties().setYawSpeed(5.0f).setPitchSpeed(4.0f).setEngineSpeed(0.0225f).setGlideFactor(0.05f).setDriftDrag(0.01f).setLift(0.15f).setRollFactor(45.0f).setGroundPitch(4.0f).setWindSensitivity(0.01f).setMass(15.0f);

    public AirplaneEntity(EntityType<? extends AircraftEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Override
    boolean useAirplaneControls() {
        return true;
    }

    @Override
    public AircraftProperties getProperties() {
        return this.properties;
    }

    @Override
    float getGroundVelocityDecay() {
        return 0.975f;
    }

    @Override
    protected float getGravity() {
        Vec3 direction = this.getDirection();
        float speed = (float)((double)((float)this.m_20184_().m_82553_()) * (1.0 - Math.abs(direction.m_7098_())));
        return Math.max(0.0f, 1.0f - speed * 2.0f) * super.getGravity();
    }

    float getBrakeFactor() {
        return 0.95f;
    }

    @Override
    void updateController() {
        if (!this.m_20160_()) {
            return;
        }
        super.updateController();
        if (this.movementY != 0.0f) {
            this.setEngineTarget(Math.max(0.0f, Math.min(1.0f, this.getEngineTarget() + 0.1f * this.movementY)));
            if (this.movementY < 0.0f) {
                this.m_20256_(this.m_20184_().m_82490_((double)this.getBrakeFactor()));
            }
        }
        Vec3 direction = this.getDirection();
        float thrust = (float)(Math.pow(this.getEnginePower(), 2.0) * (double)this.properties.getEngineSpeed());
        this.m_20256_(this.m_20184_().m_82549_(direction.m_82490_((double)thrust)));
    }
}

