/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.entity.misc.AircraftProperties;
import immersive_aircraft.entity.misc.Trail;
import immersive_aircraft.util.Utils;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class AircraftEntity
extends VehicleEntity {
    private double lastY;
    private static final List<Trail> TRAILS = Collections.emptyList();
    final List<List<Vec3>> PASSENGER_POSITIONS = List.of(List.of(new Vec3(0.0, 0.0, 0.0)));

    public AircraftEntity(EntityType<? extends AircraftEntity> entityType, Level world) {
        super(entityType, world);
    }

    public List<Trail> getTrails() {
        return TRAILS;
    }

    public abstract AircraftProperties getProperties();

    @Override
    protected List<List<Vec3>> getPassengerPositions() {
        return this.PASSENGER_POSITIONS;
    }

    @Override
    public void m_8119_() {
        this.prevRoll = this.roll;
        this.roll = this.f_19861_ ? (float)((double)this.roll * 0.9) : -this.pressingInterpolatedX.getSmooth() * this.getProperties().getRollFactor();
        super.m_8119_();
    }

    void convertPower(Vec3 direction) {
        Vec3 velocity = this.m_20184_();
        double drag = Math.abs(direction.m_82526_(velocity.m_82541_()));
        this.m_20256_(velocity.m_82541_().m_165921_(direction, (double)this.getProperties().getLift()).m_82490_(velocity.m_82553_() * (drag * (double)this.getProperties().getDriftDrag() + (1.0 - (double)this.getProperties().getDriftDrag()))));
    }

    float getHorizontalVelocityDelay() {
        return 0.98f;
    }

    float getVerticalVelocityDelay() {
        return 0.98f;
    }

    float getGroundVelocityDecay() {
        return 0.95f;
    }

    float getRotationDecay() {
        return 0.98f;
    }

    @Override
    void updateVelocity() {
        float decay = 1.0f;
        float gravity = this.getGravity();
        if (this.f_19798_) {
            gravity *= 0.25f;
            decay = 0.9f;
        } else if (this.f_19861_) {
            decay = this.getGroundVelocityDecay();
        }
        Vec3 direction = this.getDirection();
        double diff = this.lastY - this.m_20186_();
        if (this.lastY != 0.0 && this.getProperties().getGlideFactor() > 0.0f) {
            this.m_20256_(this.m_20184_().m_82549_(direction.m_82490_(diff * (double)this.getProperties().getGlideFactor() * (1.0 - Math.abs(direction.m_7098_())))));
        }
        this.lastY = this.m_20186_();
        this.convertPower(direction);
        Vec3 vec3d = this.m_20184_();
        this.m_20334_(vec3d.f_82479_ * (double)decay * (double)this.getHorizontalVelocityDelay(), vec3d.f_82480_ * (double)decay * (double)this.getVerticalVelocityDelay() + (double)gravity, vec3d.f_82481_ * (double)decay * (double)this.getHorizontalVelocityDelay());
        this.pressingInterpolatedX.decay(0.0f, 1.0f - decay * this.getRotationDecay());
        this.pressingInterpolatedZ.decay(0.0f, 1.0f - decay * this.getRotationDecay());
        if (!this.f_19861_) {
            boolean thundering = this.f_19853_.m_6106_().m_6534_();
            boolean raining = this.f_19853_.m_6106_().m_6533_();
            float strength = (float)((1.0 + vec3d.m_82553_()) * (double)(thundering ? 1.5f : 1.0f) * (double)(raining ? 2.0f : 1.0f));
            float nx = (float)(Utils.cosNoise((double)this.f_19797_ / 20.0 / (double)this.getProperties().getMass() * (double)strength) * (double)this.getProperties().getWindSensitivity() * (double)strength);
            float nz = (float)(Utils.cosNoise((double)this.f_19797_ / 21.0 / (double)this.getProperties().getMass() * (double)strength) * (double)this.getProperties().getWindSensitivity() * (double)strength);
            this.m_146926_(this.m_146909_() + nx);
            this.m_146922_(this.m_146908_() + nz);
        }
    }
}

