/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.render.entity.renderer;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import immersive_aircraft.Config;
import immersive_aircraft.Main;
import immersive_aircraft.client.render.entity.renderer.AircraftEntityRenderer;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.AirshipEntity;
import immersive_aircraft.util.obj.oobjloader.Mesh;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;

public class AirshipEntityRenderer<T extends AirshipEntity>
extends AircraftEntityRenderer<T> {
    private static final ResourceLocation id = Main.locate("objects/airship.obj");
    private final ResourceLocation texture = Main.locate("textures/entity/airship.png");
    private final AircraftEntityRenderer.Model model = new AircraftEntityRenderer.Model().add(new AircraftEntityRenderer.Object(id, "frame")).add(new AircraftEntityRenderer.Object(id, "sails").setRenderConsumer((vertexConsumerProvider, entity, matrixStack, light) -> {
        ResourceLocation identifier = this.getTexture(entity);
        VertexConsumer vertexConsumer = vertexConsumerProvider.m_6299_(RenderType.m_110458_((ResourceLocation)identifier));
        if (entity.isWithinParticleRange()) {
            Objects.requireNonNull(Config.getInstance());
            Mesh mesh = AirshipEntityRenderer.getFaces(id, "sails_animated");
            float time = (float)(entity.f_19853_.m_46467_() % 24000L) + Minecraft.m_91087_().m_91296_();
            AirshipEntityRenderer.renderSailObject(mesh, matrixStack, vertexConsumer, light, time);
        } else {
            Mesh mesh = AirshipEntityRenderer.getFaces(id, "sails");
            AirshipEntityRenderer.renderObject(mesh, matrixStack, vertexConsumer, light);
        }
    })).add(new AircraftEntityRenderer.Object(id, "controller").setAnimationConsumer((entity, yaw, tickDelta, matrixStack) -> {
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(entity.pressingInterpolatedX.getSmooth(tickDelta) * 30.0f));
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(entity.pressingInterpolatedZ.getSmooth(tickDelta) * 30.0f));
    })).add(new AircraftEntityRenderer.Object(id, "propeller").setAnimationConsumer((entity, yaw, tickDelta, matrixStack) -> {
        matrixStack.m_85837_(0.0, 0.1875, 0.0);
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_((float)((double)(-entity.engineRotation.getSmooth(tickDelta)) * 100.0)));
        matrixStack.m_85837_(0.0, -0.1875, 0.0);
    }).setRenderConsumer((vertexConsumerProvider, entity, matrixStack, light) -> {
        ResourceLocation identifier = this.getTexture(entity);
        VertexConsumer vertexConsumer = vertexConsumerProvider.m_6299_(RenderType.m_110458_((ResourceLocation)identifier));
        Mesh mesh = AirshipEntityRenderer.getFaces(id, "propeller");
        AirshipEntityRenderer.renderObject(mesh, matrixStack, vertexConsumer, light);
    }));

    public AirshipEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.8f;
    }

    public ResourceLocation getTexture(T AircraftEntity2) {
        return this.texture;
    }

    @Override
    AircraftEntityRenderer.Model getModel(AircraftEntity entity) {
        return this.model;
    }

    @Override
    Vector3f getPivot(AircraftEntity entity) {
        return new Vector3f(0.0f, 0.2f, 0.0f);
    }
}

