/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;

public final class Config
implements Serializable {
    private static final long serialVersionUID = 9132405079466337851L;
    private static final Config INSTANCE = Config.loadOrCreate();
    public static final int VERSION = 1;
    public final boolean enableTrails = true;
    public final boolean enableAnimatedSails = true;
    public final float renderDistance = 192.0f;
    public int version = 0;

    public static Config getInstance() {
        return INSTANCE;
    }

    public static File getConfigFile() {
        return new File("./config/immersive_aircraft.json");
    }

    public void save() {
        try (FileWriter writer = new FileWriter(Config.getConfigFile());){
            this.version = 1;
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Config loadOrCreate() {
        Config config;
        FileReader reader2 = new FileReader(Config.getConfigFile());
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            Config config2 = (Config)gson.fromJson((Reader)reader2, Config.class);
            if (config2.version != 1) {
                config2 = new Config();
            }
            config2.save();
            config = config2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader2.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException reader2) {
                Config config3 = new Config();
                config3.save();
                return config3;
            }
        }
        reader2.close();
        return config;
    }
}

