/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel;

import com.github.alexthe666.citadel.Citadel;
import com.github.alexthe666.citadel.CitadelConstants;
import com.github.alexthe666.citadel.ServerProxy;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.client.CitadelItemRenderProperties;
import com.github.alexthe666.citadel.client.event.EventRenderSplashText;
import com.github.alexthe666.citadel.client.gui.GuiCitadelBook;
import com.github.alexthe666.citadel.client.gui.GuiCitadelCapesConfig;
import com.github.alexthe666.citadel.client.gui.GuiCitadelPatreonConfig;
import com.github.alexthe666.citadel.client.model.TabulaModel;
import com.github.alexthe666.citadel.client.model.TabulaModelHandler;
import com.github.alexthe666.citadel.client.render.CitadelLecternRenderer;
import com.github.alexthe666.citadel.client.rewards.CitadelCapes;
import com.github.alexthe666.citadel.client.rewards.CitadelPatreonRenderer;
import com.github.alexthe666.citadel.client.rewards.SpaceStationPatreonRenderer;
import com.github.alexthe666.citadel.client.texture.CitadelTextureManager;
import com.github.alexthe666.citadel.client.texture.VideoFrameTexture;
import com.github.alexthe666.citadel.client.tick.ClientTickRateTracker;
import com.github.alexthe666.citadel.client.video.Video;
import com.github.alexthe666.citadel.config.ServerConfig;
import com.github.alexthe666.citadel.item.ItemWithHoverAnimation;
import com.github.alexthe666.citadel.server.entity.CitadelEntityData;
import com.github.alexthe666.citadel.server.event.EventChangeEntityTickRate;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Vector3f;
import java.awt.Color;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.BackupConfirmScreen;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.SkinCustomizationScreen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientProxy
extends ServerProxy {
    public static TabulaModel CITADEL_MODEL;
    public static final String RICKROLL_URL = "https://ia801602.us.archive.org/11/items/Rick_Astley_Never_Gonna_Give_You_Up/Rick_Astley_Never_Gonna_Give_You_Up.mp4";
    private static final ResourceLocation RICKROLL_LOCATION;
    public static boolean hideFollower;
    private Video rickrollVideo = null;
    private Map<ItemStack, Float> prevMouseOverProgresses = new HashMap<ItemStack, Float>();
    private Map<ItemStack, Float> mouseOverProgresses = new HashMap<ItemStack, Float>();
    private ItemStack lastHoveredItem = null;

    @Override
    public void onClientInit() {
        try {
            CITADEL_MODEL = new TabulaModel(TabulaModelHandler.INSTANCE.loadTabulaModel("/assets/citadel/models/citadel_model"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)Citadel.LECTERN_BE.get()), CitadelLecternRenderer::new);
        CitadelPatreonRenderer.register("citadel", new SpaceStationPatreonRenderer(new ResourceLocation("citadel:patreon_space_station"), new int[0]));
        CitadelPatreonRenderer.register("citadel_red", new SpaceStationPatreonRenderer(new ResourceLocation("citadel:patreon_space_station_red"), new int[]{11685960, 10306880, 8009265, 7417898}));
        CitadelPatreonRenderer.register("citadel_gray", new SpaceStationPatreonRenderer(new ResourceLocation("citadel:patreon_space_station_gray"), new int[]{0xA0A0A0, 0x888888, 0x646464, 0x575757}));
    }

    @SubscribeEvent
    public void screenOpen(ScreenEvent.Init event) {
        if (event.getScreen() instanceof SkinCustomizationScreen && Minecraft.m_91087_().f_91074_ != null) {
            try {
                String username = Minecraft.m_91087_().f_91074_.m_7755_().getString();
                int height = -20;
                if (Citadel.PATREONS.contains(username)) {
                    event.addListener((GuiEventListener)new Button(event.getScreen().f_96543_ / 2 - 100, event.getScreen().f_96544_ / 6 + 150 + height, 200, 20, (Component)Component.m_237115_((String)"citadel.gui.patreon_rewards_option").m_130940_(ChatFormatting.GREEN), p_213080_2_ -> Minecraft.m_91087_().m_91152_((Screen)new GuiCitadelPatreonConfig(event.getScreen(), Minecraft.m_91087_().f_91066_))));
                    height += 25;
                }
                if (!CitadelCapes.getCapesFor(Minecraft.m_91087_().f_91074_.m_20148_()).isEmpty()) {
                    event.addListener((GuiEventListener)new Button(event.getScreen().f_96543_ / 2 - 100, event.getScreen().f_96544_ / 6 + 150 + height, 200, 20, (Component)Component.m_237115_((String)"citadel.gui.capes_option").m_130940_(ChatFormatting.GREEN), p_213080_2_ -> Minecraft.m_91087_().m_91152_((Screen)new GuiCitadelCapesConfig(event.getScreen(), Minecraft.m_91087_().f_91066_))));
                    height += 25;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void screenRender(ScreenEvent.Render event) {
        if (event.getScreen() instanceof TitleScreen && CitadelConstants.isAprilFools()) {
            if (this.rickrollVideo == null) {
                VideoFrameTexture videoFrameTexture = CitadelTextureManager.getVideoTexture(RICKROLL_LOCATION, 640, 480);
                this.rickrollVideo = new Video(RICKROLL_URL, RICKROLL_LOCATION, videoFrameTexture, 25.0, false);
                this.rickrollVideo.setRepeat(true);
            } else {
                this.rickrollVideo.setPaused(false);
                int screenHeight = event.getScreen().f_96544_;
                int screenWidth = event.getScreen().f_96543_;
                this.rickrollVideo.update();
                RenderSystem.m_69453_();
                RenderSystem.m_157427_(GameRenderer::m_172817_);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_157456_((int)0, (ResourceLocation)RICKROLL_LOCATION);
                Tesselator tesselator = Tesselator.m_85913_();
                BufferBuilder bufferbuilder = tesselator.m_85915_();
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder.m_5483_(0.0, (double)screenHeight, -90.0).m_7421_(0.0f, 1.0f).m_5752_();
                bufferbuilder.m_5483_((double)screenWidth, (double)screenHeight, -90.0).m_7421_(1.0f, 1.0f).m_5752_();
                bufferbuilder.m_5483_((double)screenWidth, 0.0, -90.0).m_7421_(1.0f, 0.0f).m_5752_();
                bufferbuilder.m_5483_(0.0, 0.0, -90.0).m_7421_(0.0f, 0.0f).m_5752_();
                tesselator.m_85914_();
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        } else if (this.rickrollVideo != null) {
            this.rickrollVideo.setPaused(true);
        }
    }

    @SubscribeEvent
    public void playerRender(RenderPlayerEvent.Post event) {
        PoseStack matrixStackIn = event.getPoseStack();
        String username = event.getEntity().m_7755_().getString();
        if (!event.getEntity().m_36170_(PlayerModelPart.CAPE)) {
            return;
        }
        if (Citadel.PATREONS.contains(username)) {
            CitadelPatreonRenderer renderer;
            String rendererName;
            CompoundTag tag = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)Minecraft.m_91087_().f_91074_);
            String string = rendererName = tag.m_128441_("CitadelFollowerType") ? tag.m_128461_("CitadelFollowerType") : "citadel";
            if (!rendererName.equals("none") && !hideFollower && (renderer = CitadelPatreonRenderer.get(rendererName)) != null) {
                float distance = tag.m_128441_("CitadelRotateDistance") ? tag.m_128457_("CitadelRotateDistance") : 2.0f;
                float speed = tag.m_128441_("CitadelRotateSpeed") ? tag.m_128457_("CitadelRotateSpeed") : 1.0f;
                float height = tag.m_128441_("CitadelRotateHeight") ? tag.m_128457_("CitadelRotateHeight") : 1.0f;
                renderer.render(matrixStackIn, event.getMultiBufferSource(), event.getPackedLight(), event.getPartialTick(), (LivingEntity)event.getEntity(), distance, speed, height);
            }
        }
    }

    @SubscribeEvent
    public void onOpenGui(ScreenEvent.Opening event) {
        if (ServerConfig.skipWarnings) {
            try {
                if (event.getScreen() instanceof BackupConfirmScreen) {
                    BackupConfirmScreen confirmBackupScreen = (BackupConfirmScreen)event.getScreen();
                    String name = "";
                    MutableComponent title = Component.m_237115_((String)"selectWorld.backupQuestion.experimental");
                    if (confirmBackupScreen.m_96636_().equals(title)) {
                        confirmBackupScreen.f_95536_.m_95565_(false, true);
                    }
                }
                if (event.getScreen() instanceof ConfirmScreen) {
                    ConfirmScreen confirmScreen = (ConfirmScreen)event.getScreen();
                    MutableComponent title = Component.m_237115_((String)"selectWorld.backupQuestion.experimental");
                    String name = "";
                    if (confirmScreen.m_96636_().equals(title)) {
                        confirmScreen.f_95649_.accept(true);
                    }
                }
            }
            catch (Exception e) {
                Citadel.LOGGER.warn("Citadel couldn't skip world loadings");
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void renderSplashTextBefore(EventRenderSplashText.Pre event) {
        if (CitadelConstants.isAprilFools() && this.rickrollVideo != null && this.rickrollVideo.getLastFrame() > 35) {
            event.setResult(Event.Result.ALLOW);
            float hue = (float)(System.currentTimeMillis() % 6000L) / 6000.0f;
            event.getPoseStack().m_85845_(Vector3f.f_122227_.m_122240_((float)Math.sin((double)hue * Math.PI) * 360.0f));
            event.setSplashText("Never gonna give you up!");
            int rainbow = Color.HSBtoRGB(hue, 0.6f, 1.0f);
            event.setSplashTextColor(rainbow);
        }
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !this.isGamePaused()) {
            ClientTickRateTracker.getForClient(Minecraft.m_91087_()).masterTick();
            this.tickMouseOverAnimations();
        }
    }

    private void tickMouseOverAnimations() {
        this.prevMouseOverProgresses.putAll(this.mouseOverProgresses);
        if (this.lastHoveredItem != null) {
            float prev = this.mouseOverProgresses.getOrDefault(this.lastHoveredItem, Float.valueOf(0.0f)).floatValue();
            float maxTime = 5.0f;
            Item item = this.lastHoveredItem.m_41720_();
            if (item instanceof ItemWithHoverAnimation) {
                ItemWithHoverAnimation hoverOver = (ItemWithHoverAnimation)item;
                maxTime = hoverOver.getMaxHoverOverTime(this.lastHoveredItem);
            }
            if (prev < maxTime) {
                this.mouseOverProgresses.put(this.lastHoveredItem, Float.valueOf(prev + 1.0f));
            }
        }
        if (!this.mouseOverProgresses.isEmpty()) {
            Iterator<Map.Entry<ItemStack, Float>> it = this.mouseOverProgresses.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<ItemStack, Float> next = it.next();
                float progress = next.getValue().floatValue();
                if (this.lastHoveredItem != null && next.getKey() == this.lastHoveredItem) continue;
                if (progress == 0.0f) {
                    it.remove();
                    continue;
                }
                next.setValue(Float.valueOf(progress - 1.0f));
            }
        }
        this.lastHoveredItem = null;
    }

    @SubscribeEvent
    public void renderTooltipColor(RenderTooltipEvent.Color event) {
        ItemWithHoverAnimation hoverOver;
        Item item = event.getItemStack().m_41720_();
        this.lastHoveredItem = item instanceof ItemWithHoverAnimation && (hoverOver = (ItemWithHoverAnimation)item).canHoverOver(event.getItemStack()) ? event.getItemStack() : null;
    }

    @Override
    public float getMouseOverProgress(ItemStack itemStack) {
        float prev = this.prevMouseOverProgresses.getOrDefault(itemStack, Float.valueOf(0.0f)).floatValue();
        float current = this.mouseOverProgresses.getOrDefault(itemStack, Float.valueOf(0.0f)).floatValue();
        float lerped = prev + (current - prev) * Minecraft.m_91087_().m_91296_();
        float maxTime = 5.0f;
        Item item = itemStack.m_41720_();
        if (item instanceof ItemWithHoverAnimation) {
            ItemWithHoverAnimation hoverOver = (ItemWithHoverAnimation)item;
            maxTime = hoverOver.getMaxHoverOverTime(itemStack);
        }
        return lerped / maxTime;
    }

    @Override
    public void handleAnimationPacket(int entityId, int index) {
        IAnimatedEntity entity;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && (entity = (IAnimatedEntity)player.f_19853_.m_6815_(entityId)) != null) {
            if (index == -1) {
                entity.setAnimation(IAnimatedEntity.NO_ANIMATION);
            } else {
                entity.setAnimation(entity.getAnimations()[index]);
            }
            entity.setAnimationTick(0);
        }
    }

    @Override
    public void handlePropertiesPacket(String propertyID, CompoundTag compound, int entityID) {
        if (compound == null) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Entity entity = player.f_19853_.m_6815_(entityID);
        if ((propertyID.equals("CitadelPatreonConfig") || propertyID.equals("CitadelTagUpdate")) && entity instanceof LivingEntity) {
            CitadelEntityData.setCitadelTag((LivingEntity)entity, compound);
        }
    }

    @Override
    public void handleClientTickRatePacket(CompoundTag compound) {
        ClientTickRateTracker.getForClient(Minecraft.m_91087_()).syncFromServer(compound);
    }

    @Override
    public Object getISTERProperties() {
        return new CitadelItemRenderProperties();
    }

    @Override
    public void openBookGUI(ItemStack book) {
        Minecraft.m_91087_().m_91152_((Screen)new GuiCitadelBook(book));
    }

    @Override
    public boolean isGamePaused() {
        return Minecraft.m_91087_().m_91104_();
    }

    @Override
    public Player getClientSidePlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    @Override
    public boolean canEntityTickClient(Level level, Entity entity) {
        ClientTickRateTracker tracker = ClientTickRateTracker.getForClient(Minecraft.m_91087_());
        if (tracker.isTickingHandled(entity)) {
            return false;
        }
        if (!tracker.hasNormalTickRate(entity)) {
            EventChangeEntityTickRate event = new EventChangeEntityTickRate(entity, tracker.getEntityTickLengthModifier(entity));
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return true;
            }
            tracker.addTickBlockedEntity(entity);
            return false;
        }
        return true;
    }

    static {
        RICKROLL_LOCATION = new ResourceLocation("citadel:rickroll.mp4");
        hideFollower = false;
    }
}

