/*
 * Decompiled with CFR 0.152.
 */
package quilt.net.mca.util;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public interface NbtHelper {
    public static <T extends class_2520> T computeIfAbsent(class_2487 nbt, String key, int type, Supplier<T> factory) {
        if (!nbt.method_10573(key, type)) {
            nbt.method_10566(key, (class_2520)factory.get());
        }
        return (T)nbt.method_10580(key);
    }

    public static class_2487 copyTo(class_2487 from, class_2487 to) {
        from.method_10541().forEach(key -> to.method_10566(key, from.method_10580(key)));
        return to;
    }

    public static <V> List<V> toList(class_2520 nbt, Function<class_2520, V> valueMapper) {
        return NbtHelper.toStream(nbt, valueMapper).collect(Collectors.toList());
    }

    public static <V> Stream<V> toStream(class_2520 nbt, Function<class_2520, V> valueMapper) {
        return ((class_2499)nbt).stream().map(valueMapper);
    }

    public static <K, V> Map<K, V> toMap(class_2487 nbt, Function<String, K> keyMapper, Function<class_2520, V> valueMapper) {
        return NbtHelper.toMap(nbt, keyMapper, (K k, class_2520 e) -> valueMapper.apply((class_2520)e));
    }

    public static <K, V> Map<K, V> toMap(class_2487 nbt, Function<String, K> keyMapper, BiFunction<K, class_2520, V> valueMapper) {
        return nbt.method_10541().stream().map(e -> {
            Object k = keyMapper.apply((String)e);
            if (k == null) {
                return null;
            }
            Object v = valueMapper.apply(k, nbt.method_10580(e));
            if (v == null) {
                return null;
            }
            return k == null ? null : new Pair(k, v);
        }).filter(Objects::nonNull).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    public static <V> class_2499 fromList(Iterable<V> list, Function<V, class_2520> valueMapper) {
        class_2499 output = new class_2499();
        list.forEach(item -> output.add((Object)((class_2520)valueMapper.apply(item))));
        return output;
    }

    public static <K, V> class_2487 fromMap(class_2487 output, Map<K, V> map, Function<K, String> keyMapper, Function<V, class_2520> valueMapper) {
        map.forEach((key, value) -> output.method_10566((String)keyMapper.apply(key), (class_2520)valueMapper.apply(value)));
        return output;
    }
}

