/*
 * Decompiled with CFR 0.152.
 */
package quilt.net.mca.server.world.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3852;
import net.minecraft.class_3989;
import net.minecraft.class_4076;
import net.minecraft.class_5250;
import quilt.net.mca.Config;
import quilt.net.mca.ProfessionsMCA;
import quilt.net.mca.entity.EquipmentSet;
import quilt.net.mca.entity.VillagerEntityMCA;
import quilt.net.mca.entity.ai.Memories;
import quilt.net.mca.entity.ai.relationship.Gender;
import quilt.net.mca.entity.ai.relationship.family.FamilyTree;
import quilt.net.mca.resources.API;
import quilt.net.mca.resources.PoolUtil;
import quilt.net.mca.resources.Rank;
import quilt.net.mca.resources.Tasks;
import quilt.net.mca.server.world.data.Building;
import quilt.net.mca.server.world.data.PlayerSaveData;
import quilt.net.mca.server.world.data.VillageManager;
import quilt.net.mca.util.BlockBoxExtended;
import quilt.net.mca.util.NbtHelper;

public class Village
implements Iterable<Building> {
    private static final int MOVE_IN_COOLDOWN = 1200;
    private static final int MAX_STORAGE_SIZE = 1024;
    public static final int BORDER_MARGIN = 32;
    public static final int MERGE_MARGIN = 64;
    private String name = API.getVillagePool().pickVillageName("village");
    public final List<class_1799> storageBuffer = new LinkedList<class_1799>();
    private final Map<Integer, Building> buildings = new HashMap<Integer, Building>();
    private Map<UUID, Integer> unspentHearts = new HashMap<UUID, Integer>();
    private Map<UUID, Map<UUID, Integer>> reputation = new HashMap<UUID, Map<UUID, Integer>>();
    private int unspentMood = 0;
    public long lastMoveIn;
    private int id;
    private int taxes = 0;
    private int populationThreshold = 75;
    private int marriageThreshold = 50;
    private boolean autoScan = true;
    private BlockBoxExtended box = new BlockBoxExtended(0, 0, 0, 0, 0, 0);

    public Village() {
    }

    public Village(int id) {
        this.id = id;
    }

    public static Optional<Village> findNearest(class_1297 entity) {
        return VillageManager.get((class_3218)entity.field_6002).findNearestVillage(entity);
    }

    public boolean isWithinBorder(class_1297 entity) {
        return this.isWithinBorder(entity.method_24515());
    }

    public boolean isWithinBorder(class_2338 pos) {
        return this.isWithinBorder(pos, 32);
    }

    public boolean isWithinBorder(class_2338 pos, int margin) {
        return this.box.method_35410(margin).method_14662((class_2382)pos);
    }

    @Override
    public Iterator<Building> iterator() {
        return this.buildings.values().iterator();
    }

    public void removeBuilding(int id) {
        this.buildings.remove(id);
        if (!this.buildings.isEmpty()) {
            this.calculateDimensions();
        }
    }

    public Stream<Building> getBuildingsOfType(String type) {
        return this.getBuildings().values().stream().filter(b -> b.getType().equals(type));
    }

    public Optional<Building> getBuildingAt(class_2382 pos) {
        return this.getBuildings().values().stream().filter(b -> b.containsPos(pos)).findAny();
    }

    public void calculateDimensions() {
        int sx = Integer.MAX_VALUE;
        int sy = Integer.MAX_VALUE;
        int sz = Integer.MAX_VALUE;
        int ex = Integer.MIN_VALUE;
        int ey = Integer.MIN_VALUE;
        int ez = Integer.MIN_VALUE;
        for (Building building : this.buildings.values()) {
            ex = Math.max(building.getPos1().method_10263(), ex);
            sx = Math.min(building.getPos0().method_10263(), sx);
            ey = Math.max(building.getPos1().method_10264(), ey);
            sy = Math.min(building.getPos0().method_10264(), sy);
            ez = Math.max(building.getPos1().method_10260(), ez);
            sz = Math.min(building.getPos0().method_10260(), sz);
        }
        this.box = new BlockBoxExtended(sx, sy, sz, ex, ey, ez);
    }

    public class_2382 getCenter() {
        return this.box.method_22874();
    }

    public BlockBoxExtended getBox() {
        return this.box;
    }

    public int getTaxes() {
        return this.taxes;
    }

    public void setTaxes(int taxes) {
        this.taxes = taxes;
    }

    public int getPopulationThreshold() {
        return this.populationThreshold;
    }

    public void setPopulationThreshold(int populationThreshold) {
        this.populationThreshold = populationThreshold;
    }

    public int getMarriageThreshold() {
        return this.marriageThreshold;
    }

    public void setMarriageThreshold(int marriageThreshold) {
        this.marriageThreshold = marriageThreshold;
    }

    public boolean isAutoScan() {
        return this.autoScan;
    }

    public void setAutoScan(boolean autoScan) {
        this.autoScan = autoScan;
    }

    public void toggleAutoScan() {
        this.setAutoScan(!this.isAutoScan());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<Integer, Building> getBuildings() {
        return this.buildings;
    }

    public Optional<Building> getBuilding(int id) {
        return Optional.ofNullable(this.buildings.get(id));
    }

    public int getId() {
        return this.id;
    }

    public boolean hasSpace() {
        return this.getPopulation() < this.getMaxPopulation();
    }

    public int getPopulation() {
        int residents = 0;
        for (Building b : this) {
            residents += b.getResidents().size();
        }
        return residents;
    }

    public Stream<UUID> getResidentsUUIDs() {
        return this.getBuildings().values().stream().flatMap(building -> building.getResidents().keySet().stream());
    }

    public List<VillagerEntityMCA> getResidents(class_3218 world) {
        return this.getResidentsUUIDs().map(arg_0 -> ((class_3218)world).method_14190(arg_0)).filter(v -> v instanceof VillagerEntityMCA).map(VillagerEntityMCA.class::cast).collect(Collectors.toList());
    }

    public int getMaxPopulation() {
        int residents = 0;
        for (Building b : this) {
            residents += b.getBedCount();
        }
        return residents;
    }

    public boolean hasStoredResource() {
        return this.storageBuffer.size() > 0;
    }

    public boolean hasBuilding(String building) {
        return this.buildings.values().stream().anyMatch(b -> b.getType().equals(building));
    }

    public void tick(class_3218 world, long time) {
        boolean isVillageUpdateTime;
        boolean isTaxSeason = time % (long)Config.getInstance().taxSeason == 0L;
        boolean bl = isVillageUpdateTime = time % 1200L == 0L;
        if (isTaxSeason && this.hasBuilding("storage")) {
            class_5250 msg;
            int emeraldValue = 100;
            int taxes = (int)(Config.getInstance().taxesFactor * (float)this.getPopulation() * (float)this.getTaxes() + (float)world.field_9229.method_43048(emeraldValue));
            int moodImpact = 0;
            float r = class_3532.method_16439((float)0.5f, (float)((float)this.getTaxes() / 100.0f), (float)world.field_9229.method_43057());
            if ((float)this.getTaxes() == 0.0f) {
                msg = class_2561.method_43469((String)"gui.village.taxes.no", (Object[])new Object[]{this.getName()}).method_27692(class_124.field_1060);
                moodImpact = 5;
            } else if ((double)r < 0.1) {
                msg = class_2561.method_43469((String)"gui.village.taxes.more", (Object[])new Object[]{this.getName()}).method_27692(class_124.field_1060);
                taxes = (int)((double)taxes + (double)this.getPopulation() * 0.25);
            } else if ((double)r < 0.3) {
                msg = class_2561.method_43469((String)"gui.village.taxes.happy", (Object[])new Object[]{this.getName()}).method_27692(class_124.field_1077);
                moodImpact = 5;
            } else if ((double)r < 0.7) {
                msg = class_2561.method_43469((String)"gui.village.taxes", (Object[])new Object[]{this.getName()});
            } else if ((double)r < 0.8) {
                msg = class_2561.method_43469((String)"gui.village.taxes.sad", (Object[])new Object[]{this.getName()}).method_27692(class_124.field_1065);
                moodImpact = -5;
            } else if ((double)r < 0.9) {
                msg = class_2561.method_43469((String)"gui.village.taxes.angry", (Object[])new Object[]{this.getName()}).method_27692(class_124.field_1061);
                moodImpact = -10;
            } else {
                msg = class_2561.method_43469((String)"gui.village.taxes.riot", (Object[])new Object[]{this.getName()}).method_27692(class_124.field_1079);
                taxes = 0;
            }
            world.method_18456().stream().filter(v -> Tasks.getRank(this, v).isAtLeast(Rank.MERCHANT)).forEach(arg_0 -> Village.lambda$tick$6((class_2561)msg, arg_0));
            if (this.hasBuilding("library")) {
                taxes = (int)((double)taxes * 1.5);
            }
            for (int emeraldCount = taxes / emeraldValue; emeraldCount > 0 && this.storageBuffer.size() < 1024; emeraldCount -= class_1802.field_8687.method_7882()) {
                this.storageBuffer.add(new class_1799((class_1935)class_1802.field_8687, Math.min(emeraldCount, class_1802.field_8687.method_7882())));
            }
            if (moodImpact != 0) {
                this.pushMood(world, moodImpact * this.getPopulation());
            }
            this.deliverTaxes(world);
        }
        if (time % 24000L == 0L) {
            this.cleanReputation();
        }
        if (isVillageUpdateTime && this.lastMoveIn + 1200L < time) {
            this.spawnGuards(world);
            this.procreate(world);
            this.marry(world);
            this.inn(world);
        }
    }

    public void deliverTaxes(class_3218 world) {
        if (this.hasStoredResource()) {
            this.getBuildingsOfType("storage").forEach(building -> building.getBlocks().values().stream().flatMap(Collection::stream).forEach(p -> {
                if (this.hasStoredResource()) {
                    this.tryToPutIntoInventory(world, (class_2338)p);
                }
            }));
        }
    }

    private void tryToPutIntoInventory(class_3218 world, class_2338 p) {
        class_2586 blockEntity;
        class_2680 state = world.method_8320(p);
        if (state.method_31709() && (blockEntity = world.method_8321(p)) instanceof class_1263) {
            class_2281 chest;
            class_1263 inventory = (class_1263)blockEntity;
            class_2248 block = state.method_26204();
            if (inventory instanceof class_2595 && block instanceof class_2281 && (inventory = class_2281.method_17458((class_2281)(chest = (class_2281)block), (class_2680)state, (class_1937)world, (class_2338)p, (boolean)true)) != null) {
                this.putIntoInventory(inventory);
            }
        }
    }

    private void putIntoInventory(class_1263 inventory) {
        for (int i = 0; i < inventory.method_5439(); ++i) {
            boolean changes = true;
            while (changes) {
                changes = false;
                class_1799 stack = inventory.method_5438(i);
                class_1799 tax = this.storageBuffer.get(0);
                if (stack.method_7909() == tax.method_7909()) {
                    int diff = Math.min(tax.method_7947(), stack.method_7914() - stack.method_7947());
                    if (diff > 0) {
                        stack.method_7933(diff);
                        tax.method_7934(diff);
                        if (tax.method_7960()) {
                            this.storageBuffer.remove(0);
                            changes = true;
                        }
                        inventory.method_5431();
                    }
                } else if (stack.method_7960()) {
                    inventory.method_5447(i, tax);
                    inventory.method_5431();
                    this.storageBuffer.remove(0);
                    changes = true;
                }
                if (this.hasStoredResource()) continue;
                return;
            }
        }
    }

    private void spawnGuards(class_3218 world) {
        int guardCapacity = this.getPopulation() / Config.getInstance().guardSpawnRate;
        int guards = 0;
        int citizen = 0;
        List<VillagerEntityMCA> villagers = this.getResidents(world);
        LinkedList<VillagerEntityMCA> nonGuards = new LinkedList<VillagerEntityMCA>();
        for (VillagerEntityMCA villager : villagers) {
            if (villager.isGuard()) {
                ++guards;
                continue;
            }
            if (!villager.method_6109() && !villager.isProfessionImportant() && villager.method_19269() == 0 && villager.method_7231().method_16925() <= 1) {
                nonGuards.add(villager);
            }
            ++citizen;
        }
        guards = (int)((double)guards + Math.ceil((float)(this.getPopulation() - guards - citizen) / (float)Config.getInstance().guardSpawnRate));
        if (nonGuards.size() > 0 && guards < guardCapacity) {
            VillagerEntityMCA villager = (VillagerEntityMCA)nonGuards.get(world.field_9229.method_43048(nonGuards.size()));
            villager.setProfession(guards % 2 == 0 ? (class_3852)ProfessionsMCA.GUARD.get() : (class_3852)ProfessionsMCA.ARCHER.get());
        }
    }

    public void procreate(class_3218 world) {
        int maxPopulation;
        if (world.field_9229.method_43057() >= (float)Config.getInstance().childrenChance / 100.0f) {
            return;
        }
        int population = this.getPopulation();
        if ((float)population >= (float)((maxPopulation = this.getMaxPopulation()) * this.getPopulationThreshold()) / 100.0f) {
            return;
        }
        PoolUtil.pick(this.getResidents(world), world.field_9229).filter(villager -> villager.getGenetics().getGender() == Gender.FEMALE).filter(villager -> (double)world.field_9229.method_43057() < 1.0 / ((double)FamilyTree.get(world).getOrCreate((class_1297)villager).getChildren().count() + 0.1)).filter(villager -> villager.getRelationships().getPregnancy().tryStartGestation()).ifPresent(villager -> villager.getRelationships().getPartner().ifPresent(spouse -> {
            if (Config.getInstance().villagerBirthNotification && spouse instanceof VillagerEntityMCA) {
                VillagerEntityMCA spouseVillager = (VillagerEntityMCA)spouse;
                this.broadCastMessage(world, "events.baby", (VillagerEntityMCA)villager, spouseVillager);
            }
        }));
    }

    public void marry(class_3218 world) {
        if (world.field_9229.method_43057() >= (float)Config.getInstance().marriageChance / 100.0f) {
            return;
        }
        List<VillagerEntityMCA> allVillagers = this.getResidents(world);
        List availableVillagers = allVillagers.stream().filter(v -> !v.method_6109()).filter(v -> !v.getRelationships().isMarried()).filter(v -> !v.getRelationships().isEngaged()).filter(v -> !v.getRelationships().isPromised()).collect(Collectors.toList());
        if (availableVillagers.size() <= 1 || (float)availableVillagers.size() < (float)(allVillagers.size() * this.getMarriageThreshold()) / 100.0f) {
            return;
        }
        availableVillagers.sort(Comparator.comparingInt(a -> a.getVillagerBrain().getMemories().values().stream().map(Memories::getHearts).max(Integer::compare).orElse(0)));
        VillagerEntityMCA suitor = (VillagerEntityMCA)availableVillagers.remove(0);
        availableVillagers.stream().filter(suitor::canBeAttractedTo).filter(i -> !suitor.getRelationships().getFamilyEntry().isRelative(i.method_5667())).findFirst().ifPresent(mate -> {
            suitor.getRelationships().marry((class_1297)mate);
            mate.getRelationships().marry((class_1297)suitor);
            if (Config.getInstance().villagerMarriageNotification) {
                this.broadCastMessage(world, "events.marry", suitor, (VillagerEntityMCA)mate);
            }
        });
    }

    private void inn(class_3218 world) {
        this.getBuildingsOfType("inn").forEach(b -> {
            block1: {
                class_2338 p;
                if (!(world.field_9229.method_43057() < (float)Config.getInstance().adventurerAtInnChance / 100.0f)) break block1;
                ArrayList values = new ArrayList(b.getBlocks().values().stream().flatMap(Collection::stream).toList());
                Collections.shuffle(values);
                Iterator iterator = values.iterator();
                while (iterator.hasNext() && !this.trySpawnAdventurer(world, (p = (class_2338)iterator.next()).method_10084())) {
                }
            }
        });
    }

    private boolean doesNotSuffocateAt(class_1922 world, class_2338 pos) {
        for (class_2338 blockPos : class_2338.method_10097((class_2338)pos, (class_2338)pos.method_10084())) {
            if (world.method_8320(blockPos).method_26220(world, blockPos).method_1110()) continue;
            return false;
        }
        return true;
    }

    private boolean trySpawnAdventurer(class_3218 world, class_2338 blockPos) {
        if (!world.method_8393(class_4076.method_18675((int)blockPos.method_10263()), class_4076.method_18675((int)blockPos.method_10260()))) {
            return true;
        }
        String name = null;
        if (this.doesNotSuffocateAt((class_1922)world, blockPos)) {
            VillagerEntityMCA adventurer;
            int i = world.field_9229.method_43048(10);
            if (i == 0 && Config.getInstance().innSpawnsWanderingTraders) {
                class_3989 trader = (class_3989)class_1299.field_17713.method_5899(world, null, null, null, blockPos, class_3730.field_16467, false, false);
                if (trader != null) {
                    name = trader.method_5477().getString();
                    trader.method_18013(48000);
                }
            } else if (i == 1 && Config.getInstance().innSpawnsCultists) {
                VillagerEntityMCA adventurer2 = (VillagerEntityMCA)Gender.getRandom().getVillagerType().method_5899(world, null, null, null, blockPos, class_3730.field_16467, false, false);
                if (adventurer2 != null) {
                    name = adventurer2.method_5477().getString();
                    adventurer2.setProfession((class_3852)ProfessionsMCA.CULTIST.get());
                    adventurer2.setDespawnDelay(48000);
                }
            } else if (Config.getInstance().innSpawnsAdventurers && (adventurer = (VillagerEntityMCA)Gender.getRandom().getVillagerType().method_5899(world, null, null, null, blockPos, class_3730.field_16467, false, false)) != null) {
                name = adventurer.method_5477().getString();
                adventurer.setProfession((class_3852)ProfessionsMCA.ADVENTURER.get());
                adventurer.setDespawnDelay(48000);
            }
            if (name != null) {
                if (Config.getInstance().innArrivalNotification) {
                    this.broadCastMessage(world, "events.arrival.inn", name);
                }
                return true;
            }
        }
        return false;
    }

    public void broadCastMessage(class_3218 world, String event, VillagerEntityMCA suitor, VillagerEntityMCA mate) {
        world.method_18456().stream().filter(p -> PlayerSaveData.get(p).getLastSeenVillageId().orElse(-2).intValue() == this.getId() || suitor.getVillagerBrain().getMemoriesForPlayer((class_1657)p).getHearts() > Config.getInstance().heartsToBeConsideredAsFriend || mate.getVillagerBrain().getMemoriesForPlayer((class_1657)p).getHearts() > Config.getInstance().heartsToBeConsideredAsFriend).forEach(player -> player.method_7353((class_2561)class_2561.method_43469((String)event, (Object[])new Object[]{suitor.method_5477(), mate.method_5477()}), !Config.getInstance().showNotificationsAsChat));
    }

    public void broadCastMessage(class_3218 world, String event, VillagerEntityMCA target) {
        world.method_18456().stream().filter(p -> PlayerSaveData.get(p).getLastSeenVillageId().orElse(-2).intValue() == this.getId() || target.getVillagerBrain().getMemoriesForPlayer((class_1657)p).getHearts() > Config.getInstance().heartsToBeConsideredAsFriend).forEach(player -> player.method_7353((class_2561)class_2561.method_43469((String)event, (Object[])new Object[]{target.method_5477()}), !Config.getInstance().showNotificationsAsChat));
    }

    public void broadCastMessage(class_3218 world, String event, String targetName) {
        world.method_18456().stream().filter(p -> PlayerSaveData.get(p).getLastSeenVillageId().orElse(-2).intValue() == this.getId()).forEach(player -> player.method_7353((class_2561)class_2561.method_43469((String)event, (Object[])new Object[]{targetName}), !Config.getInstance().showNotificationsAsChat));
    }

    public void markDirty(class_3218 world) {
        VillageManager.get(world).method_80();
    }

    public void addResident(VillagerEntityMCA villager, int buildingId) {
        this.removeResident(villager);
        this.lastMoveIn = villager.field_6002.method_8510();
        this.buildings.get(buildingId).addResident((class_1297)villager);
        this.markDirty((class_3218)villager.field_6002);
    }

    public void removeResident(VillagerEntityMCA villager) {
        this.removeResident(villager.method_5667());
    }

    public void removeResident(UUID uuid) {
        this.buildings.values().forEach(b -> b.getResidents().remove(uuid));
    }

    public EquipmentSet getGuardEquipment(class_3852 profession, class_1268 dominantHand) {
        if (profession == ProfessionsMCA.ARCHER.get()) {
            if (this.hasBuilding("armory")) {
                if (this.hasBuilding("blacksmith")) {
                    return Village.getEquipmentFor(dominantHand, EquipmentSet.ARCHER_2, EquipmentSet.ARCHER_2_LEFT);
                }
                return Village.getEquipmentFor(dominantHand, EquipmentSet.ARCHER_1, EquipmentSet.ARCHER_1_LEFT);
            }
            return Village.getEquipmentFor(dominantHand, EquipmentSet.ARCHER_0, EquipmentSet.ARCHER_0_LEFT);
        }
        if (this.hasBuilding("armory")) {
            if (this.hasBuilding("blacksmith")) {
                return EquipmentSet.GUARD_2;
            }
            return EquipmentSet.GUARD_1;
        }
        return Village.getEquipmentFor(dominantHand, EquipmentSet.GUARD_0, EquipmentSet.GUARD_0_LEFT);
    }

    public static EquipmentSet getEquipmentFor(class_1268 dominantHand, EquipmentSet rightSet, EquipmentSet leftSet) {
        return dominantHand == class_1268.field_5810 && leftSet != null ? leftSet : rightSet;
    }

    public void cleanReputation() {
        Set residents = this.getResidentsUUIDs().collect(Collectors.toSet());
        for (Map<UUID, Integer> map : this.reputation.values()) {
            Set toRemove = map.keySet().stream().filter(v -> !residents.contains(v)).collect(Collectors.toSet());
            for (UUID uuid : toRemove) {
                map.remove(uuid);
            }
        }
    }

    public void setReputation(class_1657 player, VillagerEntityMCA villager, int rep) {
        this.reputation.computeIfAbsent(player.method_5667(), i -> new HashMap()).put(villager.method_5667(), rep);
        this.markDirty((class_3218)player.field_6002);
    }

    public int getReputation(class_1657 player) {
        return this.reputation.getOrDefault(player.method_5667(), Collections.emptyMap()).values().stream().mapToInt(i -> i).sum() + this.unspentHearts.getOrDefault(player.method_5667(), 0);
    }

    public void resetHearts(class_1657 player) {
        this.unspentHearts.remove(player.method_5667());
        this.markDirty((class_3218)player.field_6002);
    }

    public void pushHearts(class_1657 player, int rep) {
        this.pushHearts(player.method_5667(), rep);
        this.markDirty((class_3218)player.field_6002);
    }

    public void pushHearts(UUID player, int rep) {
        this.unspentHearts.put(player, this.unspentHearts.getOrDefault(player, 0) + rep);
    }

    public int popHearts(class_1657 player) {
        int v = this.unspentHearts.getOrDefault(player.method_5667(), 0);
        int step = (int)Math.ceil(Math.abs((double)v / (double)this.getPopulation()));
        if (v > 0) {
            if ((v -= step) == 0) {
                this.unspentHearts.remove(player.method_5667());
            } else {
                this.unspentHearts.put(player.method_5667(), v);
            }
            this.markDirty((class_3218)player.field_6002);
            return step;
        }
        if (v < 0) {
            if ((v += step) == 0) {
                this.unspentHearts.remove(player.method_5667());
            } else {
                this.unspentHearts.put(player.method_5667(), v);
            }
            this.markDirty((class_3218)player.field_6002);
            return -step;
        }
        return 0;
    }

    public void pushMood(class_3218 world, int m) {
        this.unspentMood += m;
        this.markDirty(world);
    }

    public int popMood(class_3218 world) {
        int step = (int)Math.ceil(Math.abs((double)this.unspentMood / (double)this.getPopulation()));
        if (this.unspentMood > 0) {
            this.unspentMood -= step;
            this.markDirty(world);
            return step;
        }
        if (this.unspentMood < 0) {
            this.unspentMood += step;
            this.markDirty(world);
            return -step;
        }
        return 0;
    }

    public class_2487 save() {
        class_2487 v = new class_2487();
        v.method_10569("id", this.id);
        v.method_10582("name", this.name);
        v.method_10569("taxes", this.taxes);
        v.method_10566("unspentHearts", (class_2520)NbtHelper.fromMap(new class_2487(), this.unspentHearts, UUID::toString, class_2497::method_23247));
        v.method_10566("reputation", (class_2520)NbtHelper.fromMap(new class_2487(), this.reputation, UUID::toString, i -> NbtHelper.fromMap(new class_2487(), i, UUID::toString, class_2497::method_23247)));
        v.method_10569("unspentMood", this.unspentMood);
        v.method_10569("populationThreshold", this.populationThreshold);
        v.method_10569("marriageThreshold", this.marriageThreshold);
        v.method_10566("buildings", (class_2520)NbtHelper.fromList(this.buildings.values(), Building::save));
        v.method_10556("autoScan", this.autoScan);
        return v;
    }

    public void load(class_2487 v) {
        this.id = v.method_10550("id");
        this.name = v.method_10558("name");
        this.taxes = v.method_10550("taxes");
        this.unspentHearts = NbtHelper.toMap(v.method_10562("unspentHearts"), UUID::fromString, i -> ((class_2497)i).method_10701());
        this.reputation = NbtHelper.toMap(v.method_10562("reputation"), UUID::fromString, i -> NbtHelper.toMap((class_2487)i, UUID::fromString, i2 -> ((class_2497)i2).method_10701()));
        this.unspentMood = v.method_10550("unspentMood");
        this.populationThreshold = v.method_10550("populationThreshold");
        this.marriageThreshold = v.method_10550("marriageThreshold");
        this.autoScan = v.method_10545("autoScan") ? v.method_10577("autoScan") : true;
        class_2499 b = v.method_10554("buildings", 10);
        for (int i2 = 0; i2 < b.size(); ++i2) {
            Building building = new Building(b.method_10602(i2));
            this.buildings.put(building.getId(), building);
        }
        if (!this.buildings.isEmpty()) {
            this.calculateDimensions();
        }
    }

    public void merge(Village village) {
        this.buildings.putAll(village.buildings);
        this.unspentMood += village.unspentMood;
        this.calculateDimensions();
    }

    public boolean isVillage() {
        return this.getBuildings().size() >= Config.getInstance().minimumBuildingsToBeConsideredAVillage;
    }

    private static /* synthetic */ void lambda$tick$6(class_2561 msg, class_3222 player) {
        player.method_7353(msg, true);
    }
}

