/*
 * Decompiled with CFR 0.152.
 */
package quilt.net.mca.server.world.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.apache.commons.lang3.tuple.Pair;
import quilt.net.mca.entity.ai.relationship.Gender;
import quilt.net.mca.item.ItemsMCA;
import quilt.net.mca.util.InventoryUtils;
import quilt.net.mca.util.NbtHelper;
import quilt.net.mca.util.WorldUtils;

public class BabyTracker
extends class_18 {
    private final Map<Key, Pairing> pairings = new HashMap<Key, Pairing>();

    public static BabyTracker get(class_3218 world) {
        return WorldUtils.loadData(world.method_8503().method_30002(), nbt -> new BabyTracker(world, (class_2487)nbt), BabyTracker::new, "mca_baby_tracker");
    }

    BabyTracker(class_3218 world) {
    }

    BabyTracker(class_3218 world, class_2487 nbt) {
        nbt.method_10554("pairings", 10).forEach(element -> {
            Pairing pairing = new Pairing((class_2487)element);
            this.pairings.put(pairing.key, pairing);
        });
    }

    public Optional<MutableChildSaveState> getSaveState(UUID id) {
        return this.pairings.values().stream().flatMap(pairing -> pairing.children.stream().filter(s -> s.id.equals(id))).findFirst();
    }

    public boolean hasActiveBaby(UUID mother, UUID father) {
        return false;
    }

    public Pairing getPairing(UUID mother, UUID father) {
        return this.getPairing(new Key(mother, father));
    }

    public Optional<Pairing> getPairingOrEmpty(UUID mother, UUID father) {
        return Optional.ofNullable(this.pairings.get(new Key(mother, father)));
    }

    public Pairing getPairing(ChildSaveState state) {
        return this.getPairing(state.key);
    }

    private Pairing getPairing(Key key) {
        return this.pairings.computeIfAbsent(key, x$0 -> new Pairing((Key)x$0));
    }

    public class_2487 method_75(class_2487 nbt) {
        class_2499 list = new class_2499();
        this.pairings.values().forEach(pairing -> list.add((Object)pairing.toNbt()));
        nbt.method_10566("pairings", (class_2520)list);
        return nbt;
    }

    public static Optional<MutableChildSaveState> getState(class_1799 stack, class_3218 world) {
        if (!BabyTracker.hasState(stack)) {
            return Optional.empty();
        }
        ChildSaveState state = new ChildSaveState(stack.method_7941("childData"));
        return BabyTracker.get((class_3218)world).getPairing((ChildSaveState)state).children.stream().filter(s -> s.id.equals(state.id)).findAny();
    }

    public static Optional<ChildSaveState> getState(class_1799 stack) {
        return BabyTracker.hasState(stack) ? Optional.of(new ChildSaveState(stack.method_7941("childData"))) : Optional.empty();
    }

    public static Optional<UUID> getStateId(class_1799 stack) {
        return BabyTracker.hasState(stack) ? Optional.of(stack.method_7941("childData").method_25926("id")) : Optional.empty();
    }

    public static boolean hasState(class_1799 stack) {
        return stack.method_7985() && !stack.method_7969().method_10577("invalidated") && stack.method_7969().method_10573("childData", 10) && stack.method_7941("childData").method_25928("id");
    }

    public static void invalidate(class_1799 stack) {
        stack.method_7983("childData");
        stack.method_7948().method_10556("invalidated", true);
    }

    private static class Key
    implements Comparable<Key> {
        private final Set<UUID> parents = new HashSet<UUID>();

        public Key(UUID mother, UUID father) {
            this.parents.add(mother);
            this.parents.add(father);
        }

        public Key(class_2499 nbt) {
            nbt.forEach(i -> this.parents.add(UUID.fromString(i.method_10714())));
        }

        public class_2499 toNbt() {
            class_2499 nbt = new class_2499();
            this.parents.forEach(parent -> nbt.add((Object)class_2519.method_23256((String)parent.toString())));
            return nbt;
        }

        @Override
        public int compareTo(Key o) {
            return this.equals(o) ? 0 : 1;
        }

        private boolean equals(Key o) {
            return o != null && o.parents.equals(this.parents);
        }

        public boolean equals(Object o) {
            return o instanceof Key && this.equals((Key)o);
        }

        public int hashCode() {
            return this.parents.hashCode();
        }
    }

    public final class Pairing {
        private final Key key;
        private final List<MutableChildSaveState> children;

        public Pairing(Key key) {
            this.key = key;
            this.children = new ArrayList<MutableChildSaveState>();
            BabyTracker.this.method_80();
        }

        public Pairing(class_2487 tag) {
            this.key = new Key(tag.method_10554("key", 8));
            this.children = NbtHelper.toList((class_2520)tag.method_10554("children", 10), c -> new MutableChildSaveState((class_2487)c));
        }

        public int getChildCount() {
            return this.children.size();
        }

        public void addChild(Consumer<MutableChildSaveState> factory) {
            MutableChildSaveState state = new MutableChildSaveState(this.key);
            factory.accept(state);
            this.children.add(state);
            BabyTracker.this.method_80();
        }

        public void removeChild(ChildSaveState state) {
            this.children.removeIf(o -> o.id.equals(state.id));
        }

        public List<ChildSaveState> getChildren() {
            return new ArrayList<ChildSaveState>(this.children);
        }

        public Pair<class_1799, Placement> locateBaby(class_1657 player) {
            int slot = InventoryUtils.getFirstSlotContainingItem((class_1263)player.method_31548(), stack -> BabyTracker.getState(stack).filter(state -> state.key.equals(this.key)).isPresent());
            if (slot >= 0) {
                return Pair.of((Object)player.method_31548().method_5438(slot), (Object)((Object)Placement.INVENTORY));
            }
            slot = InventoryUtils.getFirstSlotContainingItem((class_1263)player.method_7274(), stack -> BabyTracker.getState(stack).filter(state -> state.key.equals(this.key)).isPresent());
            if (slot >= 0) {
                return Pair.of((Object)player.method_7274().method_5438(slot), (Object)((Object)Placement.ENDER_CHEST));
            }
            return Pair.of((Object)class_1799.field_8037, (Object)((Object)Placement.MISSING));
        }

        public class_2487 toNbt() {
            class_2487 tag = new class_2487();
            tag.method_10566("key", (class_2520)this.key.toNbt());
            tag.method_10566("children", (class_2520)NbtHelper.fromList(this.children, child -> child.writeToNbt(new class_2487())));
            return tag;
        }

        public void reconstructBaby(class_3222 player) {
            this.getChildren().forEach(c -> {
                class_1799 stack = new class_1799(c.getGender() == Gender.MALE ? (class_1935)ItemsMCA.BABY_BOY.get() : (class_1935)ItemsMCA.BABY_GIRL.get());
                c.writeToNbt(stack.method_7911("childData"));
                player.method_31548().method_7394(stack);
            });
        }
    }

    public static class ChildSaveState {
        final UUID id;
        protected Gender gender;
        protected boolean infected;
        protected long seed;
        protected Optional<String> name = Optional.empty();
        private final Key key;
        protected Optional<Pair<UUID, String>> owner = Optional.empty();

        ChildSaveState(Key key) {
            this.id = UUID.randomUUID();
            this.key = key;
        }

        public ChildSaveState(class_2487 tag) {
            this.id = tag.method_25926("id");
            this.gender = Gender.byName(tag.method_10558("gender"));
            this.infected = tag.method_10577("infected");
            this.name = tag.method_10545("name") ? Optional.of(tag.method_10558("name")) : Optional.empty();
            this.seed = tag.method_10537("seed");
            this.key = new Key(tag.method_10554("key", 8));
        }

        public UUID getId() {
            return this.id;
        }

        public Stream<UUID> getParents() {
            return this.key.parents.stream();
        }

        public boolean isInfected() {
            return this.infected;
        }

        public Optional<String> getName() {
            return this.name;
        }

        public Optional<Pair<UUID, String>> getOwner() {
            return this.owner;
        }

        public long getSeed() {
            return this.seed;
        }

        public Gender getGender() {
            return this.gender;
        }

        public class_2487 writeToNbt(class_2487 tag) {
            tag.method_25927("id", this.id);
            tag.method_10582("gender", this.gender.getStrName());
            tag.method_10556("infected", this.infected);
            tag.method_10566("key", (class_2520)this.key.toNbt());
            tag.method_10544("seed", this.seed);
            this.name.ifPresent(n -> tag.method_10582("name", n));
            return tag;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        private boolean equals(ChildSaveState o) {
            return o == this || o != null && o.id.equals(this.id);
        }

        public boolean equals(Object o) {
            return o == this || o instanceof ChildSaveState && this.equals((ChildSaveState)o);
        }
    }

    public class MutableChildSaveState
    extends ChildSaveState {
        MutableChildSaveState(Key key) {
            super(key);
        }

        public MutableChildSaveState(class_2487 tag) {
            super(tag);
        }

        public MutableChildSaveState setGender(Gender gender) {
            this.gender = gender;
            BabyTracker.this.method_80();
            return this;
        }

        public MutableChildSaveState setInfected(boolean infected) {
            this.infected = infected;
            BabyTracker.this.method_80();
            return this;
        }

        public MutableChildSaveState setName(String name) {
            this.name = Optional.ofNullable(name);
            BabyTracker.this.method_80();
            return this;
        }

        public MutableChildSaveState setOwner(class_1297 entity) {
            this.owner = Optional.of(Pair.of((Object)entity.method_5667(), (Object)entity.method_5477().getString()));
            BabyTracker.this.method_80();
            return this;
        }

        public MutableChildSaveState setSeed(long seed) {
            this.seed = seed;
            BabyTracker.this.method_80();
            return this;
        }

        public class_1799 createItem() {
            return this.writeToItem(((class_1792)(this.gender.binary() == Gender.MALE ? ItemsMCA.BABY_BOY : ItemsMCA.BABY_GIRL).get()).method_7854());
        }

        public class_1799 writeToItem(class_1799 stack) {
            this.writeToNbt(stack.method_7911("childData"));
            return stack;
        }
    }

    public static enum Placement {
        INVENTORY,
        ENDER_CHEST,
        MISSING;


        public boolean wasFound() {
            return this != MISSING;
        }
    }
}

