/*
 * Decompiled with CFR 0.152.
 */
package quilt.net.mca.server;

import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1641;
import net.minecraft.class_1646;
import net.minecraft.class_2378;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import quilt.net.mca.Config;
import quilt.net.mca.ducks.IVillagerEntity;
import quilt.net.mca.entity.VillagerFactory;
import quilt.net.mca.entity.ZombieVillagerEntityMCA;
import quilt.net.mca.entity.ZombieVillagerFactory;
import quilt.net.mca.entity.ai.relationship.Gender;
import quilt.net.mca.server.world.data.Nationality;

public class SpawnQueue {
    private static final SpawnQueue INSTANCE = new SpawnQueue();
    private final List<class_1646> villagerSpawnQueue = new LinkedList<class_1646>();
    private final List<class_1641> zombieVillagerSpawnQueue = new LinkedList<class_1641>();

    public static SpawnQueue getInstance() {
        return INSTANCE;
    }

    public void tick() {
        class_1646 e;
        if (!this.villagerSpawnQueue.isEmpty()) {
            e = this.villagerSpawnQueue.remove(0);
            if (e.field_6002.method_8477(e.method_24515())) {
                e.method_31472();
                VillagerFactory.newVillager(e.field_6002).withName(e.method_16914() ? e.method_5477().getString() : null).withGender(Gender.getRandom()).withAge(e.method_5618()).withPosition((class_1297)e).withType(e.method_7231().method_16919()).withProfession(e.method_7231().method_16924(), e.method_7231().method_16925(), e.method_8264()).spawn(((IVillagerEntity)e).getSpawnReason());
            } else {
                this.villagerSpawnQueue.add(e);
            }
        }
        if (!this.zombieVillagerSpawnQueue.isEmpty()) {
            e = this.zombieVillagerSpawnQueue.remove(0);
            if (e.field_6002.method_8477(e.method_24515())) {
                e.method_31472();
                ZombieVillagerEntityMCA z = ZombieVillagerFactory.newVillager(e.field_6002).withName(e.method_16914() ? e.method_5477().getString() : null).withGender(Gender.getRandom()).withPosition((class_1297)e).withType(e.method_7231().method_16919()).withProfession(e.method_7231().method_16924(), e.method_7231().method_16925()).spawn(((IVillagerEntity)e).getSpawnReason());
                if (e.method_5947()) {
                    z.method_5971();
                }
            } else {
                this.zombieVillagerSpawnQueue.add((class_1641)e);
            }
        }
    }

    public static boolean shouldGetConverted(class_1297 entity) {
        if (Config.getInstance().percentageOfVanillaVillages <= 0) {
            return true;
        }
        int i = Nationality.get((class_3218)entity.method_37908()).getRegionId(entity.method_24515());
        return Math.floorMod(i, 100) >= Config.getInstance().percentageOfVanillaVillages;
    }

    public boolean addVillager(class_1297 entity) {
        IVillagerEntity villagerEntity;
        if (entity instanceof IVillagerEntity && !this.handlesSpawnReason((villagerEntity = (IVillagerEntity)entity).getSpawnReason())) {
            return false;
        }
        if (Config.getInstance().villagerDimensionBlacklist.contains(entity.method_5770().method_27983().method_29177().toString())) {
            return false;
        }
        if (Config.getInstance().overwriteOriginalVillagers && (entity.getClass().equals(class_1646.class) || Config.getInstance().moddedVillagerWhitelist.contains(class_2378.field_11145.method_10221((Object)entity.method_5864()).toString()) && entity instanceof class_1646) && SpawnQueue.shouldGetConverted(entity) && !this.villagerSpawnQueue.contains(entity)) {
            return this.villagerSpawnQueue.add((class_1646)entity);
        }
        if (Config.getInstance().overwriteOriginalZombieVillagers && (entity.getClass().equals(class_1641.class) || Config.getInstance().moddedZombieVillagerWhitelist.contains(class_2378.field_11145.method_10221((Object)entity.method_5864()).toString()) && entity instanceof class_1641) && !this.zombieVillagerSpawnQueue.contains(entity)) {
            return this.zombieVillagerSpawnQueue.add((class_1641)entity);
        }
        return false;
    }

    private boolean handlesSpawnReason(class_3730 reason) {
        return Config.getInstance().allowedSpawnReasons.contains(reason.name().toLowerCase());
    }

    public void convert(class_1646 villager) {
        this.villagerSpawnQueue.add(villager);
    }
}

