/*
 * Decompiled with CFR 0.152.
 */
package quilt.net.mca.resources.data;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import quilt.net.mca.MCA;
import quilt.net.mca.util.RegistryHelper;

public final class BuildingType
implements Serializable {
    private static final long serialVersionUID = 2215455350801127280L;
    private final String name;
    private final int size;
    private final String color;
    private final int priority;
    private final boolean visible;
    private final Map<String, Integer> blocks;
    private transient Map<class_2960, class_2960> blockToGroup;
    private transient Map<class_2960, Integer> groups;
    private final boolean icon;
    private final int iconU;
    private final int iconV;
    private final boolean grouped;
    private final int mergeRange;
    private final boolean noBeds;

    public BuildingType() {
        this("?", 0, "ffffffff", 0, true, false);
    }

    public BuildingType(String name, int size, String color, int priority, boolean visible, boolean noBeds) {
        this.name = name;
        this.size = size;
        this.color = color;
        this.priority = priority;
        this.visible = visible;
        this.noBeds = noBeds;
        this.blocks = Map.of("#minecraft:beds", 1000000000);
        this.blockToGroup = null;
        this.icon = false;
        this.iconU = 0;
        this.iconV = 0;
        this.grouped = false;
        this.mergeRange = 32;
    }

    public String name() {
        return this.name;
    }

    public int size() {
        return this.size;
    }

    public String color() {
        return this.color;
    }

    public int priority() {
        return this.priority;
    }

    public boolean visible() {
        return this.visible;
    }

    public int getColor() {
        return (int)Long.parseLong(this.color, 16);
    }

    public Map<class_2960, class_2960> getBlockToGroup() {
        if (this.blockToGroup == null) {
            this.blockToGroup = new HashMap<class_2960, class_2960>();
            this.groups = new HashMap<class_2960, Integer>();
            for (Map.Entry<String, Integer> requirement : this.blocks.entrySet()) {
                class_2960 identifier;
                if (requirement.getKey().startsWith("#")) {
                    identifier = new class_2960(requirement.getKey().substring(1));
                    class_6862 tag = class_6862.method_40092((class_5321)class_2378.field_25105, (class_2960)identifier);
                    if (tag == null || RegistryHelper.isTagEmpty(tag)) {
                        MCA.LOGGER.error("Unknown building type tag " + identifier);
                    } else {
                        Optional<class_6885<class_6885>> entries = RegistryHelper.getEntries(tag);
                        entries.ifPresent(registryEntries -> {
                            for (class_2248 b : registryEntries.method_40239().map(class_6880::comp_349).toList()) {
                                this.blockToGroup.putIfAbsent(class_2378.field_11146.method_10221((Object)b), identifier);
                            }
                        });
                    }
                } else {
                    identifier = new class_2960(requirement.getKey());
                    this.blockToGroup.put(identifier, identifier);
                }
                this.groups.put(identifier, requirement.getValue());
            }
        }
        return this.blockToGroup;
    }

    public Map<class_2960, Integer> getGroups() {
        this.getBlockToGroup();
        return this.groups;
    }

    public Map<class_2960, List<class_2338>> getGroups(Map<class_2960, List<class_2338>> blocks) {
        HashMap<class_2960, List<class_2338>> available = new HashMap<class_2960, List<class_2338>>();
        for (Map.Entry<class_2960, List<class_2338>> entry : blocks.entrySet()) {
            Optional.ofNullable(this.getBlockToGroup().get(entry.getKey())).ifPresent(v -> available.computeIfAbsent((class_2960)v, k -> new LinkedList()).addAll((Collection)entry.getValue()));
        }
        return available;
    }

    public boolean isIcon() {
        return this.icon;
    }

    public int iconU() {
        return this.iconU * 20;
    }

    public int iconV() {
        return this.iconV * 60;
    }

    public boolean grouped() {
        return this.grouped;
    }

    public int mergeRange() {
        return this.mergeRange;
    }

    public boolean noBeds() {
        return this.noBeds;
    }
}

