/*
 * Decompiled with CFR 0.152.
 */
package quilt.net.mca.item;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3544;
import net.minecraft.class_3730;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import quilt.net.mca.ClientProxy;
import quilt.net.mca.Config;
import quilt.net.mca.advancement.criterion.CriterionMCA;
import quilt.net.mca.cobalt.network.NetworkHandler;
import quilt.net.mca.entity.VillagerEntityMCA;
import quilt.net.mca.entity.VillagerFactory;
import quilt.net.mca.entity.VillagerLike;
import quilt.net.mca.entity.ai.Memories;
import quilt.net.mca.entity.ai.Traits;
import quilt.net.mca.entity.ai.relationship.AgeState;
import quilt.net.mca.entity.ai.relationship.Gender;
import quilt.net.mca.entity.ai.relationship.family.FamilyTree;
import quilt.net.mca.entity.ai.relationship.family.FamilyTreeNode;
import quilt.net.mca.network.c2s.GetChildDataRequest;
import quilt.net.mca.network.s2c.OpenGuiRequest;
import quilt.net.mca.server.world.data.BabyTracker;
import quilt.net.mca.util.WorldUtils;

public class BabyItem
extends class_1792 {
    public static final LoadingCache<UUID, Optional<BabyTracker.ChildSaveState>> CLIENT_STATE_CACHE = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build(CacheLoader.from(id -> {
        NetworkHandler.sendToServer(new GetChildDataRequest((UUID)id));
        return Optional.empty();
    }));
    private final Gender gender;

    public BabyItem(Gender gender, class_1792.class_1793 properties) {
        super(properties);
        this.gender = gender;
    }

    public Gender getGender() {
        return this.gender;
    }

    public class_1269 method_7884(class_1838 context) {
        return class_1269.field_5811;
    }

    public boolean onDropped(class_1799 stack, class_1657 player) {
        if (!BabyItem.hasBeenInvalidated(stack)) {
            if (!player.method_37908().field_9236) {
                int count = 0;
                if (stack.method_7948().method_10573("dropAttempts", 3)) {
                    count = stack.method_7948().method_10550("dropAttempts") + 1;
                }
                stack.method_7948().method_10569("dropAttempts", count);
                CriterionMCA.BABY_DROPPED_CRITERION.trigger((class_3222)player, count);
                player.method_7353((class_2561)class_2561.method_43471((String)"item.mca.baby.no_drop"), true);
            }
            return false;
        }
        return true;
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (world.field_9236) {
            return;
        }
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            if (world.method_8510() % 20L == 0L) {
                HashSet found = new HashSet();
                int i = player.method_31548().method_5439() - 1;
                while (i >= 0) {
                    class_1799 s = player.method_31548().method_5438(i);
                    int sl = i--;
                    BabyTracker.getStateId(s).ifPresent(id -> {
                        if (found.contains(id)) {
                            player.method_31548().method_5441(sl);
                        } else {
                            found.add(id);
                        }
                    });
                }
            }
        }
        if (BabyTracker.hasState(stack)) {
            Optional<BabyTracker.MutableChildSaveState> state2 = BabyTracker.getState(stack, (class_3218)world);
            if (state2.isPresent()) {
                if (stack.method_7938()) {
                    state2.get().setName(stack.method_7964().getString());
                    state2.get().writeToItem(stack);
                    stack.method_7925();
                    if (entity instanceof class_3222) {
                        class_3222 player = (class_3222)entity;
                        CriterionMCA.GENERIC_EVENT_CRITERION.trigger(player, "rename_baby");
                    }
                }
                if (state2.get().getName().isPresent() && world.method_8510() % 1200L == 0L) {
                    stack.method_7969().method_10569("age", stack.method_7969().method_10550("age") + 1200);
                }
            } else {
                BabyTracker.invalidate(stack);
            }
        } else if (!stack.method_7985() || !stack.method_7969().method_10577("invalidated")) {
            BabyTracker.get((class_3218)world).getPairing(entity.method_5667(), entity.method_5667()).addChild(state -> {
                state.setGender(this.gender);
                state.setOwner(entity);
                state.writeToItem(stack);
            });
        }
    }

    public class_2561 method_7864(class_1799 stack) {
        return BabyItem.getClientCheckedState(stack).flatMap(BabyTracker.ChildSaveState::getName).map(s -> class_2561.method_43469((String)(this.method_7866(stack) + ".named"), (Object[])new Object[]{s})).orElseGet(() -> super.method_7864(stack));
    }

    public String method_7866(class_1799 stack) {
        if (BabyItem.hasBeenInvalidated(stack)) {
            return super.method_7866(stack) + ".blanket";
        }
        return super.method_7866(stack);
    }

    public final class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (world.field_9236) {
            return class_1271.method_22430((Object)stack);
        }
        return BabyTracker.getState(stack, (class_3218)world).map(state -> {
            if (state.getName().isEmpty()) {
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    NetworkHandler.sendToPlayer(new OpenGuiRequest(OpenGuiRequest.Type.BABY_NAME), serverPlayer);
                }
                return class_1271.method_22430((Object)stack);
            }
            if (!BabyItem.isReadyToGrowUp(stack)) {
                return class_1271.method_22430((Object)stack);
            }
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                this.birthChild((BabyTracker.ChildSaveState)state, (class_3218)world, serverPlayer);
            }
            stack.method_7934(1);
            return class_1271.method_22427((Object)stack);
        }).orElseGet(() -> {
            if (BabyTracker.getState(stack).isPresent()) {
                world.method_8421((class_1297)player, (byte)43);
                player.method_5783(class_3417.field_14641, 1.0f, 1.0f);
                BabyTracker.invalidate(stack);
                return class_1271.method_22431((Object)stack);
            }
            return class_1271.method_22431((Object)stack);
        });
    }

    protected VillagerEntityMCA birthChild(BabyTracker.ChildSaveState state, class_3218 world, class_3222 player) {
        VillagerEntityMCA child = VillagerFactory.newVillager((class_1937)world).withName(state.getName().orElse("Unnamed")).withPosition(player.method_19538()).withGender(this.gender).withAge(-AgeState.getMaxAge()).build();
        List<class_1297> parents = state.getParents().map(arg_0 -> ((class_3218)world).method_14190(arg_0)).filter(Objects::nonNull).toList();
        Optional mother = parents.stream().findFirst();
        Optional father = parents.stream().skip(1L).findFirst();
        child.getGenetics().combine(mother.map(VillagerLike::toVillager).map(VillagerLike::getGenetics), father.map(VillagerLike::toVillager).map(VillagerLike::getGenetics), state.getSeed());
        mother.map(VillagerLike::toVillager).map(VillagerLike::getTraits).ifPresent(t -> child.getTraits().inherit((Traits)t, state.getSeed()));
        father.map(VillagerLike::toVillager).map(VillagerLike::getTraits).ifPresent(t -> child.getTraits().inherit((Traits)t, state.getSeed()));
        state.getParents().forEach(p -> FamilyTree.get(world).getOrEmpty((UUID)p).ifPresent(parent -> child.getRelationships().getFamilyEntry().assignParent((FamilyTreeNode)parent)));
        WorldUtils.spawnEntity((class_1937)world, (class_1308)child, class_3730.field_16466);
        Stream.concat(Stream.of(mother, father).filter(Optional::isPresent).map(Optional::get), Stream.of(player)).filter(e -> e instanceof class_3222).map(class_3222.class::cast).distinct().forEach(ply -> {
            CriterionMCA.FAMILY.trigger((class_3222)ply);
            Memories memories = child.getVillagerBrain().getMemoriesForPlayer((class_1657)ply);
            memories.setHearts(Config.getInstance().childInitialHearts);
        });
        BabyTracker.get(world).getPairing(state).removeChild(state);
        return child;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 flag) {
        BabyItem.getClientState(stack).ifPresent(state -> {
            class_1657 player = ClientProxy.getClientPlayer();
            class_2487 nbt = stack.method_7969();
            assert (nbt != null);
            int age = nbt.method_10550("age") + (int)(world == null ? 0L : world.method_8510() % 1200L);
            if (state.getName().isEmpty()) {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.mca.baby.give_name").method_27692(class_124.field_1054));
            } else {
                class_5250 text = class_2561.method_43470((String)state.getName().get());
                tooltip.add((class_2561)class_2561.method_43469((String)"item.mca.baby.name", (Object[])new Object[]{text.method_10862(text.method_10866().method_36139(this.gender.getColor()))}).method_27692(class_124.field_1080));
                if (age > 0) {
                    tooltip.add((class_2561)class_2561.method_43469((String)"item.mca.baby.age", (Object[])new Object[]{class_3544.method_15439((int)age)}).method_27692(class_124.field_1080));
                }
            }
            tooltip.add((class_2561)class_2561.method_43470((String)""));
            state.getOwner().ifPresent(owner -> tooltip.add((class_2561)class_2561.method_43469((String)"item.mca.baby.owner", (Object[])new Object[]{player != null && ((UUID)owner.getLeft()).equals(player.method_5667()) ? class_2561.method_43471((String)"item.mca.baby.owner.you") : owner.getRight()}).method_27692(class_124.field_1080)));
            if (state.getName().isPresent() && BabyItem.canGrow(age)) {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.mca.baby.state.ready").method_27692(class_124.field_1077));
            }
            if (state.isInfected()) {
                tooltip.add((class_2561)class_2561.method_43471((String)"item.mca.baby.state.infected").method_27692(class_124.field_1077));
            }
        });
    }

    private static Optional<BabyTracker.ChildSaveState> getClientCheckedState(class_1799 stack) {
        return BabyTracker.getState(stack).map(state -> {
            Optional loaded = (Optional)CLIENT_STATE_CACHE.getIfPresent((Object)state.getId());
            if (loaded == null) {
                return state;
            }
            if (loaded.isPresent()) {
                BabyTracker.ChildSaveState l = (BabyTracker.ChildSaveState)loaded.get();
                if (state.getName().isPresent() && l.getName().isEmpty() || state.getName().isPresent() && l.getName().isPresent() && !state.getName().get().contentEquals(l.getName().get())) {
                    CLIENT_STATE_CACHE.refresh((Object)state.getId());
                    return state;
                }
                return l;
            }
            return state;
        });
    }

    private static Optional<BabyTracker.ChildSaveState> getClientState(class_1799 stack) {
        return BabyTracker.getState(stack).flatMap(state -> {
            try {
                return (Optional)CLIENT_STATE_CACHE.get((Object)state.getId());
            }
            catch (ExecutionException e) {
                return Optional.of(state);
            }
        });
    }

    public static boolean hasBeenInvalidated(class_1799 stack) {
        return stack.method_7985() && stack.method_7969().method_10577("invalidated") || BabyTracker.getStateId(stack).map(id -> {
            Optional loaded = (Optional)CLIENT_STATE_CACHE.getIfPresent(id);
            return loaded != null && loaded.isEmpty();
        }).orElse(false) != false;
    }

    private static boolean canGrow(int age) {
        return age >= Config.getInstance().babyItemGrowUpTime;
    }

    private static boolean isReadyToGrowUp(class_1799 stack) {
        return stack.method_7985() && BabyItem.canGrow(stack.method_7969().method_10550("age"));
    }
}

