/*
 * Decompiled with CFR 0.152.
 */
package quilt.net.mca.entity.ai.relationship;

import java.util.Locale;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import quilt.net.mca.Config;
import quilt.net.mca.entity.ai.relationship.VillagerDimensions;
import quilt.net.mca.resources.API;

public enum AgeState implements VillagerDimensions
{
    UNASSIGNED(1.0f, 0.9f, 1.0f, 1.0f, 1.0f, 1.0f),
    BABY(0.45f, 0.45f, 0.0f, 1.5f, 0.0f, 1.6f),
    TODDLER(0.6f, 0.6f, 0.0f, 1.3f, 0.6f, 1.4f),
    CHILD(0.7f, 0.7f, 0.0f, 1.2f, 0.85f, 1.2f),
    TEEN(0.85f, 0.85f, 0.5f, 1.0f, 1.05f, 1.0f),
    ADULT(1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);

    private static final AgeState[] VALUES;
    private final float width;
    private final float height;
    private final float breasts;
    private final float head;
    private final float speed;
    private final float pitch;

    public static int getMaxAge() {
        return Config.getInstance().villagerMaxAgeTime;
    }

    public static int getStageDuration() {
        return AgeState.getMaxAge() / 4;
    }

    private AgeState(float width, float height, float breasts, float head, float speed, float pitch) {
        this.width = width;
        this.height = height;
        this.breasts = breasts;
        this.head = head;
        this.speed = speed;
        this.pitch = pitch;
    }

    public class_2561 getName() {
        return class_2561.method_43471((String)("enum.agestate." + this.name().toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public float getBreasts() {
        return this.breasts;
    }

    public float getPitch() {
        return this.pitch;
    }

    @Override
    public float getHead() {
        return this.head;
    }

    public float getSpeed() {
        return this.speed;
    }

    public AgeState getNext() {
        if (this == ADULT) {
            return this;
        }
        return AgeState.byId(this.ordinal() + 1);
    }

    public static AgeState byId(int id) {
        if (id < 0 || id >= VALUES.length) {
            return UNASSIGNED;
        }
        return VALUES[id];
    }

    public static AgeState random() {
        return AgeState.byCurrentAge((int)(-API.getRng().method_43057() * (float)AgeState.getMaxAge()));
    }

    public static float getDelta(float age) {
        return 1.0f - -age % (float)AgeState.getStageDuration() / (float)AgeState.getStageDuration();
    }

    public static int getId(int age) {
        return class_3532.method_15340((int)(1 + (age + AgeState.getMaxAge()) / AgeState.getStageDuration()), (int)0, (int)5);
    }

    public static AgeState byCurrentAge(int age) {
        return AgeState.byId(AgeState.getId(age));
    }

    public int toAge() {
        return (this.ordinal() - 1) * AgeState.getStageDuration() - AgeState.getMaxAge();
    }

    static {
        VALUES = AgeState.values();
    }
}

