/*
 * Decompiled with CFR 0.152.
 */
package quilt.net.mca.entity.ai.brain.tasks;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;
import quilt.net.mca.Config;
import quilt.net.mca.entity.VillagerEntityMCA;
import quilt.net.mca.entity.ai.Memories;
import quilt.net.mca.entity.ai.Relationship;
import quilt.net.mca.entity.ai.relationship.CompassionateEntity;
import quilt.net.mca.server.world.data.PlayerSaveData;
import quilt.net.mca.server.world.data.Village;

public class GreetPlayerTask
extends class_4097<VillagerEntityMCA> {
    private static final int MAX_COOLDOWN = 2000;
    private Optional<? extends class_1657> target = Optional.empty();
    private int cooldown;
    private boolean talked;

    public GreetPlayerTask() {
        super((Map)ImmutableMap.of((Object)class_4140.field_18445, (Object)class_4141.field_18458, (Object)class_4140.field_18446, (Object)class_4141.field_18458, (Object)class_4140.field_18447, (Object)class_4141.field_18458), 600);
    }

    protected boolean shouldRun(class_3218 world, VillagerEntityMCA villager) {
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        this.cooldown = 2000;
        Optional<? extends class_1657> player = GreetPlayerTask.getPlayer(villager);
        return player.isPresent() && GreetPlayerTask.isWithinSeeRange(villager, player.get());
    }

    protected void run(class_3218 world, VillagerEntityMCA villager, long time) {
        this.target = GreetPlayerTask.getPlayer(villager);
        this.target.ifPresent(player -> {
            villager.method_18868().method_18878(class_4140.field_18447, player);
            class_4215.method_19554((class_1309)villager, (class_1309)player);
            this.talked = false;
        });
    }

    protected boolean shouldKeepRunning(class_3218 world, VillagerEntityMCA villager, long time) {
        return !this.talked && !villager.getVillagerBrain().isPanicking() && !villager.method_6113();
    }

    protected void keepRunning(class_3218 world, VillagerEntityMCA villager, long time) {
        this.target.ifPresent(player -> {
            class_4215.method_19554((class_1309)villager, (class_1309)player);
            if (GreetPlayerTask.isWithinGreetingDistance(villager, player)) {
                Memories memories = villager.getVillagerBrain().getMemoriesForPlayer((class_1657)player);
                int day = (int)(villager.field_6002.method_8532() / 24000L);
                memories.setLastSeen(day);
                String phrase = memories.getHearts() < 0 ? "welcomeFoe" : "welcome";
                villager.sendChatMessage((class_1657)player, phrase, new Object[]{player.method_5477()});
                this.talked = true;
                villager.playWelcomeSound();
            } else {
                class_4215.method_24557((class_1309)villager, (class_1297)player, (float)0.55f, (int)2);
            }
        });
    }

    protected void finishRunning(class_3218 world, VillagerEntityMCA villager, long time) {
        if (!this.talked && this.target.isPresent()) {
            Memories memories = villager.getVillagerBrain().getMemoriesForPlayer(this.target.get());
            memories.setLastSeen(-1);
        }
        this.target = Optional.empty();
        villager.method_18868().method_18875(class_4140.field_18447);
        villager.method_18868().method_18875(class_4140.field_18445);
        villager.method_18868().method_18875(class_4140.field_18446);
    }

    private static Optional<? extends class_1657> getPlayer(VillagerEntityMCA villager) {
        return ((class_3218)villager.field_6002).method_18456().stream().filter(p -> GreetPlayerTask.shouldGreet(villager, p)).findFirst();
    }

    private static boolean shouldGreet(VillagerEntityMCA villager, class_3222 player) {
        Optional<Integer> id = PlayerSaveData.get(player).getLastSeenVillageId();
        Optional<Village> village = villager.getResidency().getHomeVillage();
        if (id.isPresent() && village.isPresent() && id.get().intValue() == village.get().getId()) {
            Memories memories = villager.getVillagerBrain().getMemoriesForPlayer((class_1657)player);
            int day = (int)(villager.field_6002.method_8532() / 24000L);
            if (Relationship.IS_MARRIED.test((CompassionateEntity<?>)villager, (class_1297)player) || Relationship.IS_RELATIVE.test((CompassionateEntity<?>)villager, (class_1297)player) || Math.abs(memories.getHearts()) >= Config.getInstance().greetHeartsThreshold) {
                long diff = (long)day - memories.getLastSeen();
                if (diff > (long)Config.getInstance().greetAfterDays && memories.getLastSeen() > 0L) {
                    return true;
                }
                if (diff > 0L) {
                    memories.setLastSeen(day);
                }
            } else {
                memories.setLastSeen(day);
            }
        }
        return false;
    }

    private static boolean isWithinGreetingDistance(VillagerEntityMCA villager, class_1657 player) {
        return villager.method_24515().method_19771((class_2382)player.method_24515(), 3.0);
    }

    private static boolean isWithinSeeRange(VillagerEntityMCA villager, class_1657 player) {
        return villager.method_24515().method_19771((class_2382)player.method_24515(), 32.0);
    }
}

