/*
 * Decompiled with CFR 0.152.
 */
package quilt.net.mca.entity.ai.brain;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4140;
import net.minecraft.class_4168;
import org.jetbrains.annotations.Nullable;
import quilt.net.mca.Config;
import quilt.net.mca.advancement.criterion.CriterionMCA;
import quilt.net.mca.entity.EntityWrapper;
import quilt.net.mca.entity.VillagerEntityMCA;
import quilt.net.mca.entity.VillagerLike;
import quilt.net.mca.entity.ai.ActivityMCA;
import quilt.net.mca.entity.ai.Chore;
import quilt.net.mca.entity.ai.Memories;
import quilt.net.mca.entity.ai.MemoryModuleTypeMCA;
import quilt.net.mca.entity.ai.Mood;
import quilt.net.mca.entity.ai.MoodGroup;
import quilt.net.mca.entity.ai.MoveState;
import quilt.net.mca.entity.ai.relationship.Personality;
import quilt.net.mca.util.network.datasync.CDataManager;
import quilt.net.mca.util.network.datasync.CDataParameter;
import quilt.net.mca.util.network.datasync.CEnumParameter;
import quilt.net.mca.util.network.datasync.CParameter;
import quilt.net.mca.util.network.datasync.CTrackedEntity;

public class VillagerBrain<E extends class_1308> {
    private static final CDataParameter<class_2487> MEMORIES = CParameter.create("memories", new class_2487());
    private static final CEnumParameter<Personality> PERSONALITY = CParameter.create("personality", Personality.UNASSIGNED);
    private static final CDataParameter<Integer> MOOD = CParameter.create("mood", 0);
    private static final CEnumParameter<MoveState> MOVE_STATE = CParameter.create("moveState", MoveState.MOVE);
    private static final CEnumParameter<Chore> ACTIVE_CHORE = CParameter.create("activeChore", Chore.NONE);
    private static final CDataParameter<Optional<UUID>> CHORE_ASSIGNING_PLAYER = CParameter.create("choreAssigningPlayer", Optional.empty());
    private static final CDataParameter<Boolean> PANICKING = CParameter.create("isPanicking", false);
    private static final CDataParameter<Boolean> WEAR_ARMOR = CParameter.create("wearArmor", false);
    private final E entity;

    public static <E extends class_1297> CDataManager.Builder<E> createTrackedData(CDataManager.Builder<E> builder) {
        return builder.addAll(MEMORIES, PERSONALITY, MOOD, MOVE_STATE, ACTIVE_CHORE, CHORE_ASSIGNING_PLAYER, PANICKING, WEAR_ARMOR);
    }

    public VillagerBrain(E entity) {
        this.entity = entity;
    }

    public void think() {
        class_2487 nbt;
        boolean panicking;
        if (((CTrackedEntity)this.entity).getTrackedValue(ACTIVE_CHORE) != Chore.NONE) {
            this.entity.method_18868().method_24538().ifPresent(activity -> {
                if (!activity.equals(ActivityMCA.CHORE.get())) {
                    this.entity.method_18868().method_24526((class_4168)ActivityMCA.CHORE.get());
                }
            });
        }
        if ((panicking = this.entity.method_18868().method_18906(class_4168.field_18599)) != (Boolean)((CTrackedEntity)this.entity).getTrackedValue(PANICKING)) {
            ((CTrackedEntity)this.entity).setTrackedValue(PANICKING, panicking);
        }
        if (((class_1308)this.entity).field_6012 % 20 != 0) {
            this.updateMoveState();
        }
        if (((class_1308)this.entity).field_6012 % Math.max(1, Config.getInstance().interactionFatigueCooldown) == 0 && (nbt = (class_2487)((CTrackedEntity)this.entity).getTrackedValue(MEMORIES)) != null) {
            for (String uuid : nbt.method_10541()) {
                Memories memories = Memories.fromCNBT(this.entity, nbt.method_10562(uuid));
                int fatigue = memories.getInteractionFatigue();
                if (fatigue <= 0) continue;
                memories.setInteractionFatigue(fatigue - 1);
            }
        }
    }

    public Chore getCurrentJob() {
        return (Chore)((Object)((CTrackedEntity)this.entity).getTrackedValue(ACTIVE_CHORE));
    }

    public Optional<class_1657> getJobAssigner() {
        return ((Optional)((CTrackedEntity)this.entity).getTrackedValue(CHORE_ASSIGNING_PLAYER)).map(id -> ((class_1308)this.entity).field_6002.method_18470(id));
    }

    public void abandonJob() {
        this.entity.method_18868().method_24526(class_4168.field_18595);
        ((CTrackedEntity)this.entity).setTrackedValue(ACTIVE_CHORE, Chore.NONE);
        ((CTrackedEntity)this.entity).setTrackedValue(CHORE_ASSIGNING_PLAYER, Optional.empty());
        this.resetsBrain();
    }

    public void assignJob(Chore chore, class_1657 player) {
        this.entity.method_18868().method_24526((class_4168)ActivityMCA.CHORE.get());
        ((CTrackedEntity)this.entity).setTrackedValue(ACTIVE_CHORE, chore);
        ((CTrackedEntity)this.entity).setTrackedValue(CHORE_ASSIGNING_PLAYER, Optional.of(player.method_5667()));
        this.entity.method_18868().method_18875((class_4140)MemoryModuleTypeMCA.PLAYER_FOLLOWING.get());
        this.entity.method_18868().method_18875((class_4140)MemoryModuleTypeMCA.STAYING.get());
        this.resetsBrain();
    }

    public void randomize() {
        ((CTrackedEntity)this.entity).setTrackedValue(PERSONALITY, Personality.getRandom());
        ((CTrackedEntity)this.entity).setTrackedValue(MOOD, ((class_1308)this.entity).field_6002.field_9229.method_43048(31) + -15);
    }

    public void setPersonality(Personality p) {
        ((CTrackedEntity)this.entity).setTrackedValue(PERSONALITY, p);
    }

    public void updateMemories(Memories memories) {
        class_2487 nbt = (class_2487)((CTrackedEntity)this.entity).getTrackedValue(MEMORIES);
        nbt = nbt == null ? new class_2487() : nbt.method_10553();
        nbt.method_10566(memories.getPlayerUUID().toString(), (class_2520)memories.toCNBT());
        ((CTrackedEntity)this.entity).setTrackedValue(MEMORIES, nbt);
    }

    public Map<UUID, Memories> getMemories() {
        class_2487 nbt = (class_2487)((CTrackedEntity)this.entity).getTrackedValue(MEMORIES);
        HashMap<UUID, Memories> memories = new HashMap<UUID, Memories>();
        for (String uuid : nbt.method_10541()) {
            memories.put(UUID.fromString(uuid), Memories.fromCNBT(this.entity, nbt.method_10562(uuid)));
        }
        return memories;
    }

    public Memories getMemoriesForPlayer(class_1657 player) {
        class_2487 nbt = (class_2487)((CTrackedEntity)this.entity).getTrackedValue(MEMORIES);
        nbt = nbt == null ? new class_2487() : nbt;
        class_2487 compoundTag = nbt.method_10562(player.method_5667().toString());
        Memories returnMemories = Memories.fromCNBT(this.entity, compoundTag);
        if (returnMemories == null) {
            returnMemories = new Memories(this, player.field_6002.method_8532(), player.method_5667());
            nbt.method_10566(player.method_5667().toString(), (class_2520)returnMemories.toCNBT());
            ((CTrackedEntity)this.entity).setTrackedValue(MEMORIES, nbt);
        }
        return returnMemories;
    }

    public Personality getPersonality() {
        return (Personality)((Object)((CTrackedEntity)this.entity).getTrackedValue(PERSONALITY));
    }

    public Mood getMood() {
        return this.getPersonality().getMoodGroup().getMood((Integer)((CTrackedEntity)this.entity).getTrackedValue(MOOD));
    }

    public boolean isPanicking() {
        return (Boolean)((CTrackedEntity)this.entity).getTrackedValue(PANICKING);
    }

    public void modifyMoodValue(int mood) {
        ((CTrackedEntity)this.entity).setTrackedValue(MOOD, MoodGroup.clampMood(this.getMoodValue() + mood));
    }

    public int getMoodValue() {
        return (Integer)((CTrackedEntity)this.entity).getTrackedValue(MOOD);
    }

    public MoveState getMoveState() {
        return (MoveState)((Object)((CTrackedEntity)this.entity).getTrackedValue(MOVE_STATE));
    }

    public void setMoveState(MoveState state, @Nullable class_1657 leader) {
        ((CTrackedEntity)this.entity).setTrackedValue(MOVE_STATE, state);
        if (state == MoveState.MOVE) {
            this.entity.method_18868().method_18875((class_4140)MemoryModuleTypeMCA.PLAYER_FOLLOWING.get());
            this.entity.method_18868().method_18875((class_4140)MemoryModuleTypeMCA.STAYING.get());
        }
        if (state == MoveState.STAY) {
            this.entity.method_18868().method_18875((class_4140)MemoryModuleTypeMCA.PLAYER_FOLLOWING.get());
            this.entity.method_18868().method_18878((class_4140)MemoryModuleTypeMCA.STAYING.get(), (Object)true);
        }
        if (state == MoveState.FOLLOW) {
            this.entity.method_18868().method_18878((class_4140)MemoryModuleTypeMCA.PLAYER_FOLLOWING.get(), (Object)leader);
            this.entity.method_18868().method_18875((class_4140)MemoryModuleTypeMCA.STAYING.get());
            this.abandonJob();
        }
        this.resetsBrain();
    }

    private void resetsBrain() {
        class_1308 class_13082 = ((EntityWrapper)this.entity).asEntity();
        if (class_13082 instanceof VillagerEntityMCA) {
            VillagerEntityMCA villager = (VillagerEntityMCA)class_13082;
            villager.method_19179((class_3218)villager.method_37908());
        }
    }

    public void setArmorWear(boolean s) {
        ((CTrackedEntity)this.entity).setTrackedValue(WEAR_ARMOR, s);
    }

    public boolean getArmorWear() {
        return (Boolean)((CTrackedEntity)this.entity).getTrackedValue(WEAR_ARMOR);
    }

    public void updateMoveState() {
        if (this.getMoveState() == MoveState.FOLLOW && this.entity.method_18868().method_18904((class_4140)MemoryModuleTypeMCA.PLAYER_FOLLOWING.get()).isEmpty()) {
            if (this.entity.method_18868().method_18904((class_4140)MemoryModuleTypeMCA.STAYING.get()).isPresent()) {
                ((CTrackedEntity)this.entity).setTrackedValue(MOVE_STATE, MoveState.STAY);
            } else if (this.entity.method_18868().method_18904((class_4140)MemoryModuleTypeMCA.PLAYER_FOLLOWING.get()).isPresent()) {
                ((CTrackedEntity)this.entity).setTrackedValue(MOVE_STATE, MoveState.FOLLOW);
            } else {
                ((CTrackedEntity)this.entity).setTrackedValue(MOVE_STATE, MoveState.MOVE);
            }
        }
    }

    public void rewardHearts(class_3222 player, int hearts) {
        Memories memory = ((VillagerLike)this.entity).getVillagerBrain().getMemoriesForPlayer((class_1657)player);
        if (hearts == 0) {
            return;
        }
        if (hearts > 0) {
            ((class_1308)this.entity).field_6002.method_8421(this.entity, (byte)16);
        } else {
            ((class_1308)this.entity).field_6002.method_8421(this.entity, (byte)15);
            if (((VillagerLike)this.entity).getVillagerBrain().getPersonality() == Personality.SENSITIVE) {
                hearts *= 2;
            }
        }
        memory.modInteractionFatigue(1);
        memory.modHearts(hearts);
        CriterionMCA.HEARTS_CRITERION.trigger(player, memory.getHearts(), hearts, "interaction");
        ((VillagerLike)this.entity).getVillagerBrain().modifyMoodValue(hearts);
    }
}

