/*
 * Decompiled with CFR 0.152.
 */
package quilt.net.mca.entity.ai;

import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_5819;
import quilt.net.mca.Config;
import quilt.net.mca.advancement.criterion.CriterionMCA;
import quilt.net.mca.entity.VillagerEntityMCA;
import quilt.net.mca.entity.ai.relationship.AgeState;
import quilt.net.mca.entity.ai.relationship.Gender;
import quilt.net.mca.server.world.data.BabyTracker;
import quilt.net.mca.util.WorldUtils;
import quilt.net.mca.util.network.datasync.CDataManager;
import quilt.net.mca.util.network.datasync.CDataParameter;
import quilt.net.mca.util.network.datasync.CParameter;

public class Pregnancy {
    private static final CDataParameter<Boolean> HAS_BABY = CParameter.create("hasBaby", false);
    private static final CDataParameter<Boolean> IS_BABY_MALE = CParameter.create("isBabyMale", false);
    private static final CDataParameter<Integer> BABY_AGE = CParameter.create("babyAge", 0);
    private final VillagerEntityMCA mother;

    public static <E extends class_1297> CDataManager.Builder<E> createTrackedData(CDataManager.Builder<E> builder) {
        return builder.addAll(HAS_BABY, IS_BABY_MALE, BABY_AGE);
    }

    Pregnancy(VillagerEntityMCA entity) {
        this.mother = entity;
    }

    public boolean isPregnant() {
        return (Boolean)this.mother.getTrackedValue(HAS_BABY);
    }

    public void setPregnant(boolean pregnant) {
        this.mother.setTrackedValue(HAS_BABY, pregnant);
    }

    public int getBabyAge() {
        return (Integer)this.mother.getTrackedValue(BABY_AGE);
    }

    public void setBabyAge(int age) {
        this.mother.setTrackedValue(BABY_AGE, age);
    }

    public Gender getGender() {
        return (Boolean)this.mother.getTrackedValue(IS_BABY_MALE) != false ? Gender.MALE : Gender.FEMALE;
    }

    public void tick() {
        if (!this.isPregnant()) {
            return;
        }
        this.setBabyAge(this.getBabyAge() + 60);
        if (this.getBabyAge() < Config.getInstance().babyItemGrowUpTime) {
            return;
        }
        this.setBabyAge(0);
        this.getFather().ifPresent(father -> {
            this.setPregnant(false);
            VillagerEntityMCA child = this.createChild(this.getGender(), (VillagerEntityMCA)father);
            child.method_5814(this.mother.method_23317(), this.mother.method_23318(), this.mother.method_23321());
            WorldUtils.spawnEntity(this.mother.field_6002, (class_1308)child, class_3730.field_16466);
        });
    }

    public boolean tryStartGestation() {
        if (this.isPregnant()) {
            return false;
        }
        return this.getFather().map(father -> {
            if (this.mother.getGenetics().getGender() == Gender.MALE && father.getGenetics().getGender() != Gender.MALE) {
                return father.getRelationships().getPregnancy().tryStartGestation();
            }
            this.setPregnant(true);
            this.mother.setTrackedValue(IS_BABY_MALE, this.mother.field_6002.field_9229.method_43056());
            return true;
        }).orElse(false);
    }

    public VillagerEntityMCA createChild(Gender gender, VillagerEntityMCA partner) {
        VillagerEntityMCA child = (VillagerEntityMCA)gender.getVillagerType().method_5883(this.mother.field_6002);
        child.getGenetics().combine(partner.getGenetics(), this.mother.getGenetics());
        child.getTraits().inherit(partner.getTraits());
        child.getTraits().inherit(this.mother.getTraits());
        child.method_7217(true);
        child.setAgeState(AgeState.TODDLER);
        child.getRelationships().getFamilyEntry().assignParents(this.mother.getRelationships(), partner.getRelationships());
        child.getRelationships().getFamily(2, 0).filter(e -> e instanceof class_3222).map(class_3222.class::cast).forEach(CriterionMCA.FAMILY::trigger);
        return child;
    }

    public VillagerEntityMCA createChild(Gender gender) {
        return this.createChild(gender, this.mother);
    }

    private Optional<VillagerEntityMCA> getFather() {
        return this.mother.getRelationships().getPartner().filter(father -> father instanceof VillagerEntityMCA).map(VillagerEntityMCA.class::cast);
    }

    public void procreate(class_1297 spouse) {
        int count;
        class_5819 random = this.mother.method_6051();
        boolean areTwins = random.method_43048(100) < Config.getInstance().chanceToHaveTwins;
        int n = count = areTwins ? 2 : 1;
        if (spouse instanceof class_3222) {
            CriterionMCA.BABY_CRITERION.trigger((class_3222)spouse, count);
        }
        long seed = random.method_43055();
        for (int i = 0; i < count; ++i) {
            BabyTracker.get((class_3218)this.mother.field_6002).getPairing(this.mother.method_5667(), spouse.method_5667()).addChild(state -> {
                class_1657 player;
                class_1799 stack = state.setGender(Gender.getRandom()).setOwner((class_1297)this.mother).setSeed(seed).createItem();
                if (!(spouse instanceof class_1657) || !(player = (class_1657)spouse).method_7270(stack)) {
                    this.mother.method_35199().method_5491(stack);
                }
            });
        }
    }
}

