/*
 * Decompiled with CFR 0.152.
 */
package quilt.net.mca.entity.ai;

import java.util.Arrays;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2398;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import quilt.net.mca.SoundsMCA;
import quilt.net.mca.entity.ai.Mood;
import quilt.net.mca.entity.ai.MoodBuilder;

public enum MoodGroup {
    UNASSIGNED(new MoodBuilder("passive").build()),
    GENERAL(new MoodBuilder("depressed").sounds(2, (class_3414)SoundsMCA.VILLAGER_MALE_CRY.get(), (class_3414)SoundsMCA.VILLAGER_FEMALE_CRY.get()).particles(20, class_2398.field_11202).building("inn").color(class_124.field_1061).build(), new MoodBuilder("sad").sounds(8, (class_3414)SoundsMCA.VILLAGER_MALE_CRY.get(), (class_3414)SoundsMCA.VILLAGER_FEMALE_CRY.get()).particles(50, class_2398.field_11202).building("inn").color(class_124.field_1065).build(), new MoodBuilder("unhappy").build(), new MoodBuilder("passive").build(), new MoodBuilder("fine").build(), new MoodBuilder("happy").color(class_124.field_1077).build(), new MoodBuilder("overjoyed").sounds(8, (class_3414)SoundsMCA.VILLAGER_MALE_LAUGH.get(), (class_3414)SoundsMCA.VILLAGER_FEMALE_LAUGH.get()).particles(50, class_2398.field_11211).color(class_124.field_1060).build()),
    PLAYFUL(new MoodBuilder("bored_to_tears").color(class_124.field_1061).build(), new MoodBuilder("bored").color(class_124.field_1065).build(), new MoodBuilder("uninterested").build(), new MoodBuilder("passive").build(), new MoodBuilder("silly").build(), new MoodBuilder("giggly").sounds(8, (class_3414)SoundsMCA.VILLAGER_MALE_LAUGH.get(), (class_3414)SoundsMCA.VILLAGER_FEMALE_LAUGH.get()).particles(50, class_2398.field_11211).building("inn").color(class_124.field_1077).build(), new MoodBuilder("entertained").sounds(2, (class_3414)SoundsMCA.VILLAGER_MALE_LAUGH.get(), (class_3414)SoundsMCA.VILLAGER_FEMALE_LAUGH.get()).particles(20, class_2398.field_11211).building("inn").color(class_124.field_1060).build()),
    SERIOUS(new MoodBuilder("infuriated").sounds(2, (class_3414)SoundsMCA.VILLAGER_MALE_ANGRY.get(), (class_3414)SoundsMCA.VILLAGER_FEMALE_ANGRY.get()).particles(20, class_2398.field_11231).color(class_124.field_1061).build(), new MoodBuilder("angry").sounds(8, (class_3414)SoundsMCA.VILLAGER_MALE_ANGRY.get(), (class_3414)SoundsMCA.VILLAGER_FEMALE_ANGRY.get()).particles(50, class_2398.field_11231).color(class_124.field_1065).build(), new MoodBuilder("annoyed").build(), new MoodBuilder("passive").build(), new MoodBuilder("interested").build(), new MoodBuilder("talkative").building("inn").color(class_124.field_1077).build(), new MoodBuilder("pleased").color(class_124.field_1060).build());

    public static final int normalMinLevel = -15;
    public static final int absoluteMinLevel = -100;
    public static final int maxLevel = 15;
    private final List<Mood> moods;

    private MoodGroup(Mood ... m) {
        this.moods = Arrays.asList(m);
    }

    public static int clampMood(int moodPoints) {
        return class_3532.method_15340((int)moodPoints, (int)-100, (int)15);
    }

    private int getLevel(int moodPoints) {
        return class_3532.method_15340((int)((moodPoints - -15) * this.moods.size() / 30), (int)0, (int)(this.moods.size() - 1));
    }

    public Mood getMood(int moodPoints) {
        int level = this.getLevel(moodPoints);
        return this.moods.get(level);
    }
}

