/*
 * Decompiled with CFR 0.152.
 */
package quilt.net.mca.client.render.layer;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1309;
import net.minecraft.class_151;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_572;
import net.minecraft.class_922;
import org.jetbrains.annotations.Nullable;
import quilt.net.mca.MCA;
import quilt.net.mca.MCAClient;
import quilt.net.mca.client.model.CommonVillagerModel;

public abstract class VillagerLayer<T extends class_1309, M extends class_572<T>>
extends class_3887<T, M> {
    private static final float[] DEFAULT_COLOR = new float[]{1.0f, 1.0f, 1.0f};
    private static final Map<String, class_2960> TEXTURE_CACHE = Maps.newHashMap();
    public final M model;

    public VillagerLayer(class_3883<T, M> renderer, M model) {
        super(renderer);
        this.model = model;
    }

    @Nullable
    protected class_2960 getSkin(T villager) {
        return null;
    }

    @Nullable
    protected class_2960 getOverlay(T villager) {
        return null;
    }

    protected float[] getColor(T villager, float tickDelta) {
        return DEFAULT_COLOR;
    }

    protected boolean isTranslucent() {
        return false;
    }

    public void render(class_4587 transform, class_4597 provider, int light, T villager, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        if (villager.method_5767()) {
            return;
        }
        if (CommonVillagerModel.getVillager(villager).hasCustomSkin()) {
            return;
        }
        if (villager instanceof class_1657 && !MCAClient.useVillagerRenderer(villager.method_5667())) {
            return;
        }
        ((class_572)this.method_17165()).method_2818(this.model);
        this.renderFinal(transform, provider, light, villager, tickDelta);
    }

    public void renderFinal(class_4587 transform, class_4597 provider, int light, T villager, float tickDelta) {
        class_2960 overlay;
        int tint = class_922.method_23622(villager, (float)0.0f);
        class_2960 skin = this.getSkin(villager);
        if (this.canUse(skin)) {
            float[] color = this.getColor(villager, tickDelta);
            this.renderModel(transform, provider, light, this.model, color[0], color[1], color[2], skin, tint);
        }
        if (this.canUse(overlay = this.getOverlay(villager))) {
            this.renderModel(transform, provider, light, this.model, 1.0f, 1.0f, 1.0f, overlay, tint);
        }
    }

    private void renderModel(class_4587 transform, class_4597 provider, int light, M model, float r, float g, float b, class_2960 texture, int overlay) {
        class_4588 buffer = provider.getBuffer(this.isTranslucent() ? class_1921.method_23580((class_2960)texture) : class_1921.method_23578((class_2960)texture));
        model.method_2828(transform, buffer, light, overlay, r, g, b, 1.0f);
    }

    protected final boolean canUse(class_2960 texture) {
        return texture != null && class_310.method_1551().method_1478().method_14486(texture).isPresent();
    }

    @Nullable
    protected final class_2960 cached(String name, Function<String, class_2960> supplier) {
        if (MCA.isBlankString(name)) {
            return null;
        }
        return TEXTURE_CACHE.computeIfAbsent(name, s -> {
            try {
                return (class_2960)supplier.apply((String)s);
            }
            catch (class_151 ignored) {
                return null;
            }
        });
    }
}

