/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.server.world.data;

import forge.net.mca.Config;
import forge.net.mca.ProfessionsMCA;
import forge.net.mca.entity.EquipmentSet;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.Memories;
import forge.net.mca.entity.ai.relationship.Gender;
import forge.net.mca.entity.ai.relationship.family.FamilyTree;
import forge.net.mca.resources.API;
import forge.net.mca.resources.PoolUtil;
import forge.net.mca.resources.Rank;
import forge.net.mca.resources.Tasks;
import forge.net.mca.server.world.data.Building;
import forge.net.mca.server.world.data.PlayerSaveData;
import forge.net.mca.server.world.data.VillageManager;
import forge.net.mca.util.BlockBoxExtended;
import forge.net.mca.util.NbtHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class Village
implements Iterable<Building> {
    private static final int MOVE_IN_COOLDOWN = 1200;
    private static final int MAX_STORAGE_SIZE = 1024;
    public static final int BORDER_MARGIN = 32;
    public static final int MERGE_MARGIN = 64;
    private String name = API.getVillagePool().pickVillageName("village");
    public final List<ItemStack> storageBuffer = new LinkedList<ItemStack>();
    private final Map<Integer, Building> buildings = new HashMap<Integer, Building>();
    private Map<UUID, Integer> unspentHearts = new HashMap<UUID, Integer>();
    private Map<UUID, Map<UUID, Integer>> reputation = new HashMap<UUID, Map<UUID, Integer>>();
    private int unspentMood = 0;
    public long lastMoveIn;
    private int id;
    private int taxes = 0;
    private int populationThreshold = 75;
    private int marriageThreshold = 50;
    private boolean autoScan = true;
    private BlockBoxExtended box = new BlockBoxExtended(0, 0, 0, 0, 0, 0);

    public Village() {
    }

    public Village(int id) {
        this.id = id;
    }

    public static Optional<Village> findNearest(Entity entity) {
        return VillageManager.get((ServerLevel)entity.f_19853_).findNearestVillage(entity);
    }

    public boolean isWithinBorder(Entity entity) {
        return this.isWithinBorder(entity.m_20183_());
    }

    public boolean isWithinBorder(BlockPos pos) {
        return this.isWithinBorder(pos, 32);
    }

    public boolean isWithinBorder(BlockPos pos, int margin) {
        return this.box.m_191961_(margin).m_71051_((Vec3i)pos);
    }

    @Override
    public Iterator<Building> iterator() {
        return this.buildings.values().iterator();
    }

    public void removeBuilding(int id) {
        this.buildings.remove(id);
        if (!this.buildings.isEmpty()) {
            this.calculateDimensions();
        }
    }

    public Stream<Building> getBuildingsOfType(String type) {
        return this.getBuildings().values().stream().filter(b -> b.getType().equals(type));
    }

    public Optional<Building> getBuildingAt(Vec3i pos) {
        return this.getBuildings().values().stream().filter(b -> b.containsPos(pos)).findAny();
    }

    public void calculateDimensions() {
        int sx = Integer.MAX_VALUE;
        int sy = Integer.MAX_VALUE;
        int sz = Integer.MAX_VALUE;
        int ex = Integer.MIN_VALUE;
        int ey = Integer.MIN_VALUE;
        int ez = Integer.MIN_VALUE;
        for (Building building : this.buildings.values()) {
            ex = Math.max(building.getPos1().m_123341_(), ex);
            sx = Math.min(building.getPos0().m_123341_(), sx);
            ey = Math.max(building.getPos1().m_123342_(), ey);
            sy = Math.min(building.getPos0().m_123342_(), sy);
            ez = Math.max(building.getPos1().m_123343_(), ez);
            sz = Math.min(building.getPos0().m_123343_(), sz);
        }
        this.box = new BlockBoxExtended(sx, sy, sz, ex, ey, ez);
    }

    public Vec3i getCenter() {
        return this.box.m_162394_();
    }

    public BlockBoxExtended getBox() {
        return this.box;
    }

    public int getTaxes() {
        return this.taxes;
    }

    public void setTaxes(int taxes) {
        this.taxes = taxes;
    }

    public int getPopulationThreshold() {
        return this.populationThreshold;
    }

    public void setPopulationThreshold(int populationThreshold) {
        this.populationThreshold = populationThreshold;
    }

    public int getMarriageThreshold() {
        return this.marriageThreshold;
    }

    public void setMarriageThreshold(int marriageThreshold) {
        this.marriageThreshold = marriageThreshold;
    }

    public boolean isAutoScan() {
        return this.autoScan;
    }

    public void setAutoScan(boolean autoScan) {
        this.autoScan = autoScan;
    }

    public void toggleAutoScan() {
        this.setAutoScan(!this.isAutoScan());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<Integer, Building> getBuildings() {
        return this.buildings;
    }

    public Optional<Building> getBuilding(int id) {
        return Optional.ofNullable(this.buildings.get(id));
    }

    public int getId() {
        return this.id;
    }

    public boolean hasSpace() {
        return this.getPopulation() < this.getMaxPopulation();
    }

    public int getPopulation() {
        int residents = 0;
        for (Building b : this) {
            residents += b.getResidents().size();
        }
        return residents;
    }

    public Stream<UUID> getResidentsUUIDs() {
        return this.getBuildings().values().stream().flatMap(building -> building.getResidents().keySet().stream());
    }

    public List<VillagerEntityMCA> getResidents(ServerLevel world) {
        return this.getResidentsUUIDs().map(arg_0 -> ((ServerLevel)world).m_8791_(arg_0)).filter(v -> v instanceof VillagerEntityMCA).map(VillagerEntityMCA.class::cast).collect(Collectors.toList());
    }

    public int getMaxPopulation() {
        int residents = 0;
        for (Building b : this) {
            residents += b.getBedCount();
        }
        return residents;
    }

    public boolean hasStoredResource() {
        return this.storageBuffer.size() > 0;
    }

    public boolean hasBuilding(String building) {
        return this.buildings.values().stream().anyMatch(b -> b.getType().equals(building));
    }

    public void tick(ServerLevel world, long time) {
        boolean isVillageUpdateTime;
        boolean isTaxSeason = time % (long)Config.getInstance().taxSeason == 0L;
        boolean bl = isVillageUpdateTime = time % 1200L == 0L;
        if (isTaxSeason && this.hasBuilding("storage")) {
            MutableComponent msg;
            int emeraldValue = 100;
            int taxes = (int)(Config.getInstance().taxesFactor * (float)this.getPopulation() * (float)this.getTaxes() + (float)world.f_46441_.m_188503_(emeraldValue));
            int moodImpact = 0;
            float r = Mth.m_14179_((float)0.5f, (float)((float)this.getTaxes() / 100.0f), (float)world.f_46441_.m_188501_());
            if ((float)this.getTaxes() == 0.0f) {
                msg = Component.m_237110_((String)"gui.village.taxes.no", (Object[])new Object[]{this.getName()}).m_130940_(ChatFormatting.GREEN);
                moodImpact = 5;
            } else if ((double)r < 0.1) {
                msg = Component.m_237110_((String)"gui.village.taxes.more", (Object[])new Object[]{this.getName()}).m_130940_(ChatFormatting.GREEN);
                taxes = (int)((double)taxes + (double)this.getPopulation() * 0.25);
            } else if ((double)r < 0.3) {
                msg = Component.m_237110_((String)"gui.village.taxes.happy", (Object[])new Object[]{this.getName()}).m_130940_(ChatFormatting.DARK_GREEN);
                moodImpact = 5;
            } else if ((double)r < 0.7) {
                msg = Component.m_237110_((String)"gui.village.taxes", (Object[])new Object[]{this.getName()});
            } else if ((double)r < 0.8) {
                msg = Component.m_237110_((String)"gui.village.taxes.sad", (Object[])new Object[]{this.getName()}).m_130940_(ChatFormatting.GOLD);
                moodImpact = -5;
            } else if ((double)r < 0.9) {
                msg = Component.m_237110_((String)"gui.village.taxes.angry", (Object[])new Object[]{this.getName()}).m_130940_(ChatFormatting.RED);
                moodImpact = -10;
            } else {
                msg = Component.m_237110_((String)"gui.village.taxes.riot", (Object[])new Object[]{this.getName()}).m_130940_(ChatFormatting.DARK_RED);
                taxes = 0;
            }
            world.m_6907_().stream().filter(v -> Tasks.getRank(this, v).isAtLeast(Rank.MERCHANT)).forEach(arg_0 -> Village.lambda$tick$6((Component)msg, arg_0));
            if (this.hasBuilding("library")) {
                taxes = (int)((double)taxes * 1.5);
            }
            for (int emeraldCount = taxes / emeraldValue; emeraldCount > 0 && this.storageBuffer.size() < 1024; emeraldCount -= Items.f_42616_.m_41459_()) {
                this.storageBuffer.add(new ItemStack((ItemLike)Items.f_42616_, Math.min(emeraldCount, Items.f_42616_.m_41459_())));
            }
            if (moodImpact != 0) {
                this.pushMood(world, moodImpact * this.getPopulation());
            }
            this.deliverTaxes(world);
        }
        if (time % 24000L == 0L) {
            this.cleanReputation();
        }
        if (isVillageUpdateTime && this.lastMoveIn + 1200L < time) {
            this.spawnGuards(world);
            this.procreate(world);
            this.marry(world);
            this.inn(world);
        }
    }

    public void deliverTaxes(ServerLevel world) {
        if (this.hasStoredResource()) {
            this.getBuildingsOfType("storage").forEach(building -> building.getBlocks().values().stream().flatMap(Collection::stream).forEach(p -> {
                if (this.hasStoredResource()) {
                    this.tryToPutIntoInventory(world, (BlockPos)p);
                }
            }));
        }
    }

    private void tryToPutIntoInventory(ServerLevel world, BlockPos p) {
        BlockEntity blockEntity;
        BlockState state = world.m_8055_(p);
        if (state.m_155947_() && (blockEntity = world.m_7702_(p)) instanceof Container) {
            ChestBlock chest;
            Container inventory = (Container)blockEntity;
            Block block = state.m_60734_();
            if (inventory instanceof ChestBlockEntity && block instanceof ChestBlock && (inventory = ChestBlock.m_51511_((ChestBlock)(chest = (ChestBlock)block), (BlockState)state, (Level)world, (BlockPos)p, (boolean)true)) != null) {
                this.putIntoInventory(inventory);
            }
        }
    }

    private void putIntoInventory(Container inventory) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            boolean changes = true;
            while (changes) {
                changes = false;
                ItemStack stack = inventory.m_8020_(i);
                ItemStack tax = this.storageBuffer.get(0);
                if (stack.m_41720_() == tax.m_41720_()) {
                    int diff = Math.min(tax.m_41613_(), stack.m_41741_() - stack.m_41613_());
                    if (diff > 0) {
                        stack.m_41769_(diff);
                        tax.m_41774_(diff);
                        if (tax.m_41619_()) {
                            this.storageBuffer.remove(0);
                            changes = true;
                        }
                        inventory.m_6596_();
                    }
                } else if (stack.m_41619_()) {
                    inventory.m_6836_(i, tax);
                    inventory.m_6596_();
                    this.storageBuffer.remove(0);
                    changes = true;
                }
                if (this.hasStoredResource()) continue;
                return;
            }
        }
    }

    private void spawnGuards(ServerLevel world) {
        int guardCapacity = this.getPopulation() / Config.getInstance().guardSpawnRate;
        int guards = 0;
        int citizen = 0;
        List<VillagerEntityMCA> villagers = this.getResidents(world);
        LinkedList<VillagerEntityMCA> nonGuards = new LinkedList<VillagerEntityMCA>();
        for (VillagerEntityMCA villager : villagers) {
            if (villager.isGuard()) {
                ++guards;
                continue;
            }
            if (!villager.m_6162_() && !villager.isProfessionImportant() && villager.m_7809_() == 0 && villager.m_7141_().m_35576_() <= 1) {
                nonGuards.add(villager);
            }
            ++citizen;
        }
        guards = (int)((double)guards + Math.ceil((float)(this.getPopulation() - guards - citizen) / (float)Config.getInstance().guardSpawnRate));
        if (nonGuards.size() > 0 && guards < guardCapacity) {
            VillagerEntityMCA villager = (VillagerEntityMCA)nonGuards.get(world.f_46441_.m_188503_(nonGuards.size()));
            villager.setProfession(guards % 2 == 0 ? (VillagerProfession)ProfessionsMCA.GUARD.get() : (VillagerProfession)ProfessionsMCA.ARCHER.get());
        }
    }

    public void procreate(ServerLevel world) {
        int maxPopulation;
        if (world.f_46441_.m_188501_() >= (float)Config.getInstance().childrenChance / 100.0f) {
            return;
        }
        int population = this.getPopulation();
        if ((float)population >= (float)((maxPopulation = this.getMaxPopulation()) * this.getPopulationThreshold()) / 100.0f) {
            return;
        }
        PoolUtil.pick(this.getResidents(world), world.f_46441_).filter(villager -> villager.getGenetics().getGender() == Gender.FEMALE).filter(villager -> (double)world.f_46441_.m_188501_() < 1.0 / ((double)FamilyTree.get(world).getOrCreate((Entity)villager).getChildren().count() + 0.1)).filter(villager -> villager.getRelationships().getPregnancy().tryStartGestation()).ifPresent(villager -> villager.getRelationships().getPartner().ifPresent(spouse -> {
            if (Config.getInstance().villagerBirthNotification && spouse instanceof VillagerEntityMCA) {
                VillagerEntityMCA spouseVillager = (VillagerEntityMCA)spouse;
                this.broadCastMessage(world, "events.baby", (VillagerEntityMCA)villager, spouseVillager);
            }
        }));
    }

    public void marry(ServerLevel world) {
        if (world.f_46441_.m_188501_() >= (float)Config.getInstance().marriageChance / 100.0f) {
            return;
        }
        List<VillagerEntityMCA> allVillagers = this.getResidents(world);
        List availableVillagers = allVillagers.stream().filter(v -> !v.m_6162_()).filter(v -> !v.getRelationships().isMarried()).filter(v -> !v.getRelationships().isEngaged()).filter(v -> !v.getRelationships().isPromised()).collect(Collectors.toList());
        if (availableVillagers.size() <= 1 || (float)availableVillagers.size() < (float)(allVillagers.size() * this.getMarriageThreshold()) / 100.0f) {
            return;
        }
        availableVillagers.sort(Comparator.comparingInt(a -> a.getVillagerBrain().getMemories().values().stream().map(Memories::getHearts).max(Integer::compare).orElse(0)));
        VillagerEntityMCA suitor = (VillagerEntityMCA)availableVillagers.remove(0);
        availableVillagers.stream().filter(suitor::canBeAttractedTo).filter(i -> !suitor.getRelationships().getFamilyEntry().isRelative(i.m_20148_())).findFirst().ifPresent(mate -> {
            suitor.getRelationships().marry((Entity)mate);
            mate.getRelationships().marry((Entity)suitor);
            if (Config.getInstance().villagerMarriageNotification) {
                this.broadCastMessage(world, "events.marry", suitor, (VillagerEntityMCA)mate);
            }
        });
    }

    private void inn(ServerLevel world) {
        this.getBuildingsOfType("inn").forEach(b -> {
            block1: {
                BlockPos p;
                if (!(world.f_46441_.m_188501_() < (float)Config.getInstance().adventurerAtInnChance / 100.0f)) break block1;
                ArrayList values = new ArrayList(b.getBlocks().values().stream().flatMap(Collection::stream).toList());
                Collections.shuffle(values);
                Iterator iterator = values.iterator();
                while (iterator.hasNext() && !this.trySpawnAdventurer(world, (p = (BlockPos)iterator.next()).m_7494_())) {
                }
            }
        });
    }

    private boolean doesNotSuffocateAt(BlockGetter world, BlockPos pos) {
        for (BlockPos blockPos : BlockPos.m_121940_((BlockPos)pos, (BlockPos)pos.m_7494_())) {
            if (world.m_8055_(blockPos).m_60812_(world, blockPos).m_83281_()) continue;
            return false;
        }
        return true;
    }

    private boolean trySpawnAdventurer(ServerLevel world, BlockPos blockPos) {
        if (!world.m_7232_(SectionPos.m_123171_((int)blockPos.m_123341_()), SectionPos.m_123171_((int)blockPos.m_123343_()))) {
            return true;
        }
        String name = null;
        if (this.doesNotSuffocateAt((BlockGetter)world, blockPos)) {
            VillagerEntityMCA adventurer;
            int i = world.f_46441_.m_188503_(10);
            if (i == 0 && Config.getInstance().innSpawnsWanderingTraders) {
                WanderingTrader trader = (WanderingTrader)EntityType.f_20494_.m_20600_(world, null, null, null, blockPos, MobSpawnType.EVENT, false, false);
                if (trader != null) {
                    name = trader.m_7755_().getString();
                    trader.m_35891_(48000);
                }
            } else if (i == 1 && Config.getInstance().innSpawnsCultists) {
                VillagerEntityMCA adventurer2 = (VillagerEntityMCA)Gender.getRandom().getVillagerType().m_20600_(world, null, null, null, blockPos, MobSpawnType.EVENT, false, false);
                if (adventurer2 != null) {
                    name = adventurer2.m_7755_().getString();
                    adventurer2.setProfession((VillagerProfession)ProfessionsMCA.CULTIST.get());
                    adventurer2.setDespawnDelay(48000);
                }
            } else if (Config.getInstance().innSpawnsAdventurers && (adventurer = (VillagerEntityMCA)Gender.getRandom().getVillagerType().m_20600_(world, null, null, null, blockPos, MobSpawnType.EVENT, false, false)) != null) {
                name = adventurer.m_7755_().getString();
                adventurer.setProfession((VillagerProfession)ProfessionsMCA.ADVENTURER.get());
                adventurer.setDespawnDelay(48000);
            }
            if (name != null) {
                if (Config.getInstance().innArrivalNotification) {
                    this.broadCastMessage(world, "events.arrival.inn", name);
                }
                return true;
            }
        }
        return false;
    }

    public void broadCastMessage(ServerLevel world, String event, VillagerEntityMCA suitor, VillagerEntityMCA mate) {
        world.m_6907_().stream().filter(p -> PlayerSaveData.get(p).getLastSeenVillageId().orElse(-2).intValue() == this.getId() || suitor.getVillagerBrain().getMemoriesForPlayer((Player)p).getHearts() > Config.getInstance().heartsToBeConsideredAsFriend || mate.getVillagerBrain().getMemoriesForPlayer((Player)p).getHearts() > Config.getInstance().heartsToBeConsideredAsFriend).forEach(player -> player.m_5661_((Component)Component.m_237110_((String)event, (Object[])new Object[]{suitor.m_7755_(), mate.m_7755_()}), !Config.getInstance().showNotificationsAsChat));
    }

    public void broadCastMessage(ServerLevel world, String event, VillagerEntityMCA target) {
        world.m_6907_().stream().filter(p -> PlayerSaveData.get(p).getLastSeenVillageId().orElse(-2).intValue() == this.getId() || target.getVillagerBrain().getMemoriesForPlayer((Player)p).getHearts() > Config.getInstance().heartsToBeConsideredAsFriend).forEach(player -> player.m_5661_((Component)Component.m_237110_((String)event, (Object[])new Object[]{target.m_7755_()}), !Config.getInstance().showNotificationsAsChat));
    }

    public void broadCastMessage(ServerLevel world, String event, String targetName) {
        world.m_6907_().stream().filter(p -> PlayerSaveData.get(p).getLastSeenVillageId().orElse(-2).intValue() == this.getId()).forEach(player -> player.m_5661_((Component)Component.m_237110_((String)event, (Object[])new Object[]{targetName}), !Config.getInstance().showNotificationsAsChat));
    }

    public void markDirty(ServerLevel world) {
        VillageManager.get(world).m_77762_();
    }

    public void addResident(VillagerEntityMCA villager, int buildingId) {
        this.removeResident(villager);
        this.lastMoveIn = villager.f_19853_.m_46467_();
        this.buildings.get(buildingId).addResident((Entity)villager);
        this.markDirty((ServerLevel)villager.f_19853_);
    }

    public void removeResident(VillagerEntityMCA villager) {
        this.removeResident(villager.m_20148_());
    }

    public void removeResident(UUID uuid) {
        this.buildings.values().forEach(b -> b.getResidents().remove(uuid));
    }

    public EquipmentSet getGuardEquipment(VillagerProfession profession, InteractionHand dominantHand) {
        if (profession == ProfessionsMCA.ARCHER.get()) {
            if (this.hasBuilding("armory")) {
                if (this.hasBuilding("blacksmith")) {
                    return Village.getEquipmentFor(dominantHand, EquipmentSet.ARCHER_2, EquipmentSet.ARCHER_2_LEFT);
                }
                return Village.getEquipmentFor(dominantHand, EquipmentSet.ARCHER_1, EquipmentSet.ARCHER_1_LEFT);
            }
            return Village.getEquipmentFor(dominantHand, EquipmentSet.ARCHER_0, EquipmentSet.ARCHER_0_LEFT);
        }
        if (this.hasBuilding("armory")) {
            if (this.hasBuilding("blacksmith")) {
                return EquipmentSet.GUARD_2;
            }
            return EquipmentSet.GUARD_1;
        }
        return Village.getEquipmentFor(dominantHand, EquipmentSet.GUARD_0, EquipmentSet.GUARD_0_LEFT);
    }

    public static EquipmentSet getEquipmentFor(InteractionHand dominantHand, EquipmentSet rightSet, EquipmentSet leftSet) {
        return dominantHand == InteractionHand.OFF_HAND && leftSet != null ? leftSet : rightSet;
    }

    public void cleanReputation() {
        Set residents = this.getResidentsUUIDs().collect(Collectors.toSet());
        for (Map<UUID, Integer> map : this.reputation.values()) {
            Set toRemove = map.keySet().stream().filter(v -> !residents.contains(v)).collect(Collectors.toSet());
            for (UUID uuid : toRemove) {
                map.remove(uuid);
            }
        }
    }

    public void setReputation(Player player, VillagerEntityMCA villager, int rep) {
        this.reputation.computeIfAbsent(player.m_20148_(), i -> new HashMap()).put(villager.m_20148_(), rep);
        this.markDirty((ServerLevel)player.f_19853_);
    }

    public int getReputation(Player player) {
        return this.reputation.getOrDefault(player.m_20148_(), Collections.emptyMap()).values().stream().mapToInt(i -> i).sum() + this.unspentHearts.getOrDefault(player.m_20148_(), 0);
    }

    public void resetHearts(Player player) {
        this.unspentHearts.remove(player.m_20148_());
        this.markDirty((ServerLevel)player.f_19853_);
    }

    public void pushHearts(Player player, int rep) {
        this.pushHearts(player.m_20148_(), rep);
        this.markDirty((ServerLevel)player.f_19853_);
    }

    public void pushHearts(UUID player, int rep) {
        this.unspentHearts.put(player, this.unspentHearts.getOrDefault(player, 0) + rep);
    }

    public int popHearts(Player player) {
        int v = this.unspentHearts.getOrDefault(player.m_20148_(), 0);
        int step = (int)Math.ceil(Math.abs((double)v / (double)this.getPopulation()));
        if (v > 0) {
            if ((v -= step) == 0) {
                this.unspentHearts.remove(player.m_20148_());
            } else {
                this.unspentHearts.put(player.m_20148_(), v);
            }
            this.markDirty((ServerLevel)player.f_19853_);
            return step;
        }
        if (v < 0) {
            if ((v += step) == 0) {
                this.unspentHearts.remove(player.m_20148_());
            } else {
                this.unspentHearts.put(player.m_20148_(), v);
            }
            this.markDirty((ServerLevel)player.f_19853_);
            return -step;
        }
        return 0;
    }

    public void pushMood(ServerLevel world, int m) {
        this.unspentMood += m;
        this.markDirty(world);
    }

    public int popMood(ServerLevel world) {
        int step = (int)Math.ceil(Math.abs((double)this.unspentMood / (double)this.getPopulation()));
        if (this.unspentMood > 0) {
            this.unspentMood -= step;
            this.markDirty(world);
            return step;
        }
        if (this.unspentMood < 0) {
            this.unspentMood += step;
            this.markDirty(world);
            return -step;
        }
        return 0;
    }

    public CompoundTag save() {
        CompoundTag v = new CompoundTag();
        v.m_128405_("id", this.id);
        v.m_128359_("name", this.name);
        v.m_128405_("taxes", this.taxes);
        v.m_128365_("unspentHearts", (Tag)NbtHelper.fromMap(new CompoundTag(), this.unspentHearts, UUID::toString, IntTag::m_128679_));
        v.m_128365_("reputation", (Tag)NbtHelper.fromMap(new CompoundTag(), this.reputation, UUID::toString, i -> NbtHelper.fromMap(new CompoundTag(), i, UUID::toString, IntTag::m_128679_)));
        v.m_128405_("unspentMood", this.unspentMood);
        v.m_128405_("populationThreshold", this.populationThreshold);
        v.m_128405_("marriageThreshold", this.marriageThreshold);
        v.m_128365_("buildings", (Tag)NbtHelper.fromList(this.buildings.values(), Building::save));
        v.m_128379_("autoScan", this.autoScan);
        return v;
    }

    public void load(CompoundTag v) {
        this.id = v.m_128451_("id");
        this.name = v.m_128461_("name");
        this.taxes = v.m_128451_("taxes");
        this.unspentHearts = NbtHelper.toMap(v.m_128469_("unspentHearts"), UUID::fromString, i -> ((IntTag)i).m_7047_());
        this.reputation = NbtHelper.toMap(v.m_128469_("reputation"), UUID::fromString, i -> NbtHelper.toMap((CompoundTag)i, UUID::fromString, i2 -> ((IntTag)i2).m_7047_()));
        this.unspentMood = v.m_128451_("unspentMood");
        this.populationThreshold = v.m_128451_("populationThreshold");
        this.marriageThreshold = v.m_128451_("marriageThreshold");
        this.autoScan = v.m_128441_("autoScan") ? v.m_128471_("autoScan") : true;
        ListTag b = v.m_128437_("buildings", 10);
        for (int i2 = 0; i2 < b.size(); ++i2) {
            Building building = new Building(b.m_128728_(i2));
            this.buildings.put(building.getId(), building);
        }
        if (!this.buildings.isEmpty()) {
            this.calculateDimensions();
        }
    }

    public void merge(Village village) {
        this.buildings.putAll(village.buildings);
        this.unspentMood += village.unspentMood;
        this.calculateDimensions();
    }

    public boolean isVillage() {
        return this.getBuildings().size() >= Config.getInstance().minimumBuildingsToBeConsideredAVillage;
    }

    private static /* synthetic */ void lambda$tick$6(Component msg, ServerPlayer player) {
        player.m_5661_(msg, true);
    }
}

