/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.server.world.data;

import forge.net.mca.item.BabyItem;
import forge.net.mca.server.world.data.VillageManager;
import forge.net.mca.util.NbtHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class BabyBunker {
    private final Map<UUID, List<ItemStack>> limbo;
    private final VillageManager manager;

    BabyBunker(VillageManager manager) {
        this.manager = manager;
        this.limbo = new HashMap<UUID, List<ItemStack>>();
    }

    BabyBunker(VillageManager manager, CompoundTag nbt) {
        this.manager = manager;
        this.limbo = NbtHelper.toMap(nbt, UUID::fromString, element -> NbtHelper.toList(element, i -> ItemStack.m_41712_((CompoundTag)((CompoundTag)i))));
    }

    public CompoundTag writeNbt(CompoundTag nbt) {
        return NbtHelper.fromMap(nbt, this.limbo, UUID::toString, stacks -> NbtHelper.fromList(stacks, stack -> stack.m_41739_(new CompoundTag())));
    }

    public void pop(Player player) {
        List<ItemStack> baby = this.limbo.remove(player.m_20148_());
        if (baby != null) {
            baby.forEach(bab -> {
                if (!player.m_36356_(bab)) {
                    player.m_5552_(bab, 0.0f);
                }
            });
            this.manager.m_77762_();
        }
    }

    public void push(Player player) {
        List babies = player.m_150109_().f_35974_.stream().filter(s -> s.m_41720_() instanceof BabyItem).collect(Collectors.toList());
        if (!babies.isEmpty()) {
            this.limbo.put(player.m_20148_(), babies);
            this.manager.m_77762_();
        }
    }
}

