/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.server;

import forge.net.mca.Config;
import forge.net.mca.ducks.IVillagerEntity;
import forge.net.mca.entity.VillagerFactory;
import forge.net.mca.entity.ZombieVillagerEntityMCA;
import forge.net.mca.entity.ZombieVillagerFactory;
import forge.net.mca.entity.ai.relationship.Gender;
import forge.net.mca.server.world.data.Nationality;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;

public class SpawnQueue {
    private static final SpawnQueue INSTANCE = new SpawnQueue();
    private final List<Villager> villagerSpawnQueue = new LinkedList<Villager>();
    private final List<ZombieVillager> zombieVillagerSpawnQueue = new LinkedList<ZombieVillager>();

    public static SpawnQueue getInstance() {
        return INSTANCE;
    }

    public void tick() {
        Villager e;
        if (!this.villagerSpawnQueue.isEmpty()) {
            e = this.villagerSpawnQueue.remove(0);
            if (e.f_19853_.m_46749_(e.m_20183_())) {
                e.m_146870_();
                VillagerFactory.newVillager(e.f_19853_).withName(e.m_8077_() ? e.m_7755_().getString() : null).withGender(Gender.getRandom()).withAge(e.m_146764_()).withPosition((Entity)e).withType(e.m_7141_().m_35560_()).withProfession(e.m_7141_().m_35571_(), e.m_7141_().m_35576_(), e.m_6616_()).spawn(((IVillagerEntity)e).getSpawnReason());
            } else {
                this.villagerSpawnQueue.add(e);
            }
        }
        if (!this.zombieVillagerSpawnQueue.isEmpty()) {
            e = this.zombieVillagerSpawnQueue.remove(0);
            if (e.f_19853_.m_46749_(e.m_20183_())) {
                e.m_146870_();
                ZombieVillagerEntityMCA z = ZombieVillagerFactory.newVillager(e.f_19853_).withName(e.m_8077_() ? e.m_7755_().getString() : null).withGender(Gender.getRandom()).withPosition((Entity)e).withType(e.m_7141_().m_35560_()).withProfession(e.m_7141_().m_35571_(), e.m_7141_().m_35576_()).spawn(((IVillagerEntity)e).getSpawnReason());
                if (e.m_21532_()) {
                    z.m_21530_();
                }
            } else {
                this.zombieVillagerSpawnQueue.add((ZombieVillager)e);
            }
        }
    }

    public static boolean shouldGetConverted(Entity entity) {
        if (Config.getInstance().percentageOfVanillaVillages <= 0) {
            return true;
        }
        int i = Nationality.get((ServerLevel)entity.m_9236_()).getRegionId(entity.m_20183_());
        return Math.floorMod(i, 100) >= Config.getInstance().percentageOfVanillaVillages;
    }

    public boolean addVillager(Entity entity) {
        IVillagerEntity villagerEntity;
        if (entity instanceof IVillagerEntity && !this.handlesSpawnReason((villagerEntity = (IVillagerEntity)entity).getSpawnReason())) {
            return false;
        }
        if (Config.getInstance().villagerDimensionBlacklist.contains(entity.m_20193_().m_46472_().m_135782_().toString())) {
            return false;
        }
        if (Config.getInstance().overwriteOriginalVillagers && (entity.getClass().equals(Villager.class) || Config.getInstance().moddedVillagerWhitelist.contains(Registry.f_122826_.m_7981_((Object)entity.m_6095_()).toString()) && entity instanceof Villager) && SpawnQueue.shouldGetConverted(entity) && !this.villagerSpawnQueue.contains(entity)) {
            return this.villagerSpawnQueue.add((Villager)entity);
        }
        if (Config.getInstance().overwriteOriginalZombieVillagers && (entity.getClass().equals(ZombieVillager.class) || Config.getInstance().moddedZombieVillagerWhitelist.contains(Registry.f_122826_.m_7981_((Object)entity.m_6095_()).toString()) && entity instanceof ZombieVillager) && !this.zombieVillagerSpawnQueue.contains(entity)) {
            return this.zombieVillagerSpawnQueue.add((ZombieVillager)entity);
        }
        return false;
    }

    private boolean handlesSpawnReason(MobSpawnType reason) {
        return Config.getInstance().allowedSpawnReasons.contains(reason.name().toLowerCase());
    }

    public void convert(Villager villager) {
        this.villagerSpawnQueue.add(villager);
    }
}

