/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.resources;

import com.google.gson.JsonElement;
import forge.net.mca.Config;
import forge.net.mca.MCA;
import forge.net.mca.entity.ai.relationship.Gender;
import forge.net.mca.resources.Resources;
import forge.net.mca.resources.WeightedPool;
import forge.net.mca.server.world.data.Nationality;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class Names
extends SimpleJsonResourceReloadListener {
    protected static final ResourceLocation ID = MCA.locate("names");
    public static final List<Map<Gender, WeightedPool<String>>> NAMES = new ArrayList<Map<Gender, WeightedPool<String>>>();
    public static final Map<String, Map<Gender, WeightedPool<String>>> NAMES_MAP = new HashMap<String, Map<Gender, WeightedPool<String>>>();
    static RandomSource random = RandomSource.m_216327_();

    public Names() {
        super(Resources.GSON, ID.m_135815_());
    }

    protected void apply(Map<ResourceLocation, JsonElement> prepared, ResourceManager manager, ProfilerFiller profiler) {
        NAMES_MAP.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : prepared.entrySet()) {
            String[] split = entry.getKey().m_135815_().split("/");
            Gender gender = Gender.byName(split[1]);
            Map map = NAMES_MAP.computeIfAbsent(split[0], a -> new HashMap());
            WeightedPool.Mutable<String> names = new WeightedPool.Mutable<String>("?");
            for (Map.Entry elementEntry : entry.getValue().getAsJsonObject().entrySet()) {
                names.add((String)elementEntry.getKey(), (float)Math.pow(((JsonElement)elementEntry.getValue()).getAsInt(), 0.5));
            }
            map.put(gender, names);
        }
        NAMES.clear();
        Arrays.stream(NAMES_MAP.keySet().toArray()).sorted().forEach(n -> NAMES.add(NAMES_MAP.get((String)n)));
    }

    public static String pickCitizenName(@NotNull Gender gender, Entity entity) {
        Map<Gender, WeightedPool<String>> countries;
        if (Config.getInstance().useModernUSANamesOnly) {
            countries = NAMES_MAP.get("modernusa");
        } else {
            int i = Nationality.get((ServerLevel)entity.m_9236_()).getRegionId(entity.m_20183_());
            countries = NAMES.get(Math.floorMod(i, NAMES.size()));
        }
        return countries.get((Object)gender.binary()).pickOne();
    }

    public static String pickCitizenName(@NotNull Gender gender) {
        return NAMES.get(random.m_188503_(NAMES.size())).get((Object)gender.binary()).pickOne();
    }
}

