/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import forge.net.mca.MCA;
import forge.net.mca.entity.ai.relationship.Gender;
import forge.net.mca.resources.ClothingList;
import forge.net.mca.resources.Resources;
import forge.net.mca.resources.WeightedPool;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;

public class HairList
extends SimpleJsonResourceReloadListener {
    protected static final ResourceLocation ID = MCA.locate("skins/hair");
    public final HashMap<String, Hair> hair = new HashMap();
    private static HairList INSTANCE;

    public static HairList getInstance() {
        return INSTANCE;
    }

    public HairList() {
        super(Resources.GSON, "skins/hair");
        INSTANCE = this;
    }

    protected void apply(Map<ResourceLocation, JsonElement> data, ResourceManager manager, ProfilerFiller profiler) {
        this.hair.clear();
        data.forEach((id, file) -> {
            Gender gender = Gender.byName(id.m_135815_().split("\\.")[0]);
            if (gender == Gender.UNASSIGNED) {
                MCA.LOGGER.warn("Invalid gender for clothing pool: {}", id);
                return;
            }
            for (String key : file.getAsJsonObject().keySet()) {
                JsonObject object = file.getAsJsonObject().get(key).getAsJsonObject();
                for (int i = 0; i < GsonHelper.m_13824_((JsonObject)object, (String)"count", (int)1); ++i) {
                    String identifier = String.format(key, i);
                    Hair c = new Hair(identifier);
                    c.gender = gender;
                    c.overlay = GsonHelper.m_13855_((JsonObject)object, (String)"overlay", (boolean)false);
                    c.chance = GsonHelper.m_13820_((JsonObject)object, (String)"chance", (float)1.0f);
                    c.temperature = GsonHelper.m_13824_((JsonObject)object, (String)"temperature", (int)0);
                    if (this.hair.containsKey(identifier) && object.has("count")) continue;
                    this.hair.put(identifier, c);
                }
            }
        });
    }

    public WeightedPool<String> getPool(Gender gender) {
        return this.hair.values().stream().filter(c -> c.gender == Gender.NEUTRAL || gender == Gender.NEUTRAL || c.gender == gender).collect(() -> new WeightedPool.Mutable<String>("mca:missing"), (list, entry) -> list.add(entry.identifier, entry.chance), (a, b) -> a.entries.addAll(b.entries));
    }

    public static class Hair
    extends ClothingList.ListEntry {
        public boolean overlay;
        public float temperature;

        public Hair(String identifier) {
            super(identifier);
        }
    }
}

