/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.network;

import forge.net.mca.Config;
import forge.net.mca.MCAClient;
import forge.net.mca.client.book.Book;
import forge.net.mca.client.gui.BlueprintScreen;
import forge.net.mca.client.gui.CombScreen;
import forge.net.mca.client.gui.ExtendedBookScreen;
import forge.net.mca.client.gui.FamilyTreeScreen;
import forge.net.mca.client.gui.FamilyTreeSearchScreen;
import forge.net.mca.client.gui.InteractScreen;
import forge.net.mca.client.gui.LimitedVillagerEditorScreen;
import forge.net.mca.client.gui.NameBabyScreen;
import forge.net.mca.client.gui.NeedleScreen;
import forge.net.mca.client.gui.VillagerEditorScreen;
import forge.net.mca.client.gui.WhistleScreen;
import forge.net.mca.entity.EntitiesMCA;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.VillagerLike;
import forge.net.mca.item.BabyItem;
import forge.net.mca.item.ExtendedWrittenBookItem;
import forge.net.mca.network.ClientInteractionManager;
import forge.net.mca.network.s2c.AnalysisResults;
import forge.net.mca.network.s2c.BabyNameResponse;
import forge.net.mca.network.s2c.FamilyTreeUUIDResponse;
import forge.net.mca.network.s2c.GetChildDataResponse;
import forge.net.mca.network.s2c.GetFamilyResponse;
import forge.net.mca.network.s2c.GetFamilyTreeResponse;
import forge.net.mca.network.s2c.GetInteractDataResponse;
import forge.net.mca.network.s2c.GetVillageFailedResponse;
import forge.net.mca.network.s2c.GetVillageResponse;
import forge.net.mca.network.s2c.GetVillagerResponse;
import forge.net.mca.network.s2c.InteractionDialogueResponse;
import forge.net.mca.network.s2c.OpenDestinyGuiRequest;
import forge.net.mca.network.s2c.OpenGuiRequest;
import forge.net.mca.network.s2c.PlayerDataMessage;
import forge.net.mca.network.s2c.ShowToastRequest;
import forge.net.mca.network.s2c.SkinListResponse;
import forge.net.mca.network.s2c.VillagerNameResponse;
import forge.net.mca.server.world.data.BabyTracker;
import forge.net.mca.server.world.data.Village;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ClientInteractionManagerImpl
implements ClientInteractionManager {
    private final Minecraft client = Minecraft.m_91087_();

    @Override
    public void handleGuiRequest(OpenGuiRequest message) {
        assert (this.client.f_91073_ != null);
        assert (Minecraft.m_91087_().f_91074_ != null);
        switch (message.getGui()) {
            case WHISTLE: {
                this.client.m_91152_((Screen)new WhistleScreen());
                break;
            }
            case BOOK: {
                ItemStack item;
                Item item2;
                if (this.client.f_91074_ == null || !((item2 = (item = this.client.f_91074_.m_21120_(InteractionHand.MAIN_HAND)).m_41720_()) instanceof ExtendedWrittenBookItem)) break;
                ExtendedWrittenBookItem bookItem = (ExtendedWrittenBookItem)item2;
                Book book = bookItem.getBook(item);
                this.client.m_91152_((Screen)new ExtendedBookScreen(book));
                break;
            }
            case BLUEPRINT: {
                this.client.m_91152_((Screen)new BlueprintScreen());
                break;
            }
            case INTERACT: {
                ItemStack item;
                boolean isOnBlacklist;
                if (this.client.f_91074_ == null || (isOnBlacklist = Config.getInstance().villagerInteractionItemBlacklist.contains(Registry.f_122827_.m_7981_((Object)(item = this.client.f_91074_.m_21120_(InteractionHand.MAIN_HAND)).m_41720_()).toString()))) break;
                VillagerLike villager = (VillagerLike)this.client.f_91073_.m_6815_(message.villager);
                this.client.m_91152_((Screen)new InteractScreen(villager));
                break;
            }
            case VILLAGER_EDITOR: {
                Entity entity = this.client.f_91073_.m_6815_(message.villager);
                assert (entity != null);
                this.client.m_91152_((Screen)new VillagerEditorScreen(entity.m_20148_(), Minecraft.m_91087_().f_91074_.m_20148_()));
                break;
            }
            case LIMITED_VILLAGER_EDITOR: {
                Entity entity = this.client.f_91073_.m_6815_(message.villager);
                assert (entity != null);
                this.client.m_91152_((Screen)new LimitedVillagerEditorScreen(entity.m_20148_(), Minecraft.m_91087_().f_91074_.m_20148_()));
                break;
            }
            case NEEDLE_AND_THREAD: {
                Entity entity = this.client.f_91073_.m_6815_(message.villager);
                if (entity == null) {
                    this.client.m_91152_((Screen)new NeedleScreen(Minecraft.m_91087_().f_91074_.m_20148_()));
                    break;
                }
                this.client.m_91152_((Screen)new NeedleScreen(entity.m_20148_(), Minecraft.m_91087_().f_91074_.m_20148_()));
                break;
            }
            case COMB: {
                Entity entity = this.client.f_91073_.m_6815_(message.villager);
                if (entity == null) {
                    this.client.m_91152_((Screen)new CombScreen(Minecraft.m_91087_().f_91074_.m_20148_()));
                    break;
                }
                this.client.m_91152_((Screen)new CombScreen(entity.m_20148_(), Minecraft.m_91087_().f_91074_.m_20148_()));
                break;
            }
            case BABY_NAME: {
                ItemStack item;
                if (this.client.f_91074_ == null || !((item = this.client.f_91074_.m_21120_(InteractionHand.MAIN_HAND)).m_41720_() instanceof BabyItem)) break;
                this.client.m_91152_((Screen)new NameBabyScreen((Player)this.client.f_91074_, item));
                break;
            }
            case FAMILY_TREE: {
                this.client.m_91152_((Screen)new FamilyTreeSearchScreen());
                break;
            }
        }
    }

    @Override
    public void handleFamilyTreeResponse(GetFamilyTreeResponse message) {
        Screen screen = this.client.f_91080_;
        if (screen instanceof FamilyTreeScreen) {
            FamilyTreeScreen gui = (FamilyTreeScreen)screen;
            gui.setFamilyData(message.uuid, message.family);
        }
    }

    @Override
    public void handleInteractDataResponse(GetInteractDataResponse message) {
        Screen screen = this.client.f_91080_;
        if (screen instanceof InteractScreen) {
            InteractScreen gui = (InteractScreen)screen;
            gui.setConstraints(message.constraints);
            gui.setParents(message.father, message.mother);
            gui.setSpouse(message.marriageState, message.spouse);
        }
    }

    @Override
    public void handleVillageDataResponse(GetVillageResponse message) {
        Screen screen = this.client.f_91080_;
        if (screen instanceof BlueprintScreen) {
            BlueprintScreen gui = (BlueprintScreen)screen;
            Village village = new Village();
            village.load(message.getData());
            gui.setVillage(village);
            gui.setRank(message.rank, message.reputation, message.isVillage, message.ids, message.tasks, message.buildingTypes);
        }
    }

    @Override
    public void handleVillageDataFailedResponse(GetVillageFailedResponse message) {
        Screen screen = this.client.f_91080_;
        if (screen instanceof BlueprintScreen) {
            BlueprintScreen gui = (BlueprintScreen)screen;
            gui.setVillage(null);
        }
    }

    @Override
    public void handleFamilyDataResponse(GetFamilyResponse message) {
        Screen screen = this.client.f_91080_;
        if (screen instanceof WhistleScreen) {
            WhistleScreen gui = (WhistleScreen)screen;
            gui.setVillagerData(message.getData());
        }
    }

    @Override
    public void handleVillagerDataResponse(GetVillagerResponse message) {
        Screen screen = this.client.f_91080_;
        if (screen instanceof VillagerEditorScreen) {
            VillagerEditorScreen gui = (VillagerEditorScreen)screen;
            gui.setVillagerData(message.getData());
        }
    }

    @Override
    public void handleDialogueResponse(InteractionDialogueResponse message) {
        Screen screen = this.client.f_91080_;
        if (screen instanceof InteractScreen) {
            InteractScreen gui = (InteractScreen)screen;
            gui.setDialogue(message.question, message.answers, message.silent);
        }
    }

    @Override
    public void handleChildData(GetChildDataResponse message) {
        BabyItem.CLIENT_STATE_CACHE.put((Object)message.id, Optional.ofNullable(message.getData()).map(BabyTracker.ChildSaveState::new));
    }

    @Override
    public void handleSkinListResponse(AnalysisResults message) {
        InteractScreen.setAnalysis(message.analysis);
    }

    @Override
    public void handleBabyNameResponse(BabyNameResponse message) {
        Screen screen = this.client.f_91080_;
        if (screen instanceof NameBabyScreen) {
            NameBabyScreen gui = (NameBabyScreen)screen;
            gui.setBabyName(message.getName());
        }
    }

    @Override
    public void handleVillagerNameResponse(VillagerNameResponse message) {
        Screen screen = this.client.f_91080_;
        if (screen instanceof VillagerEditorScreen) {
            VillagerEditorScreen gui = (VillagerEditorScreen)screen;
            gui.setVillagerName(message.getName());
        }
    }

    @Override
    public void handleToastMessage(ShowToastRequest message) {
        SystemToast.m_94855_((ToastComponent)this.client.m_91300_(), (SystemToast.SystemToastIds)SystemToast.SystemToastIds.TUTORIAL_HINT, (Component)message.getTitle(), (Component)message.getMessage());
    }

    @Override
    public void handleFamilyTreeUUIDResponse(FamilyTreeUUIDResponse response) {
        Screen screen = this.client.f_91080_;
        if (screen instanceof FamilyTreeSearchScreen) {
            FamilyTreeSearchScreen gui = (FamilyTreeSearchScreen)screen;
            gui.setList(response.getList());
        }
    }

    @Override
    public void handlePlayerDataMessage(PlayerDataMessage response) {
        VillagerEntityMCA villager = (VillagerEntityMCA)((EntityType)EntitiesMCA.MALE_VILLAGER.get()).m_20615_((Level)Minecraft.m_91087_().f_91073_);
        assert (villager != null);
        villager.m_7378_(response.getData());
        MCAClient.playerData.put(response.uuid, villager);
    }

    @Override
    public void handleSkinListResponse(SkinListResponse message) {
        Screen screen = this.client.f_91080_;
        if (screen instanceof VillagerEditorScreen) {
            VillagerEditorScreen gui = (VillagerEditorScreen)screen;
            gui.setSkinList(message.getClothing(), message.getHair());
        }
    }

    @Override
    public void handleDestinyGuiRequest(OpenDestinyGuiRequest message) {
        MCAClient.getDestinyManager().requestOpen(message.allowTeleportation);
    }
}

