/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import forge.net.mca.MCA;
import forge.net.mca.MCAClient;
import forge.net.mca.client.model.CommonVillagerModel;
import forge.net.mca.client.model.PlayerEntityExtendedModel;
import forge.net.mca.client.model.VillagerEntityModelMCA;
import forge.net.mca.client.render.layer.ClothingLayer;
import forge.net.mca.client.render.layer.FaceLayer;
import forge.net.mca.client.render.layer.HairLayer;
import forge.net.mca.client.render.layer.SkinLayer;
import forge.net.mca.client.render.layer.VillagerLayer;
import forge.net.mca.entity.ai.relationship.AgeState;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerRenderer.class})
public abstract class MixinPlayerEntityRenderer
extends LivingEntityRenderer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private PlayerModel<AbstractClientPlayer> villagerModel;
    private PlayerModel<AbstractClientPlayer> vanillaModel;
    SkinLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> skinLayer;
    ClothingLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> clothingLayer;

    @Shadow
    protected abstract void m_117818_(AbstractClientPlayer var1);

    public MixinPlayerEntityRenderer(EntityRendererProvider.Context ctx, PlayerModel<AbstractClientPlayer> model, float shadowRadius) {
        super(ctx, model, shadowRadius);
    }

    @Inject(method={"<init>(Lnet/minecraft/client/render/entity/EntityRendererFactory$Context;Z)V"}, at={@At(value="TAIL")})
    private void init(EntityRendererProvider.Context ctx, boolean slim, CallbackInfo ci) {
        if (MCA.isPlayerRendererAllowed()) {
            this.villagerModel = MixinPlayerEntityRenderer.createModel(VillagerEntityModelMCA.bodyData(new CubeDeformation(0.0f), slim));
            this.vanillaModel = (PlayerModel)this.f_115290_;
            this.skinLayer = new SkinLayer(this, MixinPlayerEntityRenderer.createModel(VillagerEntityModelMCA.bodyData(new CubeDeformation(0.0f))));
            this.m_115326_(this.skinLayer);
            this.m_115326_(new FaceLayer(this, MixinPlayerEntityRenderer.createModel(VillagerEntityModelMCA.bodyData(new CubeDeformation(0.01f))), "normal"));
            this.clothingLayer = new ClothingLayer(this, MixinPlayerEntityRenderer.createModel(VillagerEntityModelMCA.bodyData(new CubeDeformation(0.0625f))), "normal");
            this.m_115326_(this.clothingLayer);
            this.m_115326_(new HairLayer(this, MixinPlayerEntityRenderer.createModel(VillagerEntityModelMCA.hairData(new CubeDeformation(0.125f)))));
        }
    }

    private static PlayerEntityExtendedModel<AbstractClientPlayer> createModel(MeshDefinition data) {
        return new PlayerEntityExtendedModel<AbstractClientPlayer>(LayerDefinition.m_171565_((MeshDefinition)data, (int)64, (int)64).m_171564_());
    }

    @Inject(method={"scale(Lnet/minecraft/client/network/AbstractClientPlayerEntity;Lnet/minecraft/client/util/math/MatrixStack;F)V"}, at={@At(value="TAIL")}, cancellable=true)
    private void injectScale(AbstractClientPlayer villager, PoseStack matrices, float f, CallbackInfo ci) {
        if (MCAClient.useGeneticsRenderer(villager.m_20148_())) {
            float height = CommonVillagerModel.getVillager((Entity)villager).getRawScaleFactor();
            float width = CommonVillagerModel.getVillager((Entity)villager).getHorizontalScaleFactor();
            matrices.m_85841_(width, height, width);
            if (CommonVillagerModel.getVillager((Entity)villager).getAgeState() == AgeState.BABY && !villager.m_20159_()) {
                matrices.m_85837_(0.0, (double)0.6f, 0.0);
            }
            ci.cancel();
            this.f_115290_ = this.villagerModel;
        } else if (MCA.isPlayerRendererAllowed()) {
            this.f_115290_ = this.vanillaModel;
        }
    }

    @Inject(method={"renderRightArm(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/client/network/AbstractClientPlayerEntity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void injectRenderRightArm(PoseStack matrices, MultiBufferSource vertexConsumers, int light, AbstractClientPlayer player, CallbackInfo ci) {
        if (MCAClient.renderArms(player.m_20148_(), "right_arm")) {
            this.renderCustomArm(matrices, vertexConsumers, light, player, ((PlayerModel)this.skinLayer.model).f_102811_, ((PlayerModel)this.skinLayer.model).f_103375_, this.skinLayer);
            this.renderCustomArm(matrices, vertexConsumers, light, player, ((PlayerModel)this.clothingLayer.model).f_102811_, ((PlayerModel)this.clothingLayer.model).f_103375_, this.clothingLayer);
            ci.cancel();
        }
    }

    @Inject(method={"renderLeftArm(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/client/network/AbstractClientPlayerEntity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void injectRenderLeftArm(PoseStack matrices, MultiBufferSource vertexConsumers, int light, AbstractClientPlayer player, CallbackInfo ci) {
        if (MCAClient.renderArms(player.m_20148_(), "left_arm")) {
            this.renderCustomArm(matrices, vertexConsumers, light, player, ((PlayerModel)this.skinLayer.model).f_102812_, ((PlayerModel)this.skinLayer.model).f_103374_, this.skinLayer);
            this.renderCustomArm(matrices, vertexConsumers, light, player, ((PlayerModel)this.clothingLayer.model).f_102812_, ((PlayerModel)this.clothingLayer.model).f_103374_, this.clothingLayer);
            ci.cancel();
        }
    }

    private void renderCustomArm(PoseStack matrices, MultiBufferSource vertexConsumers, int light, AbstractClientPlayer player, ModelPart arm, ModelPart sleeve, VillagerLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> layer) {
        PlayerEntityExtendedModel model = (PlayerEntityExtendedModel)layer.model;
        this.m_117818_(player);
        model.f_102608_ = 0.0f;
        model.f_102817_ = false;
        model.f_102818_ = 0.0f;
        model.m_6973_(player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        model.m_8009_(false);
        arm.f_104207_ = true;
        arm.f_104203_ = 0.0f;
        arm.f_104204_ = 0.0f;
        arm.f_104205_ = 0.0f;
        sleeve.f_104207_ = true;
        sleeve.f_104203_ = 0.0f;
        sleeve.f_104204_ = 0.0f;
        sleeve.f_104205_ = 0.0f;
        model.applyVillagerDimensions(CommonVillagerModel.getVillager((Entity)player), player.m_6047_());
        layer.renderFinal(matrices, vertexConsumers, light, player, 0.0f);
        model.m_8009_(true);
    }
}

