/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.item;

import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.Memories;
import forge.net.mca.entity.ai.Relationship;
import forge.net.mca.entity.ai.relationship.CompassionateEntity;
import forge.net.mca.item.SpecialCaseGift;
import forge.net.mca.item.TooltippedItem;
import forge.net.mca.server.world.data.PlayerSaveData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public abstract class RelationshipItem
extends TooltippedItem
implements SpecialCaseGift {
    public RelationshipItem(Item.Properties properties) {
        super(properties);
    }

    abstract float getHeartsRequired();

    @Override
    public boolean handle(ServerPlayer player, VillagerEntityMCA villager) {
        String response;
        PlayerSaveData playerData = PlayerSaveData.get(player);
        Memories memory = villager.getVillagerBrain().getMemoriesForPlayer((Player)player);
        if (villager.m_6162_()) {
            response = "interaction.relationship.fail.isbaby";
        } else if (Relationship.IS_PARENT.test((CompassionateEntity<?>)villager, (Entity)player)) {
            response = "interaction.relationship.fail.isparent";
        } else if (Relationship.IS_MARRIED.test((CompassionateEntity<?>)villager, (Entity)player)) {
            response = "interaction.relationship.fail.marriedtogiver";
        } else if (villager.getRelationships().isMarried()) {
            response = "interaction.relationship.fail.married";
        } else if (villager.getRelationships().isEngaged() && !Relationship.IS_ENGAGED.test((CompassionateEntity<?>)villager, (Entity)player)) {
            response = "interaction.relationship.fail.engaged";
        } else if (playerData.isMarried()) {
            response = "interaction.relationship.fail.playermarried";
        } else if ((float)memory.getHearts() < this.getHeartsRequired()) {
            response = "interaction.relationship.fail.lowhearts";
        } else if (!villager.canBeAttractedTo(playerData)) {
            response = "interaction.relationship.fail.incompatible";
        } else {
            return false;
        }
        villager.sendChatMessage((Player)player, response, new Object[0]);
        return true;
    }
}

