/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.item;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import forge.net.mca.ClientProxy;
import forge.net.mca.Config;
import forge.net.mca.advancement.criterion.CriterionMCA;
import forge.net.mca.cobalt.network.NetworkHandler;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.VillagerFactory;
import forge.net.mca.entity.VillagerLike;
import forge.net.mca.entity.ai.Memories;
import forge.net.mca.entity.ai.Traits;
import forge.net.mca.entity.ai.relationship.AgeState;
import forge.net.mca.entity.ai.relationship.Gender;
import forge.net.mca.entity.ai.relationship.family.FamilyTree;
import forge.net.mca.entity.ai.relationship.family.FamilyTreeNode;
import forge.net.mca.network.c2s.GetChildDataRequest;
import forge.net.mca.network.s2c.OpenGuiRequest;
import forge.net.mca.server.world.data.BabyTracker;
import forge.net.mca.util.WorldUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class BabyItem
extends Item {
    public static final LoadingCache<UUID, Optional<BabyTracker.ChildSaveState>> CLIENT_STATE_CACHE = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build(CacheLoader.from(id -> {
        NetworkHandler.sendToServer(new GetChildDataRequest((UUID)id));
        return Optional.empty();
    }));
    private final Gender gender;

    public BabyItem(Gender gender, Item.Properties properties) {
        super(properties);
        this.gender = gender;
    }

    public Gender getGender() {
        return this.gender;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        return InteractionResult.PASS;
    }

    public boolean onDropped(ItemStack stack, Player player) {
        if (!BabyItem.hasBeenInvalidated(stack)) {
            if (!player.m_9236_().f_46443_) {
                int count = 0;
                if (stack.m_41784_().m_128425_("dropAttempts", 3)) {
                    count = stack.m_41784_().m_128451_("dropAttempts") + 1;
                }
                stack.m_41784_().m_128405_("dropAttempts", count);
                CriterionMCA.BABY_DROPPED_CRITERION.trigger((ServerPlayer)player, count);
                player.m_5661_((Component)Component.m_237115_((String)"item.mca.baby.no_drop"), true);
            }
            return false;
        }
        return true;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (world.f_46443_) {
            return;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (world.m_46467_() % 20L == 0L) {
                HashSet found = new HashSet();
                int i = player.m_150109_().m_6643_() - 1;
                while (i >= 0) {
                    ItemStack s = player.m_150109_().m_8020_(i);
                    int sl = i--;
                    BabyTracker.getStateId(s).ifPresent(id -> {
                        if (found.contains(id)) {
                            player.m_150109_().m_8016_(sl);
                        } else {
                            found.add(id);
                        }
                    });
                }
            }
        }
        if (BabyTracker.hasState(stack)) {
            Optional<BabyTracker.MutableChildSaveState> state2 = BabyTracker.getState(stack, (ServerLevel)world);
            if (state2.isPresent()) {
                if (stack.m_41788_()) {
                    state2.get().setName(stack.m_41786_().getString());
                    state2.get().writeToItem(stack);
                    stack.m_41787_();
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)entity;
                        CriterionMCA.GENERIC_EVENT_CRITERION.trigger(player, "rename_baby");
                    }
                }
                if (state2.get().getName().isPresent() && world.m_46467_() % 1200L == 0L) {
                    stack.m_41783_().m_128405_("age", stack.m_41783_().m_128451_("age") + 1200);
                }
            } else {
                BabyTracker.invalidate(stack);
            }
        } else if (!stack.m_41782_() || !stack.m_41783_().m_128471_("invalidated")) {
            BabyTracker.get((ServerLevel)world).getPairing(entity.m_20148_(), entity.m_20148_()).addChild(state -> {
                state.setGender(this.gender);
                state.setOwner(entity);
                state.writeToItem(stack);
            });
        }
    }

    public Component m_7626_(ItemStack stack) {
        return BabyItem.getClientCheckedState(stack).flatMap(BabyTracker.ChildSaveState::getName).map(s -> Component.m_237110_((String)(this.m_5671_(stack) + ".named"), (Object[])new Object[]{s})).orElseGet(() -> super.m_7626_(stack));
    }

    public String m_5671_(ItemStack stack) {
        if (BabyItem.hasBeenInvalidated(stack)) {
            return super.m_5671_(stack) + ".blanket";
        }
        return super.m_5671_(stack);
    }

    public final InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (world.f_46443_) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        return BabyTracker.getState(stack, (ServerLevel)world).map(state -> {
            if (state.getName().isEmpty()) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    NetworkHandler.sendToPlayer(new OpenGuiRequest(OpenGuiRequest.Type.BABY_NAME), serverPlayer);
                }
                return InteractionResultHolder.m_19098_((Object)stack);
            }
            if (!BabyItem.isReadyToGrowUp(stack)) {
                return InteractionResultHolder.m_19098_((Object)stack);
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                this.birthChild((BabyTracker.ChildSaveState)state, (ServerLevel)world, serverPlayer);
            }
            stack.m_41774_(1);
            return InteractionResultHolder.m_19090_((Object)stack);
        }).orElseGet(() -> {
            if (BabyTracker.getState(stack).isPresent()) {
                world.m_7605_((Entity)player, (byte)43);
                player.m_5496_(SoundEvents.f_12498_, 1.0f, 1.0f);
                BabyTracker.invalidate(stack);
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        });
    }

    protected VillagerEntityMCA birthChild(BabyTracker.ChildSaveState state, ServerLevel world, ServerPlayer player) {
        VillagerEntityMCA child = VillagerFactory.newVillager((Level)world).withName(state.getName().orElse("Unnamed")).withPosition(player.m_20182_()).withGender(this.gender).withAge(-AgeState.getMaxAge()).build();
        List<Entity> parents = state.getParents().map(arg_0 -> ((ServerLevel)world).m_8791_(arg_0)).filter(Objects::nonNull).toList();
        Optional mother = parents.stream().findFirst();
        Optional father = parents.stream().skip(1L).findFirst();
        child.getGenetics().combine(mother.map(VillagerLike::toVillager).map(VillagerLike::getGenetics), father.map(VillagerLike::toVillager).map(VillagerLike::getGenetics), state.getSeed());
        mother.map(VillagerLike::toVillager).map(VillagerLike::getTraits).ifPresent(t -> child.getTraits().inherit((Traits)t, state.getSeed()));
        father.map(VillagerLike::toVillager).map(VillagerLike::getTraits).ifPresent(t -> child.getTraits().inherit((Traits)t, state.getSeed()));
        state.getParents().forEach(p -> FamilyTree.get(world).getOrEmpty((UUID)p).ifPresent(parent -> child.getRelationships().getFamilyEntry().assignParent((FamilyTreeNode)parent)));
        WorldUtils.spawnEntity((Level)world, (Mob)child, MobSpawnType.BREEDING);
        Stream.concat(Stream.of(mother, father).filter(Optional::isPresent).map(Optional::get), Stream.of(player)).filter(e -> e instanceof ServerPlayer).map(ServerPlayer.class::cast).distinct().forEach(ply -> {
            CriterionMCA.FAMILY.trigger((ServerPlayer)ply);
            Memories memories = child.getVillagerBrain().getMemoriesForPlayer((Player)ply);
            memories.setHearts(Config.getInstance().childInitialHearts);
        });
        BabyTracker.get(world).getPairing(state).removeChild(state);
        return child;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        BabyItem.getClientState(stack).ifPresent(state -> {
            Player player = ClientProxy.getClientPlayer();
            CompoundTag nbt = stack.m_41783_();
            assert (nbt != null);
            int age = nbt.m_128451_("age") + (int)(world == null ? 0L : world.m_46467_() % 1200L);
            if (state.getName().isEmpty()) {
                tooltip.add((Component)Component.m_237115_((String)"item.mca.baby.give_name").m_130940_(ChatFormatting.YELLOW));
            } else {
                MutableComponent text = Component.m_237113_((String)state.getName().get());
                tooltip.add((Component)Component.m_237110_((String)"item.mca.baby.name", (Object[])new Object[]{text.m_6270_(text.m_7383_().m_178520_(this.gender.getColor()))}).m_130940_(ChatFormatting.GRAY));
                if (age > 0) {
                    tooltip.add((Component)Component.m_237110_((String)"item.mca.baby.age", (Object[])new Object[]{StringUtil.m_14404_((int)age)}).m_130940_(ChatFormatting.GRAY));
                }
            }
            tooltip.add((Component)Component.m_237113_((String)""));
            state.getOwner().ifPresent(owner -> tooltip.add((Component)Component.m_237110_((String)"item.mca.baby.owner", (Object[])new Object[]{player != null && ((UUID)owner.getLeft()).equals(player.m_20148_()) ? Component.m_237115_((String)"item.mca.baby.owner.you") : owner.getRight()}).m_130940_(ChatFormatting.GRAY)));
            if (state.getName().isPresent() && BabyItem.canGrow(age)) {
                tooltip.add((Component)Component.m_237115_((String)"item.mca.baby.state.ready").m_130940_(ChatFormatting.DARK_GREEN));
            }
            if (state.isInfected()) {
                tooltip.add((Component)Component.m_237115_((String)"item.mca.baby.state.infected").m_130940_(ChatFormatting.DARK_GREEN));
            }
        });
    }

    private static Optional<BabyTracker.ChildSaveState> getClientCheckedState(ItemStack stack) {
        return BabyTracker.getState(stack).map(state -> {
            Optional loaded = (Optional)CLIENT_STATE_CACHE.getIfPresent((Object)state.getId());
            if (loaded == null) {
                return state;
            }
            if (loaded.isPresent()) {
                BabyTracker.ChildSaveState l = (BabyTracker.ChildSaveState)loaded.get();
                if (state.getName().isPresent() && l.getName().isEmpty() || state.getName().isPresent() && l.getName().isPresent() && !state.getName().get().contentEquals(l.getName().get())) {
                    CLIENT_STATE_CACHE.refresh((Object)state.getId());
                    return state;
                }
                return l;
            }
            return state;
        });
    }

    private static Optional<BabyTracker.ChildSaveState> getClientState(ItemStack stack) {
        return BabyTracker.getState(stack).flatMap(state -> {
            try {
                return (Optional)CLIENT_STATE_CACHE.get((Object)state.getId());
            }
            catch (ExecutionException e) {
                return Optional.of(state);
            }
        });
    }

    public static boolean hasBeenInvalidated(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128471_("invalidated") || BabyTracker.getStateId(stack).map(id -> {
            Optional loaded = (Optional)CLIENT_STATE_CACHE.getIfPresent(id);
            return loaded != null && loaded.isEmpty();
        }).orElse(false) != false;
    }

    private static boolean canGrow(int age) {
        return age >= Config.getInstance().babyItemGrowUpTime;
    }

    private static boolean isReadyToGrowUp(ItemStack stack) {
        return stack.m_41782_() && BabyItem.canGrow(stack.m_41783_().m_128451_("age"));
    }
}

