/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.interaction.gifts;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import forge.net.mca.client.gui.Constraint;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.Chore;
import forge.net.mca.entity.ai.LongTermMemory;
import forge.net.mca.entity.ai.MoodGroup;
import forge.net.mca.entity.ai.Traits;
import forge.net.mca.entity.ai.relationship.AgeState;
import forge.net.mca.entity.ai.relationship.Gender;
import forge.net.mca.entity.ai.relationship.Personality;
import forge.net.mca.resources.Rank;
import forge.net.mca.resources.Tasks;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class GiftPredicate {
    public static final Map<String, Factory<JsonElement>> CONDITION_TYPES = new HashMap<String, Factory<JsonElement>>();
    private final int satisfactionBoost;
    @Nullable
    private final Condition condition;
    List<String> conditionKeys;

    public static float divideAndAdd(JsonObject json, long value) {
        return Mth.m_14036_((float)((float)value / (json.has("dividend") ? json.get("dividend").getAsFloat() : 1.0f) + (json.has("add") ? json.get("add").getAsFloat() : 0.0f)), (float)0.0f, (float)(json.has("max") ? json.get("max").getAsFloat() : 1.0f));
    }

    public static <T> void register(String name, BiFunction<JsonElement, String, T> jsonParser, Factory<T> predicate) {
        CONDITION_TYPES.put(name, json -> predicate.parse(jsonParser.apply((JsonElement)json, name)));
    }

    public static GiftPredicate fromJson(JsonObject json) {
        int satisfaction = 0;
        @Nullable Condition condition = null;
        LinkedList<String> conditionKeys = new LinkedList<String>();
        for (Map.Entry entry : json.entrySet()) {
            if ("satisfaction_boost".equals(entry.getKey())) {
                satisfaction = GsonHelper.m_13897_((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey()));
                continue;
            }
            if (!CONDITION_TYPES.containsKey(entry.getKey())) continue;
            Condition parsed = CONDITION_TYPES.get(entry.getKey()).parse((JsonElement)entry.getValue());
            conditionKeys.add((String)entry.getKey());
            if (condition == null) {
                condition = parsed;
                continue;
            }
            condition = condition.and(parsed);
        }
        return new GiftPredicate(satisfaction, condition, conditionKeys);
    }

    public GiftPredicate(int satisfactionBoost, @Nullable Condition condition, List<String> conditionKeys) {
        this.satisfactionBoost = satisfactionBoost;
        this.condition = condition;
        this.conditionKeys = conditionKeys;
    }

    public float test(VillagerEntityMCA recipient, ItemStack stack, @Nullable ServerPlayer player) {
        return this.condition != null ? this.condition.test(recipient, stack, player) : 0.0f;
    }

    public int getSatisfactionFor(VillagerEntityMCA recipient, ItemStack stack, @Nullable ServerPlayer player) {
        return (int)(this.test(recipient, stack, player) * (float)this.satisfactionBoost);
    }

    public List<String> getConditionKeys() {
        return this.conditionKeys;
    }

    static {
        GiftPredicate.register("profession", (json, name) -> new ResourceLocation(GsonHelper.m_13805_((JsonElement)json, (String)name)), profession -> (villager, stack, player) -> Registry.f_122869_.m_7981_((Object)villager.getProfession()).equals(profession) ? 1.0f : 0.0f);
        GiftPredicate.register("age_group", (json, name) -> AgeState.valueOf(GsonHelper.m_13805_((JsonElement)json, (String)name).toUpperCase(Locale.ENGLISH)), group -> (villager, stack, player) -> villager.getAgeState() == group ? 1.0f : 0.0f);
        GiftPredicate.register("gender", (json, name) -> Gender.valueOf(GsonHelper.m_13805_((JsonElement)json, (String)name).toUpperCase(Locale.ENGLISH)), gender -> (villager, stack, player) -> villager.getGenetics().getGender() == gender ? 1.0f : 0.0f);
        GiftPredicate.register("has_item", (json, name) -> Ingredient.m_43917_((JsonElement)json), item -> (villager, stack, player) -> {
            for (int i = 0; i < villager.m_35311_().m_6643_(); ++i) {
                if (!item.test(villager.m_35311_().m_8020_(i))) continue;
                return 1.0f;
            }
            return 0.0f;
        });
        GiftPredicate.register("min_health", GsonHelper::m_13888_, health -> (villager, stack, player) -> villager.m_21223_() > health.floatValue() ? 1.0f : 0.0f);
        GiftPredicate.register("is_married", GsonHelper::m_13877_, married -> (villager, stack, player) -> villager.getRelationships().isMarried() == married.booleanValue() ? 1.0f : 0.0f);
        GiftPredicate.register("has_home", GsonHelper::m_13877_, hasHome -> (villager, stack, player) -> villager.getResidency().getHome().isPresent() == hasHome.booleanValue() ? 1.0f : 0.0f);
        GiftPredicate.register("has_village", GsonHelper::m_13877_, hasVillage -> (villager, stack, player) -> villager.getResidency().getHomeVillage().isPresent() == hasVillage.booleanValue() ? 1.0f : 0.0f);
        GiftPredicate.register("min_infection_progress", GsonHelper::m_13888_, progress -> (villager, stack, player) -> villager.getInfectionProgress() > progress.floatValue() ? 1.0f : 0.0f);
        GiftPredicate.register("mood", (json, name) -> GsonHelper.m_13805_((JsonElement)json, (String)name).toLowerCase(Locale.ENGLISH), mood -> (villager, stack, player) -> villager.getVillagerBrain().getMood().getName().equals(mood) ? 1.0f : 0.0f);
        GiftPredicate.register("mood_group", (json, name) -> MoodGroup.valueOf(GsonHelper.m_13805_((JsonElement)json, (String)name).toUpperCase(Locale.ENGLISH)), moodGroup -> (villager, stack, player) -> villager.getVillagerBrain().getPersonality().getMoodGroup() == moodGroup ? 1.0f : 0.0f);
        GiftPredicate.register("personality", (json, name) -> Personality.valueOf(GsonHelper.m_13805_((JsonElement)json, (String)name).toUpperCase(Locale.ENGLISH)), personality -> (villager, stack, player) -> villager.getVillagerBrain().getPersonality() == personality ? 1.0f : 0.0f);
        GiftPredicate.register("is_pregnant", GsonHelper::m_13877_, pregnant -> (villager, stack, player) -> villager.getRelationships().getPregnancy().isPregnant() == pregnant.booleanValue() ? 1.0f : 0.0f);
        GiftPredicate.register("min_pregnancy_progress", GsonHelper::m_13897_, progress -> (villager, stack, player) -> villager.getRelationships().getPregnancy().getBabyAge() > progress ? 1.0f : 0.0f);
        GiftPredicate.register("pregnancy_child_gender", (json, name) -> Gender.valueOf(GsonHelper.m_13805_((JsonElement)json, (String)name).toUpperCase(Locale.ENGLISH)), gender -> (villager, stack, player) -> villager.getRelationships().getPregnancy().getGender() == gender ? 1.0f : 0.0f);
        GiftPredicate.register("current_chore", (json, name) -> Chore.valueOf(GsonHelper.m_13805_((JsonElement)json, (String)name).toUpperCase(Locale.ENGLISH)), chore -> (villager, stack, player) -> villager.getVillagerBrain().getCurrentJob() == chore ? 1.0f : 0.0f);
        GiftPredicate.register("item", (json, name) -> {
            ResourceLocation id = new ResourceLocation(GsonHelper.m_13805_((JsonElement)json, (String)name));
            Item item = (Item)Registry.f_122827_.m_6612_(id).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + id + "'"));
            return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)item)});
        }, ingredient -> (villager, stack, player) -> ingredient.test(stack) ? 1.0f : 0.0f);
        GiftPredicate.register("tag", (json, name) -> {
            ResourceLocation id = new ResourceLocation(GsonHelper.m_13805_((JsonElement)json, (String)name));
            TagKey tag = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)id);
            if (tag == null) {
                throw new JsonSyntaxException("Unknown item tag '" + id + "'");
            }
            return Ingredient.m_204132_((TagKey)tag);
        }, ingredient -> (villager, stack, player) -> ingredient.test(stack) ? 1.0f : 0.0f);
        GiftPredicate.register("trait", (json, name) -> Traits.Trait.valueOf(GsonHelper.m_13805_((JsonElement)json, (String)name).toUpperCase(Locale.ENGLISH)), trait -> (villager, stack, player) -> villager.getTraits().hasTrait((Traits.Trait)((Object)trait)) ? 1.0f : 0.0f);
        GiftPredicate.register("hearts_min", GsonHelper::m_13897_, hearts -> (villager, stack, player) -> {
            assert (player != null);
            int h = villager.getVillagerBrain().getMemoriesForPlayer((Player)player).getHearts();
            return h >= hearts ? 1.0f : 0.0f;
        });
        GiftPredicate.register("hearts_max", GsonHelper::m_13897_, hearts -> (villager, stack, player) -> {
            assert (player != null);
            int h = villager.getVillagerBrain().getMemoriesForPlayer((Player)player).getHearts();
            return h <= hearts ? 1.0f : 0.0f;
        });
        GiftPredicate.register("hearts", GsonHelper::m_13918_, json -> (villager, stack, player) -> {
            assert (player != null);
            int h = villager.getVillagerBrain().getMemoriesForPlayer((Player)player).getHearts();
            return GiftPredicate.divideAndAdd(json, h);
        });
        GiftPredicate.register("memory", GsonHelper::m_13918_, json -> (villager, stack, player) -> {
            String id = LongTermMemory.parseId(json, player);
            long ticks = villager.getLongTermMemory().getMemory(id);
            return GiftPredicate.divideAndAdd(json, ticks);
        });
        GiftPredicate.register("emeralds", GsonHelper::m_13897_, amount -> (villager, stack, player) -> player != null && player.m_150109_().m_18947_(Items.f_42616_) >= amount ? 1.0f : 0.0f);
        GiftPredicate.register("village_has_building", GsonHelper::m_13805_, name -> (villager, stack, player) -> villager.getResidency().getHomeVillage().filter(v -> v.hasBuilding((String)name)).isPresent() ? 1.0f : 0.0f);
        GiftPredicate.register("rank", GsonHelper::m_13805_, name -> (villager, stack, player) -> villager.getResidency().getHomeVillage().filter(v -> Tasks.getRank(v, player) == Rank.fromName(name)).isPresent() ? 1.0f : 0.0f);
        GiftPredicate.register("time_min", GsonHelper::m_13891_, time -> (villager, stack, player) -> villager.m_9236_().m_46468_() % 24000L >= time ? 1.0f : 0.0f);
        GiftPredicate.register("time_max", GsonHelper::m_13891_, time -> (villager, stack, player) -> villager.m_9236_().m_46468_() % 24000L <= time ? 1.0f : 0.0f);
        GiftPredicate.register("biome", (json, name) -> new ResourceLocation(GsonHelper.m_13805_((JsonElement)json, (String)name)), biome -> (villager, stack, player) -> villager.m_9236_().m_204166_(villager.m_20183_()).m_203439_().left().filter(b -> b.m_135782_().equals(biome)).isPresent() ? 1.0f : 0.0f);
        GiftPredicate.register("advancement", (json, name) -> new ResourceLocation(GsonHelper.m_13805_((JsonElement)json, (String)name)), id -> (villager, stack, player) -> {
            assert (player != null);
            Advancement advancement = Objects.requireNonNull(player.m_20194_()).m_129889_().m_136041_(id);
            return player.m_8960_().m_135996_(advancement).m_8193_() ? 1.0f : 0.0f;
        });
        GiftPredicate.register("constraints", (json, name) -> Constraint.fromStringList(GsonHelper.m_13805_((JsonElement)json, (String)name)), constraints -> (villager, stack, player) -> {
            Set<Constraint> c = Constraint.allMatching(villager, player);
            return c.containsAll((Collection<?>)constraints) ? 1.0f : 0.0f;
        });
    }

    public static interface Factory<T> {
        public Condition parse(T var1);
    }

    public static interface Condition {
        public float test(VillagerEntityMCA var1, ItemStack var2, @Nullable ServerPlayer var3);

        default public Condition and(Condition b) {
            Condition a = this;
            return (villager, stack, player) -> a.test(villager, stack, player) * b.test(villager, stack, player);
        }
    }
}

