/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.brain.tasks.chore;

import com.google.common.collect.ImmutableMap;
import forge.net.mca.TagsMCA;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.Chore;
import forge.net.mca.entity.ai.TaskUtils;
import forge.net.mca.entity.ai.brain.tasks.chore.AbstractChoreTask;
import forge.net.mca.util.InventoryUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.StemGrownBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class HarvestingTask
extends AbstractChoreTask {
    private static final int TICKS_PER_TURN = 15;
    private static final int ITEM_READY = 0;
    private static final int ITEM_FOUND = 1;
    private static final int ITEM_MISSING = 2;
    private final List<BlockPos> harvestable = new ArrayList<BlockPos>();
    private int lastCropScan = 0;

    public HarvestingTask() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT));
    }

    @Override
    protected boolean shouldRun(ServerLevel world, VillagerEntityMCA villager) {
        return villager.getVillagerBrain().getCurrentJob() == Chore.HARVEST && super.shouldRun(world, villager);
    }

    protected boolean shouldKeepRunning(ServerLevel world, VillagerEntityMCA villager, long time) {
        return this.shouldRun(world, villager);
    }

    protected void finishRunning(ServerLevel world, VillagerEntityMCA villager, long time) {
        ItemStack stack = villager.m_21120_(villager.getDominantHand());
        if (!stack.m_41619_()) {
            villager.m_21008_(villager.getDominantHand(), ItemStack.f_41583_);
        }
    }

    @Override
    protected void run(ServerLevel world, VillagerEntityMCA villager, long time) {
        super.run(world, villager, time);
        if (!villager.m_21033_(villager.getDominantSlot())) {
            int i = InventoryUtils.getFirstSlotContainingItem((Container)villager.m_35311_(), stack -> stack.m_41720_() instanceof HoeItem);
            if (i == -1) {
                this.abandonJobWithMessage("chore.harvesting.nohoe");
            } else {
                ItemStack stack2 = villager.m_35311_().m_8020_(i);
                villager.m_21008_(villager.getDominantHand(), stack2);
            }
        }
    }

    private BlockPos searchCrop(int rangeX, int rangeY, boolean harvestableOnly) {
        List<BlockPos> nearbyCrops = TaskUtils.getNearbyBlocks(this.villager.m_20183_(), this.villager.f_19853_, blockState -> blockState.m_204336_(BlockTags.f_13073_) || blockState.m_60734_() instanceof StemGrownBlock, rangeX, rangeY);
        this.harvestable.clear();
        if (harvestableOnly) {
            this.harvestable.addAll(nearbyCrops.stream().filter(pos -> {
                CropBlock crop;
                BlockState state = this.villager.f_19853_.m_8055_(pos);
                Block patt3805$temp = state.m_60734_();
                return patt3805$temp instanceof CropBlock && (crop = (CropBlock)patt3805$temp).m_52307_(state) || state.m_60734_() instanceof StemGrownBlock;
            }).toList());
        }
        return TaskUtils.getNearestPoint(this.villager.m_20183_(), this.harvestable.isEmpty() ? nearbyCrops : this.harvestable);
    }

    private BlockPos searchUnusedFarmLand(int rangeX, int rangeY) {
        return TaskUtils.getNearestPoint(this.villager.m_20183_(), TaskUtils.getNearbyBlocks(this.villager.m_20183_(), this.villager.f_19853_, blockState -> blockState.m_60713_(Blocks.f_50093_), rangeX, rangeY).stream().filter(pos -> {
            BlockState state = this.villager.f_19853_.m_8055_(pos);
            return state.m_60734_() instanceof FarmBlock && state.m_60710_((LevelReader)this.villager.f_19853_, pos) && this.villager.f_19853_.m_8055_(pos.m_7494_()).m_60795_();
        }).toList());
    }

    @Override
    protected void keepRunning(ServerLevel world, VillagerEntityMCA villager, long time) {
        BlockPos crops;
        if (this.villager == null) {
            this.villager = villager;
        }
        if (!InventoryUtils.contains((Container)villager.m_35311_(), HoeItem.class) && !villager.m_21033_(villager.getDominantSlot())) {
            this.abandonJobWithMessage("chore.harvesting.nohoe");
        } else if (!villager.m_21033_(villager.getDominantSlot())) {
            int i = InventoryUtils.getFirstSlotContainingItem((Container)villager.m_35311_(), stack -> stack.m_41720_() instanceof HoeItem);
            ItemStack stack2 = villager.m_35311_().m_8020_(i);
            villager.m_21008_(villager.getDominantHand(), stack2);
        }
        BlockPos fertileFarmLand = this.searchUnusedFarmLand(16, 3);
        if (fertileFarmLand == null && villager.f_19797_ - this.lastCropScan > 1200) {
            this.lastCropScan = villager.f_19797_;
            fertileFarmLand = this.searchUnusedFarmLand(32, 16);
        }
        if (fertileFarmLand != null && villager.m_35516_()) {
            villager.moveTowards(fertileFarmLand);
            if (villager.m_20238_(Vec3.m_82539_((Vec3i)fertileFarmLand)) <= 6.0 && this.tickAction()) {
                this.plantSeeds(world, villager, fertileFarmLand.m_7494_());
            }
        }
        if ((crops = this.searchCrop(16, 3, true)) == null && villager.f_19797_ - this.lastCropScan > 1200) {
            crops = this.searchCrop(32, 16, true);
        }
        if (crops == null) {
            this.failedTicks = 100;
            return;
        }
        if (this.harvestable.isEmpty()) {
            crops = this.searchCrop(16, 3, false);
        }
        villager.moveTowards(crops);
        if (villager.m_20238_(Vec3.m_82539_((Vec3i)crops)) <= 4.5 && this.tickAction()) {
            BlockState state = world.m_8055_(crops);
            Block block = state.m_60734_();
            if (block instanceof CropBlock) {
                CropBlock crop = (CropBlock)block;
                if (crop.m_52307_(state)) {
                    this.harvestCrops(world, crops);
                    this.plantSeeds(world, villager, crops);
                } else {
                    this.bonemealCrop(world, villager, crops);
                }
            } else if (state.m_60734_() instanceof StemGrownBlock) {
                this.harvestCrops(world, crops);
            }
        }
    }

    private boolean tickAction() {
        return this.villager.f_19853_.m_46467_() % 15L == 0L;
    }

    private int swapItem(Predicate<ItemStack> find) {
        ItemStack stack = this.villager.m_21205_();
        if (find.test(stack)) {
            return 0;
        }
        SimpleContainer inventory = this.villager.m_35311_();
        int slot = InventoryUtils.getFirstSlotContainingItem((Container)inventory, find);
        if (slot < 0) {
            return 2;
        }
        this.villager.m_21008_(this.villager.getDominantHand(), inventory.m_8020_(slot));
        return 1;
    }

    private boolean plantSeed(ItemStack itemStack, ServerLevel serverWorld, BlockPos currentTarget) {
        Item item = itemStack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return serverWorld.m_7731_(currentTarget, blockItem.m_40614_().m_49966_(), 3);
        }
        return false;
    }

    private void plantSeeds(ServerLevel world, VillagerEntityMCA villager, BlockPos target) {
        BlockHitResult hitResult = new BlockHitResult(Vec3.m_82539_((Vec3i)target), Direction.DOWN, target, true);
        InteractionResult result = InventoryUtils.stream((Container)villager.m_35311_()).filter(stack -> !stack.m_41619_() && stack.m_41720_() instanceof BlockItem && stack.m_204117_(TagsMCA.Items.VILLAGER_PLANTABLE)).filter(stack -> {
            if (this.plantSeed((ItemStack)stack, world, hitResult.m_82425_())) {
                stack.m_41774_(1);
                return true;
            }
            return false;
        }).findFirst().map(v -> InteractionResult.SUCCESS).orElse(InteractionResult.FAIL);
        if (result.m_19077_()) {
            if (result.m_19080_()) {
                villager.m_6674_(villager.getDominantHand());
            }
        } else if (this.getAssigningPlayer().isPresent()) {
            villager.sendChatMessage(this.getAssigningPlayer().get(), "chore.harvesting.noseed", new Object[0]);
        }
    }

    private void bonemealCrop(ServerLevel world, VillagerEntityMCA villager, BlockPos pos) {
        if (this.swapItem(stack -> stack.m_41720_() instanceof BoneMealItem) == 0 && BoneMealItem.m_40627_((ItemStack)villager.m_6844_(villager.getDominantSlot()), (Level)world, (BlockPos)pos)) {
            villager.m_6674_(villager.getDominantHand());
        }
    }

    private void harvestCrops(ServerLevel world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        LootContext.Builder lootcontext$builder = new LootContext.Builder(world).m_78972_(LootContextParams.f_81460_, (Object)this.villager.m_20182_()).m_78972_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_78972_(LootContextParams.f_81455_, (Object)this.villager).m_78972_(LootContextParams.f_81461_, (Object)state).m_230911_(this.villager.m_217043_()).m_78963_(0.0f);
        ObjectArrayList drops = world.m_7654_().m_129898_().m_79217_(state.m_60734_().m_60589_()).m_230922_(lootcontext$builder.m_78975_(LootContextParamSets.f_81421_));
        for (ItemStack stack : drops) {
            this.villager.m_35311_().m_19173_(stack);
        }
        world.m_46953_(pos, false, (Entity)this.villager);
    }
}

