/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.brain.tasks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.Nullable;

public class SmarterOpenDoorsTask
extends Behavior<LivingEntity> {
    private static final int RUN_TIME = 20;
    private static final double PATHING_DISTANCE = 2.0;
    private static final double REACH_DISTANCE = 2.0;
    @Nullable
    private Node pathNode;
    private int ticks;

    public SmarterOpenDoorsTask() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26377_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26379_, (Object)MemoryStatus.REGISTERED));
    }

    protected boolean m_6114_(ServerLevel world, LivingEntity entity) {
        Path path = (Path)entity.m_6274_().m_21952_(MemoryModuleType.f_26377_).get();
        if (path.m_77387_() || path.m_77392_()) {
            return false;
        }
        if (!Objects.equals(this.pathNode, path.m_77401_())) {
            this.ticks = 20;
            return true;
        }
        if (this.ticks > 0) {
            --this.ticks;
        }
        return this.ticks == 0;
    }

    protected void m_6735_(ServerLevel world, LivingEntity entity, long time) {
        DoorBlock doorBlock2;
        BlockPos blockPos2;
        BlockState blockState2;
        Path path = (Path)entity.m_6274_().m_21952_(MemoryModuleType.f_26377_).get();
        this.pathNode = path.m_77401_();
        Node pathNode = path.m_77402_();
        Node pathNode2 = path.m_77401_();
        BlockPos blockPos = pathNode.m_77288_();
        BlockState blockState = world.m_8055_(blockPos);
        if (blockState.m_204338_(BlockTags.f_13095_, state -> state.m_60734_() instanceof DoorBlock)) {
            DoorBlock doorBlock = (DoorBlock)blockState.m_60734_();
            if (!doorBlock.m_52815_(blockState)) {
                doorBlock.m_153165_((Entity)entity, (Level)world, blockState, blockPos, true);
            }
            this.rememberToCloseDoor(world, entity, blockPos);
        }
        if ((blockState2 = world.m_8055_(blockPos2 = pathNode2.m_77288_())).m_204338_(BlockTags.f_13095_, state -> state.m_60734_() instanceof DoorBlock) && !(doorBlock2 = (DoorBlock)blockState2.m_60734_()).m_52815_(blockState2)) {
            doorBlock2.m_153165_((Entity)entity, (Level)world, blockState2, blockPos2, true);
            this.rememberToCloseDoor(world, entity, blockPos2);
        }
        SmarterOpenDoorsTask.pathToDoor(world, entity, pathNode, pathNode2);
    }

    public static void pathToDoor(ServerLevel world, LivingEntity entity, @Nullable Node lastNode, @Nullable Node currentNode) {
        Brain brain = entity.m_6274_();
        if (brain.m_21874_(MemoryModuleType.f_26379_)) {
            Iterator iterator = ((Set)brain.m_21952_(MemoryModuleType.f_26379_).get()).iterator();
            while (iterator.hasNext()) {
                GlobalPos globalPos = (GlobalPos)iterator.next();
                BlockPos blockPos = globalPos.m_122646_();
                if (lastNode != null && lastNode.m_77288_().equals((Object)blockPos) || currentNode != null && currentNode.m_77288_().equals((Object)blockPos)) continue;
                if (SmarterOpenDoorsTask.cannotReachDoor(world, entity, globalPos)) {
                    iterator.remove();
                    continue;
                }
                BlockState blockState = world.m_8055_(blockPos);
                if (!blockState.m_204338_(BlockTags.f_13095_, state -> state.m_60734_() instanceof DoorBlock)) {
                    iterator.remove();
                    continue;
                }
                DoorBlock doorBlock = (DoorBlock)blockState.m_60734_();
                if (!doorBlock.m_52815_(blockState)) {
                    iterator.remove();
                    continue;
                }
                if (SmarterOpenDoorsTask.hasOtherMobReachedDoor(world, entity, blockPos)) {
                    iterator.remove();
                    continue;
                }
                doorBlock.m_153165_((Entity)entity, (Level)world, blockState, blockPos, false);
                iterator.remove();
            }
        }
    }

    private static boolean hasOtherMobReachedDoor(ServerLevel world, LivingEntity entity, BlockPos pos) {
        Brain brain = entity.m_6274_();
        if (!brain.m_21874_(MemoryModuleType.f_148204_)) {
            return false;
        }
        return ((List)brain.m_21952_(MemoryModuleType.f_148204_).get()).stream().filter(livingEntity2 -> livingEntity2.m_6095_() == entity.m_6095_()).filter(livingEntity -> pos.m_203195_((Position)livingEntity.m_20182_(), 2.0)).anyMatch(livingEntity -> SmarterOpenDoorsTask.hasReached(world, livingEntity, pos));
    }

    private static boolean hasReached(ServerLevel world, LivingEntity entity, BlockPos pos) {
        if (!entity.m_6274_().m_21874_(MemoryModuleType.f_26377_)) {
            return false;
        }
        Path path = (Path)entity.m_6274_().m_21952_(MemoryModuleType.f_26377_).get();
        if (path.m_77392_()) {
            return false;
        }
        Node pathNode = path.m_77402_();
        if (pathNode == null) {
            return false;
        }
        Node pathNode2 = path.m_77401_();
        return pos.equals((Object)pathNode.m_77288_()) || pos.equals((Object)pathNode2.m_77288_());
    }

    private static boolean cannotReachDoor(ServerLevel world, LivingEntity entity, GlobalPos doorPos) {
        return doorPos.m_122640_() != world.m_46472_() || !doorPos.m_122646_().m_203195_((Position)entity.m_20182_(), 2.0);
    }

    private void rememberToCloseDoor(ServerLevel world, LivingEntity entity, BlockPos pos) {
        Brain brain = entity.m_6274_();
        GlobalPos globalPos = GlobalPos.m_122643_((ResourceKey)world.m_46472_(), (BlockPos)pos);
        if (brain.m_21952_(MemoryModuleType.f_26379_).isPresent()) {
            ((Set)brain.m_21952_(MemoryModuleType.f_26379_).get()).add(globalPos);
        } else {
            brain.m_21879_(MemoryModuleType.f_26379_, (Object)Sets.newHashSet((Object[])new GlobalPos[]{globalPos}));
        }
    }
}

