/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.brain.tasks;

import com.google.common.collect.ImmutableMap;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.server.world.data.Building;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.InteractWithDoor;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.schedule.Activity;

public class ExtendedSleepTask
extends Behavior<VillagerEntityMCA> {
    private long startTime;
    private final float speed;
    private BlockPos bed;
    private long lastFail = 0L;
    private static final long TICKS_BETWEEN_FAILS = 200L;

    public ExtendedSleepTask(float speed) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26359_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26329_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED));
        this.speed = speed;
    }

    protected boolean shouldRun(ServerLevel world, VillagerEntityMCA entity) {
        if (world.m_46467_() - this.lastFail < 200L) {
            return false;
        }
        boolean b = this.shouldRunInner(world, entity);
        if (!b && entity.m_5803_()) {
            entity.m_5796_();
        }
        return b;
    }

    private boolean shouldRunInner(ServerLevel world, VillagerEntityMCA entity) {
        long l;
        if (entity.m_20159_()) {
            return false;
        }
        Brain brain = entity.m_6274_();
        GlobalPos globalPos = (GlobalPos)brain.m_21952_(MemoryModuleType.f_26359_).get();
        if (world.m_46472_() != globalPos.m_122640_()) {
            return false;
        }
        Optional optional = brain.m_21952_(MemoryModuleType.f_26329_);
        if (optional.isPresent() && (l = world.m_46467_() - (Long)optional.get()) > 0L && l < 100L) {
            return false;
        }
        Optional<Building> building = entity.getResidency().getHomeBuilding();
        if (building.isPresent()) {
            Optional<BlockPos> bed = building.get().findClosestEmptyBed(world, globalPos.m_122646_());
            if (bed.isPresent()) {
                this.bed = bed.get();
                if (globalPos.m_122646_().m_203195_((Position)entity.m_20182_(), 2.0)) {
                    return true;
                }
                brain.m_21879_(MemoryModuleType.f_26370_, (Object)new WalkTarget(globalPos.m_122646_(), this.speed, 1));
                return false;
            }
            this.lastFail = world.m_46467_();
        } else {
            this.lastFail = world.m_46467_();
        }
        return false;
    }

    protected boolean shouldKeepRunning(ServerLevel world, VillagerEntityMCA entity, long time) {
        if (this.bed != null) {
            return entity.m_6274_().m_21954_(Activity.f_37982_) && entity.m_20186_() > (double)this.bed.m_123342_() + 0.4 && this.bed.m_203195_((Position)entity.m_20182_(), 1.14);
        }
        return false;
    }

    protected void run(ServerLevel world, VillagerEntityMCA entity, long time) {
        if (time > this.startTime) {
            InteractWithDoor.m_23298_((ServerLevel)world, (LivingEntity)entity, null, null);
            entity.m_5802_(this.bed);
        }
    }

    protected boolean m_7773_(long time) {
        return false;
    }

    protected void finishRunning(ServerLevel world, VillagerEntityMCA entity, long time) {
        if (entity.m_5803_()) {
            entity.m_5796_();
            this.startTime = time + 40L;
        }
    }
}

