/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.brain.tasks;

import com.google.common.collect.ImmutableMap;
import forge.net.mca.entity.VillagerLike;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class ExtendedMeleeAttackTask
extends Behavior<Mob> {
    private final float range;
    private final int interval;
    private final MemoryModuleType<? extends LivingEntity> target;

    public ExtendedMeleeAttackTask(int interval, float range) {
        this(interval, range, (MemoryModuleType<? extends LivingEntity>)MemoryModuleType.f_26372_);
    }

    public ExtendedMeleeAttackTask(int interval, float range, MemoryModuleType<? extends LivingEntity> target) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED, target, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_26373_, (Object)MemoryStatus.VALUE_ABSENT));
        this.range = range;
        this.interval = interval;
        this.target = target;
    }

    protected boolean shouldRun(ServerLevel serverWorld, Mob attacker) {
        LivingEntity target = this.getTarget(attacker);
        return BehaviorUtils.m_22667_((LivingEntity)attacker, (LivingEntity)target) && this.withinRange((LivingEntity)attacker, target);
    }

    protected void run(ServerLevel serverWorld, Mob mobEntity, long l) {
        LivingEntity livingEntity = this.getTarget(mobEntity);
        BehaviorUtils.m_22595_((LivingEntity)mobEntity, (LivingEntity)livingEntity);
        if (mobEntity instanceof VillagerLike) {
            VillagerLike villager = (VillagerLike)mobEntity;
            mobEntity.m_6674_(villager.getDominantHand());
        } else {
            mobEntity.m_6674_(InteractionHand.MAIN_HAND);
        }
        mobEntity.m_7327_((Entity)livingEntity);
        mobEntity.m_6274_().m_21882_(MemoryModuleType.f_26373_, (Object)true, (long)this.interval);
    }

    private boolean withinRange(LivingEntity attacker, LivingEntity target) {
        double r;
        double d = attacker.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
        return d <= (r = (double)(attacker.m_20205_() + target.m_20205_() + this.range));
    }

    private LivingEntity getTarget(Mob mobEntity) {
        return (LivingEntity)mobEntity.m_6274_().m_21952_(this.target).get();
    }
}

