/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.brain.tasks;

import com.google.common.collect.ImmutableMap;
import forge.net.mca.entity.EquipmentSet;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.MemoryModuleTypeMCA;
import forge.net.mca.util.InventoryUtils;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class EquipmentTask
extends Behavior<VillagerEntityMCA> {
    private static final int COOLDOWN = 100;
    private int lastEquipTime;
    private final Predicate<VillagerEntityMCA> condition;
    private final Function<VillagerEntityMCA, EquipmentSet> equipmentSet;
    private boolean lastArmorWearState;

    public EquipmentTask(Predicate<VillagerEntityMCA> condition, Function<VillagerEntityMCA, EquipmentSet> set) {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)MemoryModuleTypeMCA.WEARS_ARMOR.get()), (Object)MemoryStatus.REGISTERED));
        this.condition = condition;
        this.equipmentSet = set;
    }

    protected boolean shouldRun(ServerLevel world, VillagerEntityMCA villager) {
        if (this.lastArmorWearState != villager.getVillagerBrain().getArmorWear()) {
            return true;
        }
        boolean present = villager.m_6274_().m_21952_((MemoryModuleType)MemoryModuleTypeMCA.WEARS_ARMOR.get()).isPresent();
        if (this.condition.test(villager)) {
            this.lastEquipTime = villager.f_19797_;
            return !present || this.equipmentSet.apply(villager).getMainHand() != Items.f_41852_ && villager.m_21205_().m_41619_();
        }
        if (villager.f_19797_ - this.lastEquipTime > 100) {
            return present;
        }
        return false;
    }

    private void equipBestArmor(VillagerEntityMCA villager, EquipmentSlot slot, Item fallback) {
        ItemStack stack = InventoryUtils.getBestArmor((Container)villager.m_35311_(), slot).orElse(new ItemStack((ItemLike)fallback));
        villager.m_8061_(slot, stack);
    }

    private void equipBestWeapon(VillagerEntityMCA villager, Item fallback) {
        ItemStack stack = InventoryUtils.getBestSword((Container)villager.m_35311_()).orElse(new ItemStack((ItemLike)fallback));
        villager.m_8061_(villager.getDominantSlot(), stack);
    }

    protected void run(ServerLevel world, VillagerEntityMCA villager, long time) {
        super.m_6735_(world, (LivingEntity)villager, time);
        this.lastArmorWearState = villager.getVillagerBrain().getArmorWear();
        EquipmentSet set = this.equipmentSet.apply(villager);
        boolean wear = this.condition.test(villager);
        if (wear) {
            villager.m_6274_().m_21879_((MemoryModuleType)MemoryModuleTypeMCA.WEARS_ARMOR.get(), (Object)true);
        } else {
            villager.m_6274_().m_21936_((MemoryModuleType)MemoryModuleTypeMCA.WEARS_ARMOR.get());
        }
        if (wear) {
            this.equipBestWeapon(villager, set.getMainHand());
            villager.m_8061_(villager.getOpposingSlot(), new ItemStack((ItemLike)set.getGetOffHand()));
        } else {
            villager.m_21008_(villager.getDominantHand(), ItemStack.f_41583_);
            villager.m_21008_(villager.getOpposingHand(), ItemStack.f_41583_);
        }
        if (wear || villager.getVillagerBrain().getArmorWear()) {
            this.equipBestArmor(villager, EquipmentSlot.HEAD, set.getHead());
            this.equipBestArmor(villager, EquipmentSlot.CHEST, set.getChest());
            this.equipBestArmor(villager, EquipmentSlot.LEGS, set.getLegs());
            this.equipBestArmor(villager, EquipmentSlot.FEET, set.getFeet());
        } else {
            villager.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
            villager.m_8061_(EquipmentSlot.CHEST, ItemStack.f_41583_);
            villager.m_8061_(EquipmentSlot.LEGS, ItemStack.f_41583_);
            villager.m_8061_(EquipmentSlot.FEET, ItemStack.f_41583_);
        }
    }
}

