/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai;

import forge.net.mca.Config;
import forge.net.mca.entity.VillagerLike;
import forge.net.mca.util.network.datasync.CDataManager;
import forge.net.mca.util.network.datasync.CDataParameter;
import forge.net.mca.util.network.datasync.CParameter;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;

public class Traits {
    private static final CDataParameter<CompoundTag> TRAITS = CParameter.create("traits", new CompoundTag());
    private RandomSource random;
    private final VillagerLike<?> entity;

    public static <E extends Entity> CDataManager.Builder<E> createTrackedData(CDataManager.Builder<E> builder) {
        return builder.addAll(TRAITS);
    }

    public Traits(VillagerLike<?> entity) {
        this.entity = entity;
        this.random = RandomSource.m_216335_((long)entity.asEntity().f_19853_.f_46441_.m_188505_());
    }

    public Set<Trait> getTraits() {
        return ((CompoundTag)this.entity.getTrackedValue(TRAITS)).m_128431_().stream().map(Trait::valueOf).collect(Collectors.toSet());
    }

    public Set<Trait> getInheritedTraits() {
        return this.getTraits().stream().filter(t -> this.random.m_188501_() < t.inherit * Config.getInstance().traitInheritChance).collect(Collectors.toSet());
    }

    public boolean hasTrait(VillagerLike<?> target, Trait trait) {
        return ((CompoundTag)target.getTrackedValue(TRAITS)).m_128441_(trait.name());
    }

    public boolean hasTrait(Trait trait) {
        return this.hasTrait(this.entity, trait);
    }

    public boolean hasTrait(String trait) {
        return this.hasTrait(this.entity, Trait.valueOf(trait.toUpperCase()));
    }

    public boolean eitherHaveTrait(Trait trait, VillagerLike<?> other) {
        return this.hasTrait(this.entity, trait) || this.hasTrait(other, trait);
    }

    public boolean hasSameTrait(Trait trait, VillagerLike<?> other) {
        return this.hasTrait(this.entity, trait) && this.hasTrait(other, trait);
    }

    public void addTrait(Trait trait) {
        CompoundTag traits = ((CompoundTag)this.entity.getTrackedValue(TRAITS)).m_6426_();
        traits.m_128379_(trait.name(), true);
        this.entity.setTrackedValue(TRAITS, traits);
    }

    public void removeTrait(Trait trait) {
        CompoundTag traits = ((CompoundTag)this.entity.getTrackedValue(TRAITS)).m_6426_();
        traits.m_128473_(trait.name());
        this.entity.setTrackedValue(TRAITS, traits);
    }

    public void randomize() {
        float total = (float)Arrays.stream(Trait.values()).mapToDouble(tr -> tr.chance).sum();
        for (Trait t : Trait.values()) {
            float chance = Config.getInstance().traitChance / total * t.chance;
            if (!(this.random.m_188501_() < chance)) continue;
            this.addTrait(t);
        }
    }

    public void inherit(Traits from) {
        for (Trait t : from.getInheritedTraits()) {
            this.addTrait(t);
        }
    }

    public void inherit(Traits from, long seed) {
        RandomSource old = this.random;
        this.random = RandomSource.m_216335_((long)seed);
        this.inherit(from);
        this.random = old;
    }

    public float getVerticalScaleFactor() {
        return this.hasTrait(Trait.DWARFISM) ? 0.65f : 1.0f;
    }

    public float getHorizontalScaleFactor() {
        return this.hasTrait(Trait.DWARFISM) ? 0.85f : 1.0f;
    }

    public static enum Trait {
        LEFT_HANDED(1.0f, 0.5f, false),
        COLOR_BLIND(1.0f, 0.5f),
        HETEROCHROMIA(1.0f, 2.0f),
        LACTOSE_INTOLERANCE(1.0f, 1.0f),
        COELIAC_DISEASE(1.0f, 1.0f, false),
        DIABETES(1.0f, 1.0f, false),
        DWARFISM(1.0f, 1.0f),
        ALBINISM(1.0f, 1.0f),
        VEGETARIAN(1.0f, 0.0f, false),
        BISEXUAL(1.0f, 0.0f),
        HOMOSEXUAL(1.0f, 0.0f),
        ELECTRIFIED(0.0f, 0.0f, false),
        SIRBEN(0.025f, 1.0f, false),
        RAINBOW(0.05f, 0.0f);

        private final float chance;
        private final float inherit;
        private final boolean usableOnPlayer;

        private Trait(float chance, float inherit, boolean usableOnPlayer) {
            this.chance = chance;
            this.inherit = inherit;
            this.usableOnPlayer = usableOnPlayer;
        }

        private Trait(float chance, float inherit) {
            this(chance, inherit, true);
        }

        public Component getName() {
            return Component.m_237115_((String)("trait." + this.name().toLowerCase(Locale.ENGLISH)));
        }

        public Component getDescription() {
            return Component.m_237115_((String)("traitDescription." + this.name().toLowerCase(Locale.ENGLISH)));
        }

        public boolean isUsableOnPlayer() {
            return this.usableOnPlayer;
        }
    }
}

