/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai;

import forge.net.mca.Config;
import forge.net.mca.MCA;
import forge.net.mca.entity.EntityWrapper;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.DialogueType;
import forge.net.mca.entity.ai.relationship.family.FamilyTree;
import forge.net.mca.entity.ai.relationship.family.FamilyTreeNode;
import forge.net.mca.resources.API;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public interface Messenger
extends EntityWrapper {
    public static final TargetingConditions CAN_RECEIVE = TargetingConditions.m_148353_();

    default public boolean isSpeechImpaired() {
        return false;
    }

    default public boolean isToYoungToSpeak() {
        return false;
    }

    default public void playSpeechEffect() {
    }

    default public DialogueType getDialogueType(Player receiver) {
        return DialogueType.UNASSIGNED;
    }

    default public MutableComponent getTranslatable(Player target, String phraseId, Object ... params) {
        Mob mob;
        Mob mob2;
        String targetName;
        Level level = target.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            targetName = FamilyTree.get(world).getOrEmpty(target.m_20148_()).map(FamilyTreeNode::getName).filter(n -> !MCA.isBlankString(n)).orElse(target.m_7755_().getString());
        } else {
            targetName = target.m_7755_().getString();
        }
        Object[] newParams = new Object[params.length + 1];
        System.arraycopy(params, 0, newParams, 1, params.length);
        newParams[0] = targetName;
        Object professionString = "";
        if (!this.asEntity().m_6162_() && (mob2 = this.asEntity()) instanceof VillagerEntityMCA) {
            VillagerEntityMCA v = (VillagerEntityMCA)mob2;
            professionString = "#P" + Registry.f_122869_.m_7981_((Object)v.getProfession()).m_135815_() + ".";
        }
        Object personalityString = "";
        if (!this.asEntity().m_6162_() && (mob = this.asEntity()) instanceof VillagerEntityMCA) {
            VillagerEntityMCA v = (VillagerEntityMCA)mob;
            personalityString = "#E" + v.getVillagerBrain().getPersonality().name() + ".";
        }
        return Component.m_237110_((String)((String)personalityString + (String)professionString + "#T" + this.getDialogueType(target).name() + "." + phraseId), (Object[])newParams);
    }

    default public void sendChatToAllAround(String phrase, Object ... params) {
        for (Player player : this.asEntity().f_19853_.m_45955_(CAN_RECEIVE, (LivingEntity)this.asEntity(), this.asEntity().m_20191_().m_82400_(20.0))) {
            float dist = player.m_20270_((Entity)this.asEntity());
            this.sendChatMessage(this.getTranslatable(player, phrase, params).m_130940_(dist < 10.0f ? ChatFormatting.WHITE : ChatFormatting.GRAY), (Entity)player);
        }
    }

    default public void sendChatMessage(Player target, String phraseId, Object ... params) {
        this.sendChatMessage(this.getTranslatable(target, phraseId, params), (Entity)target);
    }

    default public void sendChatMessage(MutableComponent message, Entity receiver) {
        if (this.isSpeechImpaired()) {
            message = Component.m_237115_((String)API.getRandomSentence("zombie", message.getString()));
        } else if (this.isToYoungToSpeak()) {
            message = Component.m_237115_((String)API.getRandomSentence("baby", message.getString()));
        }
        MutableComponent textToSend = Component.m_237113_((String)Config.getInstance().villagerChatPrefix).m_7220_(this.asEntity().m_5446_()).m_130946_(": ").m_7220_((Component)message);
        receiver.m_213846_((Component)textToSend);
        this.playSpeechEffect();
    }

    default public void sendEventMessage(Component message, Player receiver) {
        receiver.m_5661_(message, true);
    }

    default public void sendEventMessage(Component message) {
        if (!(this instanceof Entity)) {
            return;
        }
        Messenger.sendEventMessage(((Entity)this).f_19853_, message);
    }

    public static void sendEventMessage(Level world, Component message) {
        world.m_6907_().forEach(player -> player.m_5661_(message, true));
    }
}

