/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.client.render.layer;

import forge.net.mca.client.model.CommonVillagerModel;
import forge.net.mca.client.render.layer.VillagerLayer;
import forge.net.mca.client.resources.ColorPalette;
import forge.net.mca.entity.ai.Genetics;
import forge.net.mca.entity.ai.Traits;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;

public class HairLayer<T extends LivingEntity, M extends HumanoidModel<T>>
extends VillagerLayer<T, M> {
    public HairLayer(RenderLayerParent<T, M> renderer, M model) {
        super(renderer, model);
        this.model.f_102814_.f_104207_ = false;
        this.model.f_102813_.f_104207_ = false;
    }

    @Override
    protected ResourceLocation getSkin(T villager) {
        return this.cached(CommonVillagerModel.getVillager(villager).getHair(), ResourceLocation::new);
    }

    @Override
    protected ResourceLocation getOverlay(T villager) {
        return this.cached(CommonVillagerModel.getVillager(villager).getHair().replace(".png", "_overlay.png"), ResourceLocation::new);
    }

    private float[] getRainbow(LivingEntity entity, float tickDelta) {
        int n = Math.abs(entity.f_19797_) / 25 + entity.m_19879_();
        int o = DyeColor.values().length;
        int p = n % o;
        int q = (n + 1) % o;
        float r = ((float)(Math.abs(entity.f_19797_) % 25) + tickDelta) / 25.0f;
        float[] fs = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)p));
        float[] gs = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)q));
        return new float[]{fs[0] * (1.0f - r) + gs[0] * r, fs[1] * (1.0f - r) + gs[1] * r, fs[2] * (1.0f - r) + gs[2] * r};
    }

    @Override
    protected float[] getColor(T villager, float tickDelta) {
        if (CommonVillagerModel.getVillager(villager).getTraits().hasTrait(Traits.Trait.RAINBOW)) {
            return this.getRainbow((LivingEntity)villager, tickDelta);
        }
        float[] hairDye = CommonVillagerModel.getVillager(villager).getHairDye();
        if (hairDye[0] > 0.0f) {
            return hairDye;
        }
        float albinism = CommonVillagerModel.getVillager(villager).getTraits().hasTrait(Traits.Trait.ALBINISM) ? 0.1f : 1.0f;
        return ColorPalette.HAIR.getColor(CommonVillagerModel.getVillager(villager).getGenetics().getGene(Genetics.EUMELANIN) * albinism, CommonVillagerModel.getVillager(villager).getGenetics().getGene(Genetics.PHEOMELANIN) * albinism, 0.0f);
    }
}

